/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertfilter.selecttool;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.expertfilter.selecttool.IPdsExpertInitModel;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsExpertInitModel
implements IPdsExpertInitModel<ExpertContext> {
    @Override
    public void initModel(ExpertContext context) {
        this.initProject(context);
        if (context.getProjectObj() == null) {
            return;
        }
        this.initPurOrg(context);
        this.initOtherInfo(context);
    }

    public void initProject(ExpertContext context) {
        Map<String, Object> paramMap = context.getParamMap();
        long projectId = PdsCommonUtils.object2Long(paramMap.get("project"));
        if (projectId == 0L) {
            return;
        }
        context.getView().getModel().setValue("project", (Object)projectId);
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        context.setProjectObj(projectObj);
    }

    public void initPurOrg(ExpertContext context) {
        DynamicObjectCollection rows = context.getProjectObj().getDynamicObjectCollection("purorg");
        if (rows == null || rows.size() == 0) {
            long purOrgId = context.getProjectObj().getLong("org.id");
            context.getView().getModel().setValue("purorg", (Object)new Object[]{purOrgId});
        } else {
            context.getView().getModel().setValue("purorg", (Object)rows);
        }
    }

    public void initOtherInfo(ExpertContext context) {
        context.getView().getModel().setValue("sourcetype", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("sourcetype")));
        long packageId = PdsCommonUtils.object2Long(context.getParamMap().get("packageid"));
        Object[] packageObj = new Object[]{packageId};
        context.getView().getModel().setValue("package", (Object)packageObj);
        String managetype = context.getProjectObj().getString("managetype");
        context.getView().getModel().setValue("managetype", (Object)managetype);
        context.getView().getModel().setValue("indextype", context.getParamMap().get("indextypeid"));
        Set<Long> scorreIds = PdsCommonUtils.object2Set(context.getParamMap().get("select_ids"));
        MultiBasedataUtils.setMultiBasedataForModel(context.getView().getModel(), scorreIds, "scorers");
        context.getView().getModel().setValue("datefrom", context.getParamMap().get("datefrom"));
        context.getView().getModel().setValue("dateto", context.getParamMap().get("dateto"));
        int expertcount = PdsCommonUtils.object2Integer(context.getParamMap().get("expertcount"));
        if (expertcount > 0) {
            context.getView().getModel().setValue("expertcount", context.getParamMap().get("expertcount"));
            context.getView().setEnable(Boolean.valueOf(false), new String[]{"expertcount"});
        }
    }
}

