/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertfilter.selecttool;

import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.expertfilter.expertfilter.ExpertFilterUtils;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.expertfilter.selecttool.PdsExpertRecordLog;
import kd.scm.pds.common.expertfilter.selecttool.PdsExpertSelectUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class PdsExpertSelectHelper
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PdsExpertSelectUtils.setQueryConditionVisible(this.getView(), Boolean.FALSE);
        ExpertContext context = this.getExpertContext();
        PdsExpertSelectUtils.initModel(context);
        PdsExpertSelectUtils.initContext(context);
        if (ExpertFilterUtils.isAutoQueryAndShow(context)) {
            this.queryAndShowExpert(context, true);
        } else {
            this.queryAndShowExpert(context, false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        ExpertContext context = null;
        QFilter qfilters = null;
        String entityName = null;
        switch (opKey) {
            case "confirm": {
                context = this.getExpertContext();
                PdsExpertSelectUtils.returnData(context);
                evt.setCancel(!context.isSucced());
                break;
            }
            case "refresh": {
                PdsExpertSelectUtils.setQueryConditionVisible(this.getView(), Boolean.FALSE);
                context = this.getExpertContext();
                PdsExpertSelectUtils.initContext(context);
                this.queryAndShowExpert(context, true);
                break;
            }
            case "expert": {
                entityName = "src_expert";
                qfilters = QFilter.fromSerializedString((String)this.getView().getPageCache().get(entityName));
                OpenFormUtils.openListPage(this.getView(), entityName, ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "logquery": {
                qfilters = new QFilter("project", "=", (Object)this.getModel().getDataEntity().getLong("project.id"));
                OpenFormUtils.openListPage(this.getView(), "pds_expselectlog", ShowType.MainNewTabPage, null, qfilters, null);
                break;
            }
            case "exit": {
                this.exit();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin(PdsExpertRecordLog.class.getSimpleName(), context, true);
    }

    private void getExpertIds(ExpertContext context) {
        ExpertFilterUtils.getExpertQFilter(this.getView(), context);
        if (!context.isEmpty() && context.getUltimateQFilter() != null) {
            if (this.isAdd()) {
                context.getUltimateQFilter().and("id", "not in", this.getPreExpertIds());
            }
            this.getModel().setValue("qfilter_tag", (Object)context.getUltimateQFilter().toSerializedString());
            DynamicObjectCollection rows = QueryServiceHelper.query((String)context.getMainDataType(), (String)"id", (QFilter[])context.getUltimateQFilter().toArray());
            if (null != rows && rows.size() > 0) {
                Set<Long> expertIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                expertIds = RandomUtils.getRandomElement(expertIds, context.getRandomCount());
                context.setExpertUserIds(expertIds);
            }
        }
    }

    private void queryAndShowExpert(ExpertContext context, boolean isShowExpert) {
        this.getExpertIds(context);
        if (isShowExpert) {
            this.showExpert(context);
            this.showCondition(context);
        }
    }

    private void showExpert(ExpertContext context) {
        DynamicObject[] objs;
        Set<Long> expertIds = context.getExpertUserIds();
        if (expertIds.size() > 0) {
            this.addTurns(expertIds.size());
        } else if (this.isAdd()) {
            return;
        }
        String selects = "id";
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (!this.isAdd()) {
            model.deleteEntryData("entryentity");
        }
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)context.getMainDataType(), (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "in", expertIds)})) {
            ts.set("isinvite", (Object)Boolean.TRUE, i);
            ts.set("expert", (Object)obj.getLong("id"), i);
            if (!"src_expert".equals(context.getBaseDataType()) && context.getBaseDataType().equals(context.getMainDataType())) {
                ts.set("maindata", (Object)obj.getLong("id"), i);
            }
            ts.set("entryentityturns", (Object)this.getTurns(), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private ExpertContext getExpertContext() {
        ExpertContext context = PdsExpertSelectUtils.getContextInstance();
        context.setView(this.getView());
        FormShowParameter formShowPara = this.getView().getFormShowParameter();
        context.setParamMap(formShowPara.getCustomParams());
        return context;
    }

    private boolean isAdd() {
        return this.getModel().getDataEntity().getBoolean("isadd");
    }

    private Set<Long> getPreExpertIds() {
        DynamicObjectCollection rows = this.getView().getModel().getEntryEntity("entryentity");
        return rows.stream().map(e -> e.getLong("expert.id")).collect(Collectors.toSet());
    }

    private int getTurns() {
        return this.getModel().getDataEntity().getInt("turns");
    }

    private void addTurns(int number) {
        this.getModel().setValue("turns", (Object)(this.getTurns() + 1));
        this.getModel().setValue("number", (Object)number);
    }

    private int getNumber() {
        return this.getModel().getDataEntity().getInt("number");
    }

    private void showCondition(ExpertContext context) {
        if (null == context.getExpertUserIds() || context.getExpertUserIds().size() == 0) {
            return;
        }
        StringBuilder qfilterSb = new StringBuilder();
        StringBuilder descriptionSb = new StringBuilder();
        StringBuilder prefixSb = new StringBuilder();
        prefixSb.append(String.format(ResManager.loadKDString((String)"\u62bd\u53d6\u8f6e\u6b21(%1$s)\uff0c\u62bd\u53d6\u6570(%2$s)\uff1a", (String)"PdsExpertSelectHelper_3", (String)"scm-pds-common", (Object[])new Object[0]), this.getTurns(), this.getNumber()));
        if (this.isAdd() && PdsCommonUtils.object2String(this.getModel().getValue("condition"), "").length() > 0) {
            qfilterSb.append(this.getModel().getValue("condition")).append("\n");
            descriptionSb.append(this.getModel().getValue("description")).append("\n");
        }
        qfilterSb.append((CharSequence)prefixSb).append((CharSequence)context.getAllQFilter());
        descriptionSb.append((CharSequence)prefixSb).append((CharSequence)context.getAllDescription());
        this.getModel().setValue("qfilter", (Object)context.getUltimateQFilter());
        this.getModel().setValue("condition", (Object)qfilterSb);
        this.getModel().setValue("description", (Object)descriptionSb);
    }

    public void exit() {
        if (this.getModel().getDataEntity().getInt("turns") == 0) {
            this.getView().invokeOperation("close");
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u62bd\u53d6\u4e86\u4e00\u4e9b\u4e13\u5bb6\uff0c\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u53d6\u6d88\u8fd9\u4e9b\u62bd\u53d6\u7684\u6570\u636e\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f", (String)"PdsExpertSelectHelper_2", (String)"scm-pds-common", (Object[])new Object[0]), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("exit"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (StringUtils.equals((CharSequence)"exit", (CharSequence)evt.getCallBackId()) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("close");
        }
    }
}

