/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertfilter.selecttool;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.expertfilter.selecttool.ExpertContext;
import kd.scm.pds.common.expertfilter.selecttool.IPdsExpertInitContext;
import kd.scm.pds.common.expertfilter.selecttool.IPdsExpertInitModel;
import kd.scm.pds.common.expertfilter.selecttool.IPdsExpertReturnData;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsExpertSelectUtils {
    public static ExpertContext getContextInstance() {
        return (ExpertContext)ExtPluginFactory.getInstance().getExtPluginInstance(ExpertContext.class.getSimpleName(), ExpertContext.class.getName());
    }

    public static void initModel(ExpertContext context) {
        IPdsExpertInitModel initModel = (IPdsExpertInitModel)ExtPluginFactory.getInstance().getExtPluginInstance(IPdsExpertInitModel.class.getSimpleName());
        if (initModel == null) {
            context.setSucced(false);
            return;
        }
        initModel.initModel(context);
        if (context.getProjectObj() == null) {
            context.setSucced(false);
        }
    }

    public static void initContext(ExpertContext context) {
        IPdsExpertInitContext initContext = (IPdsExpertInitContext)ExtPluginFactory.getInstance().getExtPluginInstance(IPdsExpertInitContext.class.getSimpleName());
        if (initContext == null) {
            context.setSucced(false);
            return;
        }
        initContext.initContext(context);
    }

    public static void returnData(ExpertContext context) {
        IPdsExpertReturnData returnData = (IPdsExpertReturnData)ExtPluginFactory.getInstance().getExtPluginInstance(IPdsExpertReturnData.class.getSimpleName());
        if (returnData == null) {
            context.setSucced(false);
            return;
        }
        returnData.returnData(context);
    }

    public static void setQueryConditionVisible(IFormView view, Boolean isVisible) {
        PdsExpertSelectUtils.setQueryConditionVisible(view, "src_expert", isVisible);
        PdsExpertSelectUtils.setQueryConditionPropertiesVisible(view, "condition_src_expert", isVisible);
    }

    public static void setQueryConditionVisible(IFormView view, String baseDataType, Boolean isVisible) {
        view.setVisible(isVisible, new String[]{baseDataType});
        view.setVisible(isVisible, new String[]{"condition_" + baseDataType});
    }

    public static void setQueryConditionPropertiesVisible(IFormView view, String containerName, Boolean isVisible) {
        List<String> properties = PdsMetadataUtil.getContainerProperties("pds_selectexpert", containerName);
        for (String property : properties) {
            view.setVisible(isVisible, new String[]{property});
        }
    }

    public static Set<Long> getExcludedExpertIds(ExpertContext context) {
        DynamicObjectCollection rows = PdsExpertSelectUtils.getExcludedExpertRows(context);
        if (null == rows || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getExcludedUserIds(ExpertContext context) {
        DynamicObjectCollection rows = PdsExpertSelectUtils.getExcludedExpertRows(context);
        if (null == rows || rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("user.id")).collect(Collectors.toSet());
    }

    private static DynamicObjectCollection getExcludedExpertRows(ExpertContext context) {
        QFilter supplierFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        DynamicObject[] supplierRows = BusinessDataServiceHelper.load((String)"src_supplierinvite", (String)"suppliertype,supplier", (QFilter[])supplierFilter.toArray());
        if (supplierRows.length == 0) {
            return null;
        }
        Set supplierIds = Arrays.asList(supplierRows).stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        Set supplierNames = Arrays.asList(supplierRows).stream().map(e -> e.getString("supplier.name")).collect(Collectors.toSet());
        QFilter expertFilter = new QFilter("entrysupplier.supplier", "in", supplierIds);
        expertFilter.or("office", "in", supplierNames);
        return QueryServiceHelper.query((String)"src_expert", (String)"id,user.id", (QFilter[])expertFilter.toArray());
    }
}

