/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.expertitem.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsExpertUpdateLog
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(ExtPluginContext context) {
        if (context.getOperationKey().equals("audit")) {
            this.recordLog(context);
        } else {
            this.recoveryLog(context);
        }
    }

    public void recordLog(ExtPluginContext context) {
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(context.getRows().length);
        List properties = null;
        HashSet<String> excludedFields = new HashSet<String>();
        excludedFields.add("expert");
        for (DynamicObject expertObj : context.getRows()) {
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"src_expertupdatelog");
            if (null == properties) {
                properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)logObj);
            }
            logObj.set("expert", expertObj.getPkValue());
            PdsCommonUtils.copyDynamicObjectValue(expertObj, logObj, properties, excludedFields, -1);
            logObjs.add(logObj);
        }
        PdsCommonUtils.saveDynamicObjects(logObjs);
    }

    public void recoveryLog(ExtPluginContext context) {
        Set expertIds = Arrays.asList(context.getRows()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("expert", "in", expertIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_expertupdatelog", (boolean)false);
        DynamicObject[] logRows = BusinessDataServiceHelper.load((String)"src_expertupdatelog", (String)selectFields, (QFilter[])qfilters.toArray(), (String)"expert,evaluatedate desc");
        if (null == logRows || logRows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> logMap = Arrays.asList(logRows).stream().collect(Collectors.groupingBy(e -> e.getLong("expert.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)logRows[0]);
        HashSet<String> excludedFields = new HashSet<String>();
        excludedFields.add("expert");
        for (DynamicObject expertObj : context.getRows()) {
            DynamicObject logObj = logMap.get(expertObj.getLong("id"));
            if (null == logObj) continue;
            PdsCommonUtils.copyDynamicObjectValue(logObj, expertObj, properties, excludedFields, -1);
        }
    }
}

