/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.entity.PdsObjectPools;

public class ExtFilterFactory {
    public <E> List<E> getExtFilterInstance(String entityName, long schemeId) {
        List<String> extFilterNames = this.getFilterName(entityName, schemeId);
        return this.getExtFilterInstance(extFilterNames);
    }

    public <E> List<E> getExtFilterInstance(String entityName, String schemeNumber) {
        List<String> extFilterNames = this.getFilterName(entityName, schemeNumber);
        return this.getExtFilterInstance(extFilterNames);
    }

    private <E> List<E> getExtFilterInstance(List<String> extFilterNames) {
        if (extFilterNames == null || extFilterNames.size() == 0) {
            return null;
        }
        ArrayList extFilters = new ArrayList(8);
        for (String extFilterName : extFilterNames) {
            try {
                Object instance = PdsObjectPools.getInstance(extFilterName);
                if (null != instance) {
                    extFilters.add(instance);
                    continue;
                }
                instance = Class.forName(extFilterName).newInstance();
                if (null == instance) continue;
                PdsObjectPools.putInstance(extFilterName, instance);
                extFilters.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ext) {
                throw new KDBizException(extFilterName + "###instance classException:" + ext.getMessage());
            }
        }
        return extFilters;
    }

    private List<String> getFilterName(String entityName, long schemeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1").and("entryentity.entryenable", "=", (Object)"1");
        return this.getFilterName(entityName, qFilter);
    }

    private List<String> getFilterName(String entityName, String schemeNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)schemeNumber).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1").and("entryentity.entryenable", "=", (Object)"1");
        return this.getFilterName(entityName, qFilter);
    }

    private List<String> getFilterName(String entityName, QFilter qFilter) {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"entryentity.pluginname", (QFilter[])qFilter.toArray(), (String)"entryentity.seq");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(row -> row.getString("entryentity.pluginname")).collect(Collectors.toList());
    }

    private ExtFilterFactory() {
    }

    public static ExtFilterFactory getInstance() {
        return SingletonHolder.SINSTANCE;
    }

    private static final class SingletonHolder {
        private static final ExtFilterFactory SINSTANCE = new ExtFilterFactory();

        private SingletonHolder() {
        }
    }
}

