/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extfilter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.constant.FieldTypeConstant;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.ExtFilterFactory;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.extfilter.IExtFilterPlugin;
import kd.scm.pds.common.extfilter.PdsQFilterHelper;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import org.apache.commons.lang3.StringUtils;

public class ExtFilterUtils {
    private static Log log = LogFactory.getLog(ExtFilterUtils.class);

    public static Set<String> getFilterFields(String filterNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)filterNumber).or("basedata.number", "=", (Object)filterNumber);
        qFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_extfilter", (String)"entryselect.fieldid", (QFilter[])qFilter.toArray());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(row -> row.getString("entryselect.fieldid")).collect(Collectors.toSet());
    }

    public static int getMatchFields(IFormView view, String filterNumber) {
        int count = 0;
        Set<String> fieldSet = ExtFilterUtils.getFilterFields(filterNumber);
        if (fieldSet == null || fieldSet.size() == 0) {
            return count;
        }
        for (String field : fieldSet) {
            Object obj = view.getModel().getValue(field);
            if (Objects.isNull(obj) || String.valueOf(obj).equals("") || String.valueOf(obj).equals("0") || (obj instanceof BigDecimal ? ((BigDecimal)obj).compareTo(BigDecimal.ZERO) == 0 : obj instanceof DynamicObjectCollection && ((DynamicObjectCollection)obj).size() == 0)) continue;
            ++count;
        }
        return count;
    }

    public static QFilter getExtFilterByPlugin(String entityName, String number, IFormView view, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        if (null == paramMap) {
            paramMap = new HashMap<String, Object>(4);
        }
        paramMap.put("entityname", entityName);
        paramMap.put("number", number);
        context.setParamMap(paramMap);
        context.setView(view);
        List extFilters = ExtFilterFactory.getInstance().getExtFilterInstance(entityName, number);
        if (null != extFilters && extFilters.size() > 0) {
            for (IExtFilterPlugin extFilter : extFilters) {
                extFilter.buildQFilter(context);
            }
        }
        return context.getQfilter();
    }

    public static QFilter getExtQFilters(String entityName, String number, IFormView view, Map<String, Object> paramMap) {
        QFilter plugQFilter;
        QFilter qFilter = null;
        Map<String, Object> qFilterMap = FilterGridUtils.getQFilter(entityName, number);
        if (!Objects.isNull(qFilterMap.get("qfilter"))) {
            qFilter = (QFilter)qFilterMap.get("qfilter");
        }
        if ((plugQFilter = ExtFilterUtils.getExtFilterByPlugin(entityName, number, view, paramMap)) != null) {
            if (qFilter == null) {
                qFilter = plugQFilter;
            } else {
                qFilter.and(plugQFilter);
            }
        }
        return qFilter;
    }

    private static Map<String, Object> getFieldMatchQFilter(DynamicObject schemeObj, DynamicObject valueObj) {
        if (null == schemeObj || null == valueObj) {
            return null;
        }
        DynamicObjectCollection rows = schemeObj.getDynamicObjectCollection("entryentity_field");
        if (rows.size() == 0) {
            return null;
        }
        HashMap<String, Object> qfilterMap = new HashMap<String, Object>(2);
        qfilterMap.put("qfilter", null);
        qfilterMap.put("description", null);
        for (DynamicObject row : rows) {
            if (!row.getBoolean("fieldenable")) continue;
            ExtFilterUtils.buildQFilter(schemeObj, valueObj, row, qfilterMap);
        }
        return qfilterMap;
    }

    private static void buildQFilter(DynamicObject schemeObj, DynamicObject valueObj, DynamicObject row, Map<String, Object> qfilterMap) {
        Map<String, Object> valueMap;
        String queryField = row.getString("queryfield");
        String queryFieldType = row.getString("queryfieldtype");
        String queryFieldName = row.getString("queryfieldname");
        String valueField = row.getString("valuefield");
        String valueFieldType = row.getString("valuefieldtype");
        String matchType = row.getString("matchtype");
        if (StringUtils.isBlank((CharSequence)queryField) || StringUtils.isBlank((CharSequence)valueField) || StringUtils.isBlank((CharSequence)matchType)) {
            return;
        }
        if (FieldTypeConstant.getMulBasedataType().contains(queryFieldType)) {
            queryField = queryField + '.' + "fbasedataid";
        }
        if (FieldTypeConstant.getBasedataType().contains(valueFieldType) || valueObj.get(valueField) instanceof DynamicObject) {
            matchType = "=";
        }
        if ((FieldTypeConstant.getMulBasedataType().contains(valueFieldType) || valueObj.get(valueField) instanceof DynamicObjectCollection) && !matchType.equals("in") && !matchType.equals("not in")) {
            matchType = matchType.equals("=") || matchType.equals("match") || matchType.equals("exists") ? "in" : "not in";
        }
        if (null == (valueMap = ExtFilterUtils.getConditionValue(valueObj, valueField, valueFieldType)) || null == valueMap.get("value")) {
            return;
        }
        QFilter qfilters = qfilterMap.get("qfilter") == null ? null : (QFilter)qfilterMap.get("qfilter");
        Object value = valueMap.get("value");
        if (matchType.equals("like")) {
            value = "%" + value + "%";
        }
        QFilter qfilter = new QFilter(queryField, matchType, value);
        if (row.getBoolean("fieldenable")) {
            if (FieldTypeConstant.getMulBasedataType().contains(queryFieldType)) {
                qfilter.or(queryField, "is null", (Object)0L);
            } else if (FieldTypeConstant.getBasedataType().contains(queryFieldType)) {
                qfilter.or(queryField, "=", (Object)0L);
            } else if (FieldTypeConstant.getNumberType().contains(queryFieldType)) {
                qfilter.or(queryField, "=", (Object)0L);
            } else if (FieldTypeConstant.getDateType().contains(queryFieldType)) {
                qfilter.or(queryField, "=", null);
            } else if (FieldTypeConstant.getTextType().contains(queryFieldType)) {
                ExtFilterUtils.addStringNullFilter(queryField, qfilter);
            }
        }
        if (null != qfilters) {
            qfilters.and(qfilter);
        } else {
            qfilters = qfilter;
        }
        if (null != qfilters) {
            qfilterMap.put("qfilter", qfilters);
        }
        StringBuilder descriptions = qfilterMap.get("description") == null ? null : (StringBuilder)qfilterMap.get("description");
        String matchTypeName = ExtFilterUtils.getMatchTypeName(matchType);
        Object descriptionValue = valueMap.get("description");
        StringBuilder description = new StringBuilder().append(ResManager.loadKDString((String)" \u5e76\u4e14 ", (String)"ExtFilterUtils_0", (String)"scm-pds-common", (Object[])new Object[0])).append(queryFieldName).append(' ').append(matchTypeName).append(' ').append(descriptionValue);
        if (null != descriptions) {
            descriptions.append((CharSequence)description);
        } else {
            descriptions = description;
        }
        if (null != descriptions) {
            qfilterMap.put("description", descriptions);
        }
    }

    private static String getMatchTypeName(String matchType) {
        String matchTypeName = matchType;
        switch (matchType) {
            case "=": {
                matchTypeName = ResManager.loadKDString((String)" \u7b49\u4e8e ", (String)"ExtFilterUtils_1", (String)"scm-pds-common", (Object[])new Object[0]);
                break;
            }
            case "in": {
                matchTypeName = ResManager.loadKDString((String)" \u5305\u62ec ", (String)"ExtFilterUtils_2", (String)"scm-pds-common", (Object[])new Object[0]);
                break;
            }
            case "match": {
                matchTypeName = ResManager.loadKDString((String)" \u5339\u914d ", (String)"ExtFilterUtils_3", (String)"scm-pds-common", (Object[])new Object[0]);
                break;
            }
            case "ftlike": 
            case "like": {
                matchTypeName = ResManager.loadKDString((String)" \u76f8\u4f3c ", (String)"ExtFilterUtils_4", (String)"scm-pds-common", (Object[])new Object[0]);
                break;
            }
        }
        return matchTypeName;
    }

    private static Map<String, Object> getConditionValue(DynamicObject valueObj, String valueField, String valueFieldType) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
        Object value = null;
        try {
            value = valueObj.get(valueField);
        }
        catch (Exception e) {
            return valueMap;
        }
        if (null == value || value.toString().length() == 0) {
            return valueMap;
        }
        if (valueFieldType.equals("BasedataEdit") || value instanceof DynamicObject) {
            DynamicObject valObj = (DynamicObject)value;
            valueMap.put("value", SrmCommonUtil.getPkValue((DynamicObject)valObj));
            DynamicProperty property = valObj.getDynamicObjectType().getProperty("name");
            if (null != property) {
                valueMap.put("description", valObj.getString("name"));
            }
            return valueMap;
        }
        if (valueFieldType.equals("MulBasedataEdit") || valueObj.get(valueField) instanceof DynamicObjectCollection) {
            Set<Long> valueSet = MultiBasedataUtils.getBasedataIdSet(valueObj, valueField);
            if (valueSet.size() > 0) {
                valueMap.put("value", valueSet);
                List<String> selectNames = ((DynamicObjectCollection)valueObj.get(valueField)).stream().map(row -> row.getString("fbasedataid.name")).collect(Collectors.toList());
                String description = PdsQFilterHelper.buildNames(selectNames);
                valueMap.put("description", description);
                return valueMap;
            }
            return valueMap;
        }
        valueMap.put("value", value);
        valueMap.put("description", value);
        return valueMap;
    }

    public static void getFieldMatchQFilter(ExtFilterContext context, DynamicObject schemeObj, DynamicObject valueObj) {
        Map<String, Object> fieldQFilterMap = ExtFilterUtils.getFieldMatchQFilter(schemeObj, valueObj);
        if (null != fieldQFilterMap && null != fieldQFilterMap.get("qfilter")) {
            QFilter qfilter = context.getQfilter();
            if (null == qfilter) {
                context.setQfilter((QFilter)fieldQFilterMap.get("qfilter"));
            } else {
                context.setQfilter(qfilter.and((QFilter)fieldQFilterMap.get("qfilter")));
            }
            StringBuilder sb = context.getDescription();
            if (null == sb || sb.length() == 0) {
                context.setDescription(new StringBuilder(fieldQFilterMap.get("description").toString()));
            } else {
                Object description = fieldQFilterMap.get("description");
                if (null != description) {
                    context.setDescription(sb.append((CharSequence)new StringBuilder(description.toString())));
                }
            }
        }
    }

    public static void setProperiesVisibleByScheme(long schemdId, String entityName, IFormView view, Boolean isVisible) {
        List List2;
        if (!QueryServiceHelper.exists((String)entityName, (Object)schemdId)) {
            return;
        }
        HashSet<String> fields = new HashSet<String>(16);
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemdId, (String)entityName);
        DynamicObjectCollection rows = schemeObj.getDynamicObjectCollection("entryentity");
        if (rows.size() > 0) {
            List2 = rows.stream().filter(e -> e.getBoolean("entryenable") && !StringUtils.isEmpty((CharSequence)e.getString("displayfields"))).collect(Collectors.toList());
            for (DynamicObject row : List2) {
                fields.addAll(PdsCommonUtils.getMulComboFieldValue(row, "displayfields"));
            }
        }
        if ((rows = schemeObj.getDynamicObjectCollection("entryentity_field")).size() > 0) {
            List2 = rows.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e.getString("valuefield"))).collect(Collectors.toList());
            for (DynamicObject row : List2) {
                String field = row.getString("valuefield");
                if (null == field || field.length() <= 0) continue;
                fields.add(field);
            }
        }
        for (String field : fields) {
            view.setVisible(isVisible, new String[]{field});
        }
    }

    public static void setPropertyType(IFormView view, String entityName, Object newValue, String fieldName, int index) {
        if (null == newValue || newValue.toString().length() == 0) {
            view.getModel().setValue(fieldName, null, index);
            if (fieldName.equals("queryfieldtype")) {
                view.getModel().setValue("queryfieldname", null, index);
            }
        } else {
            Map<String, String> proTypeMap = ExtFilterUtils.getProMapFromPageCache(view, entityName, "protype");
            view.getModel().setValue(fieldName, (Object)proTypeMap.get(newValue.toString()), index);
            if (fieldName.equals("queryfieldtype")) {
                Map<String, String> proMap = ExtFilterUtils.getProMapFromPageCache(view, entityName, "pro");
                view.getModel().setValue("queryfieldname", (Object)proMap.get(newValue.toString()), index);
            }
        }
    }

    private static Map<String, String> getProMapFromPageCache(IFormView view, String entityName, String type) {
        Map<Object, Object> proMap = new HashMap();
        String key = entityName + '_' + type;
        String proMapString = view.getPageCache().get(key);
        if (null != proMapString) {
            proMap = (Map)SerializationUtils.fromJsonString((String)proMapString, proMap.getClass());
        } else {
            proMap = type.equals("pro") ? PdsMetadataUtil.getProMap(entityName, true) : PdsMetadataUtil.getProTypeMap(entityName, true);
            view.getPageCache().put(key, SerializationUtils.toJsonString(proMap));
        }
        return proMap;
    }

    public static <T> T getParamValueFromContext(ExtFilterContext context, String key) {
        Map<String, Object> paramMap = context.getParamMap();
        if (null == paramMap) {
            return null;
        }
        Object obj = paramMap.get(key);
        if (null == obj) {
            return null;
        }
        return (T)obj;
    }

    public static DynamicObject getProjectObjFromContext(ExtFilterContext context) {
        DynamicObject projectObj = context.getProjectObj();
        if (null == projectObj) {
            projectObj = (DynamicObject)ExtFilterUtils.getParamValueFromContext(context, "project");
        }
        return projectObj;
    }

    public static long getSourceTypeIdFromContext(ExtFilterContext context) {
        long sourceTypeId = PdsCommonUtils.object2Long(ExtFilterUtils.getParamValueFromContext(context, "sourcetype"));
        if (sourceTypeId > 0L) {
            return sourceTypeId;
        }
        DynamicObject projectObj = ExtFilterUtils.getProjectObjFromContext(context);
        if (null == projectObj) {
            return 0L;
        }
        try {
            sourceTypeId = PdsCommonUtils.isNotProjectBill(projectObj.getDataEntityType().getName()) ? SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("project.sourcetype")) : SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("sourcetype"));
        }
        catch (Exception e) {
            log.error("###getSourceTypeIdFromContext:" + e.getMessage());
        }
        return sourceTypeId;
    }

    public static long getSourceFlowIdFromContext(ExtFilterContext context) {
        long sourceFlowId = PdsCommonUtils.object2Long(ExtFilterUtils.getParamValueFromContext(context, "srctype"));
        if (sourceFlowId > 0L) {
            return sourceFlowId;
        }
        DynamicObject projectObj = ExtFilterUtils.getProjectObjFromContext(context);
        if (null == projectObj) {
            return 0L;
        }
        if (PdsCommonUtils.isNotProjectBill(projectObj.getDataEntityType().getName())) {
            DynamicProperty property = projectObj.getDynamicObjectType().getProperty("project");
            if (null != property) {
                sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("project.srctype"));
            }
        } else {
            DynamicProperty property = projectObj.getDynamicObjectType().getProperty("srctype");
            if (null != property) {
                sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("srctype"));
            }
        }
        return sourceFlowId;
    }

    public static long getReqTypeIdFromContext(ExtFilterContext context) {
        long reqTypeId = PdsCommonUtils.object2Long(ExtFilterUtils.getParamValueFromContext(context, "reqtype"));
        if (reqTypeId > 0L) {
            return reqTypeId;
        }
        DynamicObject billObj = ExtFilterUtils.getReqObjFromContext(context);
        if (null == billObj) {
            return 0L;
        }
        try {
            reqTypeId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("reqtype"));
        }
        catch (Exception e) {
            log.error("###getPro exception:" + e.getMessage());
        }
        return reqTypeId;
    }

    public static long getPlanTypeIdFromContext(ExtFilterContext context) {
        long planTypeId = PdsCommonUtils.object2Long(ExtFilterUtils.getParamValueFromContext(context, "plantype"));
        if (planTypeId > 0L) {
            return planTypeId;
        }
        DynamicObject reqObj = ExtFilterUtils.getReqObjFromContext(context);
        if (null == reqObj) {
            return 0L;
        }
        try {
            planTypeId = SrmCommonUtil.getPkValue((DynamicObject)reqObj.getDynamicObject("plantype"));
        }
        catch (Exception e) {
            log.error("###getPro exception:" + e.getMessage());
        }
        return planTypeId;
    }

    public static long getReqOrgIdFromContext(ExtFilterContext context) {
        long reqOrgId = PdsCommonUtils.object2Long(ExtFilterUtils.getParamValueFromContext(context, "org"));
        if (reqOrgId > 0L) {
            return reqOrgId;
        }
        DynamicObject reqObj = ExtFilterUtils.getReqObjFromContext(context);
        if (null == reqObj) {
            return 0L;
        }
        try {
            reqOrgId = SrmCommonUtil.getPkValue((DynamicObject)reqObj.getDynamicObject("org"));
        }
        catch (Exception e) {
            log.error("###getPro exception:" + e.getMessage());
        }
        return reqOrgId;
    }

    public static DynamicObject getReqObjFromContext(ExtFilterContext context) {
        DynamicObject reqObj = context.getBillObj();
        if (null == reqObj) {
            reqObj = (DynamicObject)ExtFilterUtils.getParamValueFromContext(context, "reqobj");
        }
        return reqObj;
    }

    public static String getAppId(ExtFilterContext context) {
        if (null == context.getBillObj()) {
            return "";
        }
        return context.getBillObj().getDataEntityType().getName().substring(0, 3);
    }

    public static long getChangeTypeId(DynamicObject billObj) {
        if (billObj == null) {
            return 0L;
        }
        if (!billObj.getDataEntityType().getName().equals("src_bidchange") && !billObj.getDataEntityType().getName().equals("tnd_bidchange")) {
            return 0L;
        }
        DynamicObject obj = null;
        try {
            obj = billObj.getDynamicObject("template");
        }
        catch (Exception e) {
            log.error("###getPro exception:" + e.getMessage());
        }
        if (null == obj) {
            return 0L;
        }
        return SrmCommonUtil.getPkValue((DynamicObject)obj);
    }

    public static long getSourceFlowOrSourceTypeId(DynamicObject billObj, String fieldName) {
        if (billObj == null) {
            return 0L;
        }
        DynamicObject projectObj = billObj;
        if (PdsCommonUtils.isNotProjectBill(billObj.getDataEntityType().getName())) {
            projectObj = billObj.getDynamicObject("project");
        }
        DynamicObject obj = null;
        try {
            obj = projectObj.getDynamicObject(fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == obj) {
            try {
                projectObj = billObj.getDynamicObject("projectf7");
                if (null != projectObj) {
                    obj = projectObj.getDynamicObject(fieldName);
                }
            }
            catch (Exception e) {
                log.error("###getPro exception:" + e.getMessage());
            }
        }
        return SrmCommonUtil.getPkValue((DynamicObject)obj);
    }

    public static QFilter getStringFilter(String keyFeld, String value) {
        QFilter qfilter = new QFilter(keyFeld, "=", (Object)value);
        ExtFilterUtils.addStringNullFilter(keyFeld, qfilter);
        return qfilter;
    }

    public static QFilter getStringFilter(String keyFeld, Set<String> valueSet) {
        QFilter qfilter = new QFilter(keyFeld, "in", valueSet);
        ExtFilterUtils.addStringNullFilter(keyFeld, qfilter);
        return qfilter;
    }

    public static void addStringNullFilter(String keyFeld, QFilter qfilter) {
        qfilter.or(keyFeld, "=", (Object)"");
        qfilter.or(keyFeld, "=", (Object)" ");
        qfilter.or(keyFeld, "is null", (Object)"");
        qfilter.or(keyFeld, "=", (Object)",,");
    }

    public static QFilter getBaseDataFilter(String keyFeld, long value) {
        QFilter qfilter = new QFilter(keyFeld, "=", (Object)value);
        qfilter.or(keyFeld, "=", (Object)0);
        return qfilter;
    }

    public static QFilter getBaseDataFilter(String keyFeld, Set<Long> valueSet) {
        QFilter qfilter = new QFilter(keyFeld, "in", valueSet);
        qfilter.or(keyFeld, "=", (Object)0);
        return qfilter;
    }

    public static QFilter getMultiBaseDataFilter(String keyFeld, long value) {
        QFilter qfilter = new QFilter(keyFeld + '.' + "fbasedataid", "=", (Object)value);
        QFilter qfilter2 = new QFilter(keyFeld + '.' + "fbasedataid", "is not null", (Object)0L);
        QFilter qfilter3 = new QFilter(keyFeld + '.' + "fbasedataid", "is null", (Object)0L);
        return qfilter.and(qfilter2).or(qfilter3);
    }

    public static QFilter getMultiBaseDataFilter(String keyFeld, Set<Long> valueSet) {
        QFilter qfilter = new QFilter(keyFeld + '.' + "fbasedataid", "in", valueSet);
        QFilter qfilter2 = new QFilter(keyFeld + '.' + "fbasedataid", "is not null", (Object)0L);
        QFilter qfilter3 = new QFilter(keyFeld + '.' + "fbasedataid", "is null", (Object)0L);
        return qfilter.and(qfilter2).or(qfilter3);
    }

    public static QFilter getMultiBaseDataFilterAllMatch(String keyFeld, long value) {
        QFilter qfilter = new QFilter(keyFeld + '.' + "fbasedataid", "=", (Object)value);
        QFilter qfilter2 = new QFilter(keyFeld + '.' + "fbasedataid", "is not null", (Object)0L);
        return qfilter.and(qfilter2);
    }

    public static QFilter getMultiBaseDataFilterAllMatch(String keyFeld, Set<Long> valueSet) {
        QFilter qfilter = new QFilter(keyFeld + '.' + "fbasedataid", "in", valueSet);
        QFilter qfilter2 = new QFilter(keyFeld + '.' + "fbasedataid", "is not null", (Object)0L);
        return qfilter.and(qfilter2);
    }

    public static long getBizNodeId(String entityKey) {
        if (null == entityKey) {
            return 0L;
        }
        QFilter nodeFilter = new QFilter("bizobject.number", "=", (Object)entityKey);
        DynamicObject nodeObj = QueryServiceHelper.queryOne((String)"pds_biznode", (String)"id", (QFilter[])nodeFilter.toArray());
        if (null == nodeObj) {
            return 0L;
        }
        return nodeObj.getLong("id");
    }

    public static QFilter getDateScopeFilter(DynamicObject billObj, String dateFromField, String dateToField, String filterField) {
        Date dateTo;
        Date dateFrom = billObj.getDate(dateFromField);
        if (null != dateFrom) {
            dateFrom = DateUtil.formatStartDate((Date)dateFrom);
        }
        if (null != (dateTo = billObj.getDate(dateToField))) {
            dateTo = DateUtil.formatEndDate((Date)dateTo);
        }
        if (null != dateFrom && null != dateTo) {
            return new QFilter(filterField, ">=", (Object)dateFrom).and(filterField, "<=", (Object)dateTo);
        }
        if (null != dateFrom) {
            return new QFilter(filterField, ">=", (Object)dateFrom);
        }
        if (null != dateTo) {
            return new QFilter(filterField, "<=", (Object)dateTo);
        }
        return null;
    }

    public static boolean isMatchSourceTypeAndSourceFlow(Object contextObj, String pluginName, String pluginNumber) {
        ExtFilterContext context = PdsCommonUtils.convertExtFilterContext(contextObj);
        long sourceTypeId = ExtFilterUtils.getSourceTypeIdFromContext(context);
        long sourceFlowId = ExtFilterUtils.getSourceFlowIdFromContext(context);
        if (sourceTypeId == 0L || sourceFlowId == 0L) {
            return true;
        }
        QFilter pluginFilter = ExtFilterUtils.getPluginFilter(pluginName, pluginNumber);
        QFilter sourceTypeFilter = ExtFilterUtils.getMultiBaseDataFilter("sourcetype", sourceTypeId);
        pluginFilter.and(sourceTypeFilter);
        QFilter sourceFolwFilter = ExtFilterUtils.getMultiBaseDataFilter("srctype", sourceFlowId);
        pluginFilter.and(sourceFolwFilter);
        if (!QueryServiceHelper.exists((String)"pds_extplugin", (QFilter[])pluginFilter.toArray())) {
            return false;
        }
        QFilter pluginFilter2 = ExtFilterUtils.getPluginFilter(pluginName, pluginNumber);
        QFilter sourceTypeFilter2 = ExtFilterUtils.getMultiBaseDataFilterAllMatch("sourcetype2", sourceTypeId);
        QFilter sourceFolwFilter2 = ExtFilterUtils.getMultiBaseDataFilterAllMatch("srctype2", sourceFlowId);
        pluginFilter2.and(sourceTypeFilter2.or(sourceFolwFilter2));
        return !QueryServiceHelper.exists((String)"pds_extplugin", (QFilter[])pluginFilter2.toArray());
    }

    public static QFilter getPluginFilter(String pluginName, String pluginNumber) {
        QFilter pluginFilter = new QFilter("enable", "=", (Object)"1");
        if (null != pluginNumber) {
            pluginFilter.and("number", "=", (Object)pluginNumber);
        }
        if (null != pluginName) {
            pluginFilter.and("pluginname", "=", (Object)pluginName);
        }
        return pluginFilter;
    }

    public static DynamicObject getBaseObjFromBillObj(DynamicObject billObj, String fieldName) {
        if (billObj == null) {
            return null;
        }
        DynamicObject projectObj = billObj;
        if (PdsCommonUtils.isNotProjectBill(billObj.getDataEntityType().getName())) {
            DynamicProperty property = billObj.getDynamicObjectType().getProperty("project");
            if (null == property) {
                return null;
            }
            projectObj = billObj.getDynamicObject("project");
            if (null == projectObj) {
                return null;
            }
        }
        DynamicObject baseObj = null;
        DynamicProperty property = projectObj.getDynamicObjectType().getProperty(fieldName);
        if (null != property && property instanceof BasedataProp) {
            baseObj = projectObj.getDynamicObject(fieldName);
        }
        if (null != baseObj) {
            return baseObj;
        }
        property = billObj.getDynamicObjectType().getProperty("projectf7");
        if (null == property) {
            return null;
        }
        DynamicObject projectF7Obj = billObj.getDynamicObject("projectf7");
        if (null == projectF7Obj) {
            return null;
        }
        property = projectF7Obj.getDynamicObjectType().getProperty(fieldName);
        if (null != property && property instanceof BasedataProp) {
            baseObj = projectF7Obj.getDynamicObject(fieldName);
        }
        return baseObj;
    }

    public static long getPurOrgIdFromContext(ExtFilterContext context) {
        long purOrgId = PdsCommonUtils.object2Long(ExtFilterUtils.getParamValueFromContext(context, "purorg"));
        if (purOrgId > 0L) {
            return purOrgId;
        }
        DynamicObject projectObj = ExtFilterUtils.getProjectObjFromContext(context);
        if (null == projectObj) {
            return 0L;
        }
        DynamicObject purOrgObj = ExtFilterUtils.getBaseObjFromBillObj(projectObj, "org");
        if (null == purOrgObj) {
            return 0L;
        }
        return SrmCommonUtil.getPkValue((DynamicObject)purOrgObj);
    }

    public static boolean isNeedExclude(long baseDataId, DynamicObject obj, String fieldName) {
        Set<Long> idSet;
        return baseDataId > 0L && null != (idSet = MultiBasedataUtils.getBasedataIdSet(obj, fieldName)) && idSet.size() > 0 && idSet.contains(baseDataId);
    }

    public static String getSourceTypeField(DynamicObject billObj) {
        String sourcetype = "sourcetype";
        if (null != billObj) {
            String entityName = billObj.getDataEntityType().getName();
            sourcetype = "src_apply".equals(entityName) || "src_demand".equals(entityName) ? "sourcetype2" : "sourcetype";
        }
        return sourcetype;
    }

    public static String getSourceFlowField(DynamicObject billObj) {
        String sourceflow = "srctype";
        if (null != billObj) {
            String entityName = billObj.getDataEntityType().getName();
            sourceflow = "src_apply".equals(entityName) || "src_demand".equals(entityName) ? "srctype2" : "srctype";
        }
        return sourceflow;
    }

    public static DynamicObject getProjectObjFromBillObj(DynamicObject billObj) {
        if (billObj == null) {
            return null;
        }
        if (null != billObj.getDynamicObjectType().getProperty("project")) {
            return billObj.getDynamicObject("project");
        }
        if (null != billObj.getDynamicObjectType().getProperty("projectf7")) {
            return billObj.getDynamicObject("projectf7");
        }
        return billObj;
    }
}

