/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extfilter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;

public class FilterGridUtils {
    public static void setEntityNumber(IFormView view) {
        FilterGrid filterGrid = (FilterGrid)view.getControl("filtergridap");
        Object obj = null;
        try {
            obj = view.getModel().getValue("basedata");
        }
        catch (Exception e) {
            obj = view.getModel().getValue("bizobject");
        }
        if (null == obj) {
            filterGrid.setEntityNumber(null);
        } else {
            DynamicObject basedataObj = (DynamicObject)obj;
            filterGrid.setEntityNumber(basedataObj.getString("number"));
        }
        filterGrid.bindData(null);
    }

    public static FilterCondition loadCondition(IFormView view) {
        Object content = view.getModel().getValue("condition_tag");
        if (StringUtils.isBlank((Object)content)) {
            content = view.getModel().getValue("condition");
        }
        if (StringUtils.isBlank((Object)content)) {
            return null;
        }
        String filter = String.valueOf(content);
        if (StringUtils.isBlank((CharSequence)filter) || filter.equals("") || filter.trim().length() <= 4) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        return filterCondition;
    }

    public static void setCondition(IFormView view) {
        FilterGrid filterGrid = (FilterGrid)view.getControl("filtergridap");
        FilterCondition filterCondition = FilterGridUtils.loadCondition(view);
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public static FilterCondition getCondition(IFormView view) {
        FilterGrid filterGrid = (FilterGrid)view.getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    public static void saveCondition(IFormView view) {
        String filter = "";
        FilterCondition filterCondition = FilterGridUtils.getCondition(view);
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        view.getModel().setValue("condition_tag", (Object)filter);
    }

    public static Map<String, Object> getQFilter(String entityName, String schemeNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)schemeNumber).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1");
        return FilterGridUtils.getQFilter(entityName, qFilter);
    }

    public static Map<String, Object> getQFilter(String entityName, long schemeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1");
        return FilterGridUtils.getQFilter(entityName, qFilter);
    }

    private static Map<String, Object> getQFilter(String entityName, QFilter qFilter) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("qfilter", null);
        resultMap.put("description", null);
        resultMap.put("name", null);
        resultMap.put("remark", null);
        resultMap.put("orderby", null);
        resultMap.put("billid", 0);
        resultMap.put("bizobject", null);
        resultMap.put("filterfield", null);
        String selectFields = "id,name,remark,basedata,bizobject,condition,condition_tag,orderby,bizobject,filterfield";
        DynamicObject extfilterObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectFields, (QFilter[])qFilter.toArray());
        if (Objects.isNull(extfilterObj)) {
            return resultMap;
        }
        try {
            resultMap.put("name", extfilterObj.getString("name"));
            resultMap.put("remark", extfilterObj.getString("remark"));
            resultMap.put("billid", extfilterObj.getPkValue());
            resultMap.put("bizobject", extfilterObj.get("bizobject.number"));
            resultMap.put("filterfield", extfilterObj.get("filterfield"));
            resultMap.put("orderby", extfilterObj.getString("orderby"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String entitykey = null;
        try {
            entitykey = extfilterObj.getString("basedata.number");
        }
        catch (Exception e) {
            entitykey = extfilterObj.getString("bizobject.number");
        }
        String filter = extfilterObj.getString("condition_tag");
        if (StringUtils.isBlank((CharSequence)filter)) {
            filter = extfilterObj.getString("condition");
        }
        if (StringUtils.isBlank((CharSequence)filter) || filter.equals("") || filter.trim().length() <= 4) {
            return resultMap;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entitykey);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        String[] scripts = filterBuilder.buildFilterScript();
        if (scripts.length > 1) {
            resultMap.put("description", scripts[1]);
        }
        resultMap.put("qfilter", filterBuilder.getQFilter());
        resultMap.put("qfilters", filterBuilder.getQFilters());
        resultMap.put("entitykey", entitykey);
        return resultMap;
    }
}

