/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extfilter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.ExtFilterFactory;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.extfilter.IExtFilterPlugin;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SchemeFilterUtils {
    public static long getFirstSchemeIdByBizObject(String entityName, DynamicObject projectObj, String schemeName, String number, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        SchemeFilterUtils.getSchemeQFilter(context);
        QFilter qfilter = context.getQfilter();
        if (null == qfilter) {
            return 0L;
        }
        if (null != entityName) {
            qfilter.and("bizobject.number", "=", (Object)entityName);
        }
        String orderBy = context.getOrderBy().length() > 0 ? context.getOrderBy() : "matchfield desc,number";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)schemeName, (String)(SchemeFilterUtils.getFilterField(context) + "," + "number" + "," + "matchfield"), (QFilter[])qfilter.toArray(), (String)orderBy);
        if (null == rows || rows.size() == 0) {
            return 0L;
        }
        return ((DynamicObject)rows.get(0)).getLong(SchemeFilterUtils.getFilterField(context));
    }

    public static DynamicObject getFirstSchemeByBizObject(String entityName, DynamicObject projectObj, String schemeName, String number, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        SchemeFilterUtils.getSchemeQFilter(context);
        QFilter qfilter = context.getQfilter();
        if (null == qfilter) {
            return null;
        }
        String orderBy = context.getOrderBy().length() > 0 ? context.getOrderBy() : "matchfield desc,number";
        String selectFields = DynamicObjectUtil.getSelectfields((String)schemeName, (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)schemeName, (String)selectFields, (QFilter[])qfilter.toArray(), (String)orderBy);
        if (null == rows || rows.length == 0) {
            return null;
        }
        return rows[0];
    }

    public static long getFirstSchemeId(DynamicObject projectObj, String number, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(projectObj);
        context.setBillObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        return SchemeFilterUtils.getFirstSchemeId(context);
    }

    public static long getFirstSchemeId(ExtFilterContext context) {
        SchemeFilterUtils.getSchemeQFilter(context);
        DynamicObjectCollection rows = SchemeFilterUtils.getAllSchemes(context);
        if (null == rows || rows.size() == 0) {
            return 0L;
        }
        return ((DynamicObject)rows.get(0)).getLong(SchemeFilterUtils.getFilterField(context));
    }

    public static List<Long> getAllSchemeIds(DynamicObject projectObj, String number, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        return SchemeFilterUtils.getAllSchemeIds(context);
    }

    public static List<Long> getAllSchemeIds(ExtFilterContext context) {
        SchemeFilterUtils.getSchemeQFilter(context);
        DynamicObjectCollection rows = SchemeFilterUtils.getAllSchemes(context);
        if (null == rows || rows.size() == 0) {
            return Collections.emptyList();
        }
        String filterField = SchemeFilterUtils.getFilterField(context);
        return rows.stream().map(e -> e.getLong(filterField)).collect(Collectors.toList());
    }

    public static void setSchemeDefaultValue(IFormView view, DynamicObject projectObj, String number, String schemeField, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        context.setView(view);
        context.setProjectObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        context.setSchemeField(schemeField);
        SchemeFilterUtils.setSchemeDefaultValue(context);
    }

    public static void setSchemeDefaultValue(ExtFilterContext context) {
        SchemeFilterUtils.getSchemeQFilter(context);
        DynamicObjectCollection rows = SchemeFilterUtils.getAllSchemes(context);
        if (null == rows || rows.size() == 0 || null == context.getView()) {
            if (null != context.getParamMap() && null != context.getParamMap().get("ismustinput") && ((Boolean)context.getParamMap().get("ismustinput")).booleanValue()) {
                context.getView().getModel().setValue(context.getSchemeField(), null);
            }
            return;
        }
        long firstSchemeId = ((DynamicObject)rows.get(0)).getLong(SchemeFilterUtils.getFilterField(context));
        long schemeId = SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity().getDynamicObject(context.getSchemeField()));
        if (schemeId == 0L) {
            context.getView().getModel().setValue(context.getSchemeField(), (Object)firstSchemeId);
            return;
        }
        if (rows.stream().noneMatch(row -> schemeId == row.getLong(SchemeFilterUtils.getFilterField(context)))) {
            context.getView().getModel().setValue(context.getSchemeField(), (Object)firstSchemeId);
        }
    }

    public static void setSchemeF7Filter(BeforeF7SelectEvent evt, DynamicObject projectObj, String number, Map<String, Object> paramMap) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(projectObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        List<Long> schemeIds = SchemeFilterUtils.getAllSchemeIds(context);
        if (schemeIds.size() == 0 && (null == paramMap || null == paramMap.get("ismustinput"))) {
            return;
        }
        QFilter qfilter = new QFilter("id", "in", schemeIds);
        showParameter.getListFilterParameter().setFilter(qfilter);
        if (null != paramMap) {
            showParameter.getCustomParams().put("schemetype", paramMap.get("schemetype"));
        }
        String orderBy = context.getOrderBy().length() > 0 ? context.getOrderBy() : "matchfield desc,number";
        showParameter.getListFilterParameter().setOrderBy(orderBy);
    }

    public static void getSchemeQFilter(ExtFilterContext context) {
        List extFilters;
        Map<String, Object> qfilterMap = FilterGridUtils.getQFilter("pds_extfilter", context.getNumber());
        context.setQfilter((QFilter)qfilterMap.get("qfilter"));
        if (!StringUtils.isBlank((Object)qfilterMap.get("description"))) {
            context.setDescription(new StringBuilder(qfilterMap.get("description").toString()));
        }
        context.setOrderBy(PdsCommonUtils.object2String(qfilterMap.get("orderby"), ""));
        if (null != qfilterMap.get("entitykey")) {
            context.setBaseDataType(qfilterMap.get("entitykey").toString());
        }
        if (!StringUtils.isBlank((Object)qfilterMap.get("filterfield"))) {
            context.getParamMap().put("filterfield", qfilterMap.get("filterfield"));
        }
        if (null != qfilterMap.get("bizobject") && null != context.getProjectObj()) {
            DynamicObject extFilterObj = BusinessDataServiceHelper.loadSingle((Object)PdsCommonUtils.object2Long(qfilterMap.get("billid")), (String)"pds_extfilter");
            ExtFilterUtils.getFieldMatchQFilter(context, extFilterObj, context.getProjectObj());
        }
        if (null != (extFilters = ExtFilterFactory.getInstance().getExtFilterInstance("pds_extfilter", context.getNumber())) && extFilters.size() > 0) {
            for (IExtFilterPlugin extFilter : extFilters) {
                extFilter.buildQFilter(context);
            }
        }
        if (!context.isSucced()) {
            context.setQfilter(null);
        }
    }

    public static DynamicObjectCollection getAllSchemes(ExtFilterContext context) {
        if (null == context.getQfilter() || null == context.getBaseDataType()) {
            return null;
        }
        String orderBy = context.getOrderBy().length() > 0 ? context.getOrderBy() : "matchfield desc";
        String selectFields = SchemeFilterUtils.getFilterField(context);
        if (!selectFields.contains("number") && orderBy.contains("number")) {
            selectFields = selectFields + "," + "number";
        }
        if (!selectFields.contains("matchfield") && orderBy.contains("matchfield")) {
            selectFields = selectFields + "," + "matchfield";
        }
        switch (context.getBaseDataType()) {
            case "src_projectf7": {
                selectFields = SchemeFilterUtils.getFilterField(context);
                break;
            }
        }
        selectFields = SchemeFilterUtils.appendOrderByFields(selectFields, orderBy);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)context.getBaseDataType(), (String)selectFields, (QFilter[])context.getQfilter().toArray(), (String)orderBy);
        if (null == rows || rows.size() == 0) {
            return null;
        }
        return rows;
    }

    private static String appendOrderByFields(String selectFields, String orderBy) {
        StringBuilder sb = new StringBuilder(selectFields);
        String[] orderBys = orderBy.split("\\,");
        List<String> fields = Arrays.asList(selectFields.split("\\,"));
        for (String field : orderBys) {
            if (fields.contains(field = field.replace(" desc", ""))) continue;
            sb.append(',').append(field);
        }
        return sb.toString();
    }

    private static String getFilterField(ExtFilterContext context) {
        String idField = "id";
        if (null == context || null == context.getParamMap()) {
            return idField;
        }
        Object filterField = context.getParamMap().get("filterfield");
        if (!StringUtils.isBlank((Object)filterField)) {
            return SchemeFilterUtils.getFilterField(context.getParamMap().get("filterfield"));
        }
        return idField;
    }

    private static String getFilterField(Object filterField) {
        StringBuilder sb = new StringBuilder().append(filterField);
        if (sb.toString().contains(".id")) {
            return sb.toString();
        }
        return sb.append(".id").toString();
    }

    public static void autoSetScheme(IFormView view, int index, Map<String, Object> paramMap, IDataModel model) {
        IFormView parentView = view.getParentView();
        if (!PdsCommonUtils.isValidBillType(parentView)) {
            return;
        }
        DynamicObject billObj = parentView.getModel().getDataEntity();
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
        String scoreType = view.getModel().getDataEntity().getString("scoretype");
        boolean isAutoSetScheme = false;
        isAutoSetScheme = scoreType.equals("1") ? ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isautosetscheme", false, SrmCommonUtil.getPkValue((DynamicObject)billObj))) : ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isautosetscheme2", true, SrmCommonUtil.getPkValue((DynamicObject)billObj)));
        if (!isAutoSetScheme) {
            model.setValue("scheme", null, index);
            return;
        }
        long schemeId = SchemeFilterUtils.getFirstSchemeId(billObj, view.getEntityId(), paramMap);
        if (schemeId == 0L) {
            model.setValue("scheme", null, index);
        } else {
            model.setValue("scheme", (Object)schemeId, index);
        }
    }

    public static void autoSetScheme(IFormView view, IDataModel model, int index) {
        IFormView parentView = view.getParentView();
        if (!PdsCommonUtils.isValidBillType(parentView)) {
            return;
        }
        DynamicObject billObj = parentView.getModel().getDataEntity();
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
        boolean isAutoSetScheme = view.getEntityId().equals("src_aptitudeconfig") ? ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isautosetscheme3", false, SrmCommonUtil.getPkValue((DynamicObject)billObj))) : ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isautosetscheme4", false, SrmCommonUtil.getPkValue((DynamicObject)billObj)));
        if (!isAutoSetScheme) {
            model.setValue("scheme", null, index);
            return;
        }
        long schemeId = SchemeFilterUtils.getFirstSchemeId(billObj, view.getEntityId(), null);
        if (schemeId == 0L) {
            model.setValue("scheme", null, index);
        } else {
            model.setValue("scheme", (Object)schemeId, index);
        }
    }

    public static QFilter getQFilterByExtFilterScheme(String entityName, String number, DynamicObject billObj, Map<String, Object> paramMap) {
        ExtFilterContext context = new ExtFilterContext();
        context.setProjectObj(billObj);
        if (null != paramMap) {
            context.setParamMap(paramMap);
        }
        context.setNumber(number);
        SchemeFilterUtils.getSchemeQFilter(context);
        return context.getQfilter();
    }
}

