/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extfilter.comfilter;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.archive.schemefilter.IFileSchemeFilter;
import kd.scm.pds.common.extfilter.ExtFilterContext;

public class ExtFilterByPurAmount
implements IFileSchemeFilter {
    private static final long serialVersionUID = 1L;

    @Override
    public Map<String, Object> getQFilter(ExtFilterContext context) {
        Map<String, BigDecimal> amountMap = this.getProjectAmount(context);
        if (null == amountMap) {
            return null;
        }
        QFilter amountFilter1 = new QFilter("amount", ">=", (Object)BigDecimal.ZERO).and("amount", "<=", (Object)amountMap.get("amount"));
        QFilter amountFilter2 = new QFilter("taxamount", ">=", (Object)BigDecimal.ZERO).and("taxamount", "<=", (Object)amountMap.get("taxamount"));
        return this.getQFilterMap(amountFilter1.or(amountFilter2), null);
    }

    public Map<String, BigDecimal> getProjectAmount(ExtFilterContext context) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        Object amountObj = context.getParamMap().get("amount");
        Object taxAmountObj = context.getParamMap().get("taxamount");
        if (null != amountObj && null != taxAmountObj) {
            amount = (BigDecimal)amountObj;
            taxAmount = (BigDecimal)taxAmountObj;
        } else {
            QFilter qfilter = new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
            DynamicObject baseInfoObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"sceneamount,scenetaxamount", (QFilter[])qfilter.toArray());
            if (null == baseInfoObj) {
                return null;
            }
            amount = baseInfoObj.getBigDecimal("sceneamount");
            taxAmount = baseInfoObj.getBigDecimal("scenetaxamount");
        }
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(2);
        amountMap.put("amount", amount);
        amountMap.put("taxamount", taxAmount);
        return amountMap;
    }
}

