/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extfilter.purlistend;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.archive.schemefilter.IFileSchemeFilter;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class ExtFilterByValidSupplierNum
implements IFileSchemeFilter {
    private static final long serialVersionUID = 1L;

    @Override
    public Map<String, Object> getQFilter(ExtFilterContext context) {
        long projectId = context.getProjectObj().getLong("id");
        String number = PdsCommonUtils.object2String(context.getParamMap().get("number"), "src_materialend_filter");
        int minNum = PdsCommonUtils.object2Integer(ExtParameterUtils.getExtParameterValueByNumber("pds_extfilter", number, "quoteSupplierNum", 0));
        if (minNum == 0) {
            return this.getQFilterMap(new QFilter("id", "in", new HashSet()), null);
        }
        Set<Long> purlistIds = PdsPurlistUtils.getInitPurilstIds(projectId);
        if (null == purlistIds || purlistIds.size() == 0) {
            return this.getQFilterMap(new QFilter("id", "in", new HashSet()), null);
        }
        Map<Long, Integer> purlistMap = PdsPurlistUtils.getValidPurilstCount(projectId, PdsCommonUtils.buildSet(ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue(), ProjectStatusEnums.DECIDED.getValue(), ProjectStatusEnums.SIGNED.getValue()));
        if (null == purlistMap || purlistMap.size() == 0) {
            // empty if block
        }
        HashSet<Long> invalidIdSet = new HashSet<Long>();
        for (long purlistId : purlistIds) {
            int count = null == purlistMap || null == purlistMap.get(purlistId) ? 0 : purlistMap.get(purlistId);
            if (count >= minNum) continue;
            invalidIdSet.add(purlistId);
        }
        QFilter qfilter = new QFilter("id", "in", invalidIdSet);
        return this.getQFilterMap(qfilter, null);
    }
}

