/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.extplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import org.apache.commons.lang3.StringUtils;

public class ExtPluginFactory {
    private static Log logger = LogFactory.getLog(ExtPluginFactory.class);

    public <E> E getExtPluginInstance(String number) {
        List<E> extPluginInstances = this.getExtPluginInstances(number);
        if (null == extPluginInstances || extPluginInstances.size() == 0) {
            return null;
        }
        return extPluginInstances.get(0);
    }

    public <E> E getExtPluginInstance(String number, String defaultClass) {
        E instance = this.getExtPluginInstance(number);
        if (null == instance && !StringUtils.isBlank((CharSequence)defaultClass)) {
            instance = this.createInstanceByQualifiedName(defaultClass);
        }
        return instance;
    }

    public <E> List<E> getExtPluginInstances(String number) {
        List<String> extPluginNames = this.getExtPluginNames(number);
        return this.getExtPluginInstances(extPluginNames);
    }

    public <E> List<E> getExtPluginInstances(String number, String defaultClass) {
        E instance;
        List<E> extPluginInstances = this.getExtPluginInstances(number);
        if (extPluginInstances.size() == 0 && !StringUtils.isBlank((CharSequence)defaultClass) && (instance = this.createInstanceByQualifiedName(defaultClass)) != null) {
            extPluginInstances.add(instance);
        }
        return extPluginInstances;
    }

    public <E> E getExtPluginInstanceSingle(String number, String defaultClass) {
        String key = "pds_extplugin|" + number;
        Object instance = PdsObjectPools.getInstance(key);
        if (null != instance) {
            return (E)instance;
        }
        instance = this.getExtPluginInstance(number, defaultClass);
        if (null != instance) {
            PdsObjectPools.putInstance(key, instance);
        }
        return (E)instance;
    }

    public <E> E getExtPluginInstanceSingle(String extPluginName) {
        Object instance = PdsObjectPools.getInstance(extPluginName);
        if (null != instance) {
            return (E)instance;
        }
        instance = this.createInstanceByQualifiedName(extPluginName);
        if (null != instance) {
            PdsObjectPools.putInstance(extPluginName, instance);
        }
        return (E)instance;
    }

    public <E> List<E> getExtPluginInstancesSingle(String number, String defaultClass) {
        List<String> extPluginNames = this.getExtPluginNames(number);
        ArrayList<E> extPluginInstances = new ArrayList<E>(8);
        if (extPluginNames != null && extPluginNames.size() > 0) {
            for (String extPluginName : extPluginNames) {
                E instance = this.getExtPluginInstanceSingle(extPluginName);
                if (instance == null) continue;
                extPluginInstances.add(instance);
            }
        }
        if (extPluginInstances.size() == 0 && !StringUtils.isBlank((CharSequence)defaultClass)) {
            E instance = this.getExtPluginInstanceSingle(defaultClass);
            extPluginInstances.add(instance);
        }
        return extPluginInstances;
    }

    private List<String> getExtPluginNames(String number) {
        List<String> pluginNames = Collections.emptyList();
        QFilter qFilter = new QFilter("number", "=", (Object)number).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pds_extplugin", (String)"pluginname", (QFilter[])new QFilter[]{qFilter}, (String)"order");
        if (null != rows && rows.size() > 0) {
            pluginNames = rows.stream().map(row -> row.getString("pluginname")).collect(Collectors.toList());
        }
        return pluginNames;
    }

    public <E> List<E> getExtPluginInstances(List<String> extPluginNames) {
        if (extPluginNames == null || extPluginNames.size() == 0) {
            return Collections.emptyList();
        }
        StringBuilder logMsg = new StringBuilder();
        ArrayList<E> extPluginInstances = new ArrayList<E>(8);
        for (String extPluginName : extPluginNames) {
            E instance = this.createInstanceByQualifiedNameForBatch(extPluginName);
            if (instance != null) {
                extPluginInstances.add(instance);
                continue;
            }
            logMsg.append("###instance fail:").append(extPluginName).append(';');
        }
        logger.info(logMsg.length() == 0 ? "###getExtPluginInstances" : logMsg.toString());
        return extPluginInstances;
    }

    public <E> E createInstanceByQualifiedNameForBatch(String extPluginName) {
        E instance = null;
        try {
            instance = (E)Class.forName(extPluginName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ext) {
            return instance;
        }
        return instance;
    }

    private <E> E createInstanceByQualifiedName(String extPluginName) {
        E instance = null;
        try {
            instance = (E)Class.forName(extPluginName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ext) {
            return instance;
        }
        return instance;
    }

    public static void executeExtplugin(String number, ExtPluginContext context, boolean isFailContinue) {
        ExtPluginFactory.executeExtplugin(number, context, isFailContinue, null);
    }

    public static void executeExtplugin(String number, ExtPluginContext context, boolean isFailContinue, String defaultClass) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, defaultClass);
        if (null == handlers || handlers.size() == 0) {
            context.setSucced(false);
            return;
        }
        for (IExtPluginHandler handler : handlers) {
            if (!isFailContinue && !context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static ExtPluginContext createContext(IFormView view, String operationKey, boolean isComponent) {
        ExtPluginContext context = new ExtPluginContext();
        if (isComponent) {
            context.setProjectObj(view.getParentView().getModel().getDataEntity(true));
        } else {
            context.setProjectObj(view.getModel().getDataEntity(true));
        }
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        context.setBillObj(view.getModel().getDataEntity(true));
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()));
        context.setView(view);
        context.setOperationKey(operationKey);
        return context;
    }

    private ExtPluginFactory() {
    }

    public static ExtPluginFactory getInstance() {
        return SingletonHolder.SINSTANCE;
    }

    private static class SingletonHolder {
        private static final ExtPluginFactory SINSTANCE = new ExtPluginFactory();

        private SingletonHolder() {
        }
    }
}

