/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.IFeeManageConfig;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsParameterUtils;

public class FeeManageConfig
implements IFeeManageConfig {
    @Override
    public Map<String, Object> getFeeManageConfig(FeeManageContext context) {
        DynamicObjectCollection feeCfgObjs;
        if (null == context.getProjectObj() && context.getProjectId() > 0L) {
            context.setProjectObj(BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_project"));
        }
        if (context.getProjectId() == 0L) {
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        }
        if (null == (feeCfgObjs = QueryServiceHelper.query((String)"src_paymanage_cfg", (String)"id,feeway.id feewayid,feeway.number feeway,feeitem.id feeitem,currency.id currency,feeamount,docamount,entrypackage.package.id package,entrypackage.packfeeamount packfeeamount,entrypackage.packdocamount packdocamount, org.id org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getProjectId())})) || feeCfgObjs.size() == 0) {
            return null;
        }
        String feeway = ((DynamicObject)feeCfgObjs.get(0)).getString("feeway");
        if ("C020701".equals(feeway)) {
            return null;
        }
        HashMap<String, Object> feeCfgMap = new HashMap<String, Object>(feeCfgObjs.size());
        feeCfgMap.put("feeway", feeway);
        feeCfgMap.put("feewayid", ((DynamicObject)feeCfgObjs.get(0)).get("feewayid"));
        feeCfgMap.put("feeitem", ((DynamicObject)feeCfgObjs.get(0)).get("feeitem"));
        feeCfgMap.put("currency", ((DynamicObject)feeCfgObjs.get(0)).get("currency"));
        feeCfgMap.put("feeamount", ((DynamicObject)feeCfgObjs.get(0)).getBigDecimal("feeamount"));
        feeCfgMap.put("docamount", ((DynamicObject)feeCfgObjs.get(0)).getBigDecimal("docamount"));
        feeCfgMap.put("org", ((DynamicObject)feeCfgObjs.get(0)).getLong("org"));
        if ("C020703".equals(feeway)) {
            for (DynamicObject feeCfgObj : feeCfgObjs) {
                feeCfgMap.put(feeCfgObj.getString("package"), feeCfgObj.get("packfeeamount"));
                feeCfgMap.put(feeCfgObj.getString("package") + "_doc", feeCfgObj.get("packdocamount"));
            }
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("srctype"));
        boolean isAutoEexempt = ExtParameterUtils.convertToBoolen(ExtParameterUtils.getExtParameterValueById("pds_flowconfig", sourceFlowId, "isAutoExemptPayment", true, SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())));
        feeCfgMap.put("isAutoExemptPayment", isAutoEexempt);
        return feeCfgMap;
    }

    @Override
    public String buildSurplusBillNo(FeeManageContext context) {
        Set<String> fieldNameSet = PdsParameterUtils.getSurplusFieldSet();
        StringBuilder billid = new StringBuilder();
        for (String fieldName : fieldNameSet) {
            Object obj = context.getDataMap().get(fieldName);
            if (null == obj) {
                return null;
            }
            if (obj instanceof DynamicObject) {
                billid.append(SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)obj))).append('|');
                continue;
            }
            billid.append(obj).append('|');
        }
        return billid.toString();
    }

    @Override
    public Map<String, Object> getSurplusFieldsValue(FeeManageContext context) {
        Set<String> fieldNameSet = PdsParameterUtils.getSurplusFieldSet();
        HashMap<String, Object> surplusMap = new HashMap<String, Object>(16);
        Object projectIdObj = context.getPaymentObj().get("project");
        if (null == projectIdObj) {
            return null;
        }
        long projectId = projectIdObj instanceof DynamicObject ? SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)projectIdObj)) : (Long)projectIdObj;
        if (!QueryServiceHelper.exists((String)"src_projectf7", (Object)projectId)) {
            return null;
        }
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_projectf7");
        StringBuilder billid = new StringBuilder();
        for (String fieldName : fieldNameSet) {
            Object obj = null;
            switch (fieldName) {
                case "supplier": 
                case "surplustype": {
                    obj = context.getPaymentObj().get(fieldName);
                    break;
                }
                case "org": 
                case "source": 
                case "feeitem": 
                case "currency": {
                    obj = projectObj.get(fieldName);
                    break;
                }
            }
            if (obj instanceof DynamicObject) {
                surplusMap.put(fieldName, SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)obj)));
                billid.append(SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)obj))).append('|');
                continue;
            }
            surplusMap.put(fieldName, obj);
            billid.append(obj).append('|');
        }
        surplusMap.put("billid", billid.toString());
        surplusMap.put("creator", projectObj.get("creator"));
        surplusMap.put("createtime", projectObj.get("createtime"));
        surplusMap.put("createorg", projectObj.get("org"));
        return surplusMap;
    }

    @Override
    public Map<String, Object> getSurplusFieldsValue(IDataModel model) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("surplustype", model.getValue("surplustype"));
        dataMap.put("suppliertype", model.getValue("suppliertype"));
        dataMap.put("supplier", SrmCommonUtil.getPkValue((DynamicObject)model.getDataEntity().getDynamicObject("supplier")));
        dataMap.put("org", SrmCommonUtil.getPkValue((DynamicObject)model.getDataEntity().getDynamicObject("org")));
        dataMap.put("createorg", SrmCommonUtil.getPkValue((DynamicObject)model.getDataEntity().getDynamicObject("createorg")));
        dataMap.put("source", SrmCommonUtil.getPkValue((DynamicObject)model.getDataEntity().getDynamicObject("source")));
        dataMap.put("feeitem", SrmCommonUtil.getPkValue((DynamicObject)model.getDataEntity().getDynamicObject("feeitem")));
        dataMap.put("currency", SrmCommonUtil.getPkValue((DynamicObject)model.getDataEntity().getDynamicObject("currency")));
        dataMap.put("surplusamount", model.getDataEntity().getBigDecimal("surplusamount"));
        dataMap.put("remark", model.getDataEntity().getString("remark"));
        dataMap.put("creator", RequestContext.get().getUserId());
        dataMap.put("createtime", TimeServiceHelper.now());
        return dataMap;
    }
}

