/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.feemanage.FeeManageConfig;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.IFeeManageConfig;
import kd.scm.pds.common.feemanage.IPaymentEntryHelper;
import kd.scm.pds.common.feemanage.IPaymentStatusHelper;
import kd.scm.pds.common.feemanage.ISurplusEditHelper;
import kd.scm.pds.common.feemanage.ISurplusEntryHelper;
import kd.scm.pds.common.feemanage.ISurplusStatusHelper;
import kd.scm.pds.common.feemanage.ITenderStatusHelper;
import kd.scm.pds.common.feemanage.PaymentEntryHelper;
import kd.scm.pds.common.feemanage.PaymentStatusHelper;
import kd.scm.pds.common.feemanage.SurplusEditHelper;
import kd.scm.pds.common.feemanage.SurplusEntryHelper;
import kd.scm.pds.common.feemanage.SurplusStatusHelper;
import kd.scm.pds.common.feemanage.TenderStatusHelper;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class FeeManageUtils {
    public static FeeManageContext getContextInstance() {
        return (FeeManageContext)ExtPluginFactory.getInstance().getExtPluginInstance(FeeManageContext.class.getSimpleName(), FeeManageContext.class.getName());
    }

    public static void adjustPaymentStatus(Map<String, Object> dataMap) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setDataMap(dataMap);
        IPaymentEntryHelper entryHelper = (IPaymentEntryHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentEntryHelper.class.getSimpleName());
        if (null == entryHelper) {
            entryHelper = new PaymentEntryHelper();
        }
        entryHelper.createPaymentEntryInit(context);
        entryHelper.afterCreatePaymentEntry(context);
    }

    public static void clearTenderPayInfo(FeeManageContext context) {
        ITenderStatusHelper tenderHelper = (ITenderStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ITenderStatusHelper.class.getSimpleName());
        if (null == tenderHelper) {
            tenderHelper = new TenderStatusHelper();
        }
        tenderHelper.clearTenderPayInfo(context);
    }

    public static void createPaymentEntry(long projectId) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setProjectId(projectId);
        IPaymentEntryHelper entryHelper = (IPaymentEntryHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentEntryHelper.class.getSimpleName());
        if (null == entryHelper) {
            entryHelper = new PaymentEntryHelper();
        }
        entryHelper.createPaymentEntry(context);
        entryHelper.afterCreatePaymentEntry(context);
    }

    public static void createPaymentEntryInit(IDataModel model) {
        Map<String, Object> dataMap = FeeManageUtils.getSurplusFieldsValue(model);
        FeeManageUtils.adjustPaymentStatus(dataMap);
    }

    public static long createSurplusEntry(DynamicObject paymentObj) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setPaymentObj(paymentObj);
        ISurplusEntryHelper entryHelper = (ISurplusEntryHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusEntryHelper.class.getSimpleName());
        if (null == entryHelper) {
            entryHelper = new SurplusEntryHelper();
        }
        return entryHelper.createSurplusEntry(context);
    }

    public static void createSurplusEntryEntity(IFormView view) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setView(view);
        ISurplusEditHelper editHelper = (ISurplusEditHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusEditHelper.class.getSimpleName());
        if (null == editHelper) {
            editHelper = new SurplusEditHelper();
        }
        editHelper.createSurplusEntryEntity(context);
    }

    public static long createSurplusEntryInit(FeeManageContext context) {
        ISurplusEntryHelper entryHelper = (ISurplusEntryHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusEntryHelper.class.getSimpleName());
        if (null == entryHelper) {
            entryHelper = new SurplusEntryHelper();
        }
        return entryHelper.createSurplusEntryInit(context);
    }

    public static void deletePaymentEntry(long projectId) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setProjectId(projectId);
        IPaymentEntryHelper entryHelper = (IPaymentEntryHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentEntryHelper.class.getSimpleName());
        if (null == entryHelper) {
            entryHelper = new PaymentEntryHelper();
        }
        entryHelper.deletePaymentEntry(context);
    }

    public static Map<String, Object> getFeeManageConfig(FeeManageContext context) {
        IFeeManageConfig configHelper = (IFeeManageConfig)ExtPluginFactory.getInstance().getExtPluginInstance(IFeeManageConfig.class.getSimpleName());
        if (null == configHelper) {
            configHelper = new FeeManageConfig();
        }
        return configHelper.getFeeManageConfig(context);
    }

    public static BigDecimal getSurplusAmount(long surplusId) {
        if (surplusId == 0L) {
            return BigDecimal.ZERO;
        }
        QFilter qfilters = new QFilter("id", "=", (Object)surplusId);
        return FeeManageUtils.getSurplusAmount(qfilters);
    }

    public static BigDecimal getSurplusAmount(QFilter qfilters) {
        DynamicObject surplusObj = QueryServiceHelper.queryOne((String)"src_feesurplus", (String)"surplusamount", (QFilter[])qfilters.toArray());
        if (null != surplusObj) {
            return surplusObj.getBigDecimal("surplusamount");
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getSurplusAmount(String billId) {
        if (StringUtils.isBlank((CharSequence)billId)) {
            return BigDecimal.ZERO;
        }
        QFilter qfilters = new QFilter("billid", "=", (Object)billId);
        return FeeManageUtils.getSurplusAmount(qfilters);
    }

    public static String buildSurplusBillNo(IDataModel model) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        Map<String, Object> dataMap = FeeManageUtils.getSurplusFieldsValue(model);
        context.setDataMap(dataMap);
        return FeeManageUtils.buildSurplusBillNo(context);
    }

    public static String buildSurplusBillNo(FeeManageContext context) {
        IFeeManageConfig configHelper = (IFeeManageConfig)ExtPluginFactory.getInstance().getExtPluginInstance(IFeeManageConfig.class.getSimpleName());
        if (null == configHelper) {
            configHelper = new FeeManageConfig();
        }
        return configHelper.buildSurplusBillNo(context);
    }

    public static Map<String, Object> getSurplusFieldsValue(IDataModel model) {
        IFeeManageConfig configHelper = (IFeeManageConfig)ExtPluginFactory.getInstance().getExtPluginInstance(IFeeManageConfig.class.getSimpleName());
        if (null == configHelper) {
            configHelper = new FeeManageConfig();
        }
        return configHelper.getSurplusFieldsValue(model);
    }

    public static Map<String, Object> getSurplusFieldsValue(FeeManageContext context) {
        IFeeManageConfig configHelper = (IFeeManageConfig)ExtPluginFactory.getInstance().getExtPluginInstance(IFeeManageConfig.class.getSimpleName());
        if (null == configHelper) {
            configHelper = new FeeManageConfig();
        }
        return configHelper.getSurplusFieldsValue(context);
    }

    public static void giveBackSurplus(long projectId) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setProjectId(projectId);
        IPaymentStatusHelper statusHelper = (IPaymentStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentStatusHelper.class.getSimpleName());
        if (null == statusHelper) {
            statusHelper = new PaymentStatusHelper();
        }
        statusHelper.giveBackSurplus(context);
    }

    public static void openPaymentHandlePage(String opKey, DynamicObject paymentObj, IFormView view) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setOpkey(opKey);
        context.setPaymentObj(paymentObj);
        context.setView(view);
        ISurplusEditHelper editHelper = (ISurplusEditHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusEditHelper.class.getSimpleName());
        if (null == editHelper) {
            editHelper = new SurplusEditHelper();
        }
        editHelper.openPaymentHandlePage(context);
    }

    public static void setSurplusFieldVisibleEdit(IFormView view) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setView(view);
        ISurplusEditHelper editHelper = (ISurplusEditHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusEditHelper.class.getSimpleName());
        if (null == editHelper) {
            editHelper = new SurplusEditHelper();
        }
        editHelper.setSurplusFieldVisibleEdit(context);
    }

    public static void setSurplusFieldVisibleList(BeforeCreateListColumnsArgs args) {
        ISurplusEditHelper editHelper = (ISurplusEditHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusEditHelper.class.getSimpleName());
        if (null == editHelper) {
            editHelper = new SurplusEditHelper();
        }
        editHelper.setSurplusFieldVisibleList(args);
    }

    public static void transferSurplus(FeeManageContext context, String transferField, Boolean isNegate) {
        context.setTransferField(transferField);
        context.setNegate(isNegate);
        ISurplusStatusHelper surplusHelper = (ISurplusStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusStatusHelper.class.getSimpleName());
        if (null == surplusHelper) {
            surplusHelper = new SurplusStatusHelper();
        }
        surplusHelper.transferSurplus(context);
    }

    public static void updatePaymentResult(long projectId) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setProjectId(projectId);
        IPaymentStatusHelper statusHelper = (IPaymentStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentStatusHelper.class.getSimpleName());
        if (null == statusHelper) {
            statusHelper = new PaymentStatusHelper();
        }
        statusHelper.updateResult(context);
    }

    public static void updatePaymentStatus(Map<String, Object> dataMap) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setDataMap(dataMap);
        IPaymentStatusHelper statusHelper = (IPaymentStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentStatusHelper.class.getSimpleName());
        if (null == statusHelper) {
            statusHelper = new PaymentStatusHelper();
        }
        statusHelper.updatePayStatus(context);
    }

    public static void updateSurplus(Map<String, BigDecimal> surplusMap) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setSurplusMap(surplusMap);
        ISurplusStatusHelper surplusHelper = (ISurplusStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusStatusHelper.class.getSimpleName());
        if (null == surplusHelper) {
            surplusHelper = new SurplusStatusHelper();
        }
        surplusHelper.updateSurplus(context);
    }

    public static void updateSurplusTotal(FeeManageContext context, String sourceField, String totalField) {
        long surplusId = context.getSurplusId();
        if (surplusId == 0L) {
            surplusId = FeeManageUtils.createSurplusEntry(context.getPaymentObj());
        }
        HashMap<String, BigDecimal> surplusMap = new HashMap<String, BigDecimal>(1);
        surplusMap.put(String.valueOf(surplusId), context.getPaymentObj().getBigDecimal(sourceField));
        context.setSurplusMap(surplusMap);
        context.setTotalField(totalField);
        ISurplusStatusHelper surplusHelper = (ISurplusStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ISurplusStatusHelper.class.getSimpleName());
        if (null == surplusHelper) {
            surplusHelper = new SurplusStatusHelper();
        }
        surplusHelper.updateSurplusTotal(context);
    }

    public static void updateTenderPayInfo(FeeManageContext context) {
        ITenderStatusHelper tenderHelper = (ITenderStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ITenderStatusHelper.class.getSimpleName());
        if (null == tenderHelper) {
            tenderHelper = new TenderStatusHelper();
        }
        tenderHelper.updateTenderPayInfo(context);
    }

    public static void updateTenderPayInfoBatch(FeeManageContext context) {
        ITenderStatusHelper tenderHelper = (ITenderStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(ITenderStatusHelper.class.getSimpleName());
        if (null == tenderHelper) {
            tenderHelper = new TenderStatusHelper();
        }
        tenderHelper.updateTenderPayInfoBatch(context);
    }

    public static boolean verifyPayStatus(String opKey, DynamicObject paymentObj, IFormView view) {
        FeeManageContext context = FeeManageUtils.getContextInstance();
        context.setOpkey(opKey);
        context.setPaymentObj(paymentObj);
        context.setView(view);
        IPaymentStatusHelper statusHelper = (IPaymentStatusHelper)ExtPluginFactory.getInstance().getExtPluginInstance(IPaymentStatusHelper.class.getSimpleName());
        if (null == statusHelper) {
            statusHelper = new PaymentStatusHelper();
        }
        statusHelper.verifyPayStatus(context);
        return context.isSucced();
    }

    public static boolean isNeedHandlePaypment(DynamicObject billObj) {
        String entityName = billObj.getDataEntityType().getName();
        if ("src_paymanage".equals(entityName)) {
            return true;
        }
        if (PdsFlowConfigUtils.existsSpecificNode(billObj, PdsBizNodeEnums.PAYMANAGE.getValue())) {
            return false;
        }
        return TemplateUtil.getCompKeyList(billObj).contains("src_paymanage_cfg");
    }

    public static boolean isButtonVisible(String opKey, String payStatus) {
        switch (opKey) {
            case "confirm": {
                return PayStatusEnums.NOCONFIRM.getValue().equals(payStatus);
            }
            case "reject": {
                return PayStatusEnums.NOCONFIRM.getValue().equals(payStatus);
            }
            case "exempt": {
                return PayStatusEnums.NOPAY.getValue().equals(payStatus);
            }
            case "return": {
                return PayStatusEnums.CONFIRMED.getValue().equals(payStatus);
            }
            case "transfer": {
                return PayStatusEnums.CONFIRMED.getValue().equals(payStatus);
            }
            case "carryover": {
                return PayStatusEnums.CONFIRMED.getValue().equals(payStatus);
            }
        }
        return false;
    }
}

