/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.feemanage.IPaymentEntryHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class PaymentEntryHelper
implements IPaymentEntryHelper {
    @Override
    public void createPaymentEntry(FeeManageContext context) {
        Map<String, Object> feeCfgMap;
        if (context.getProjectId() == 0L) {
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        }
        if (null == (feeCfgMap = FeeManageUtils.getFeeManageConfig(context)) || feeCfgMap.size() == 0) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)context.getSurplustype())) {
            context.setSurplustype("1");
        }
        feeCfgMap.put("surplustype", context.getSurplustype());
        String feeway = (String)feeCfgMap.get("feeway");
        if (null == feeway || "C020701".equals(feeway)) {
            return;
        }
        String feeitem = String.valueOf(feeCfgMap.get("feeitem"));
        QFilter paySupFilter = new QFilter("project", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_payment", (String)"suppliertype,supplier.id supplier,package.id package", (QFilter[])paySupFilter.toArray());
        Set<Object> existSupSet = new HashSet(16);
        existSupSet = "C020703".equals(feeway) ? rows.stream().map(e -> e.getString("supplier") + '|' + e.getString("package")).collect(Collectors.toSet()) : rows.stream().map(e -> e.getString("supplier")).collect(Collectors.toSet());
        QFilter qFilters = new QFilter("billid", "=", (Object)context.getProjectId());
        qFilters.and("isabandon", "=", (Object)Boolean.FALSE);
        qFilters.and("isdiscard", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection supplierObjs = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"billid, package.id package, suppliertype,supplier.id supplier,isfeeagent", (QFilter[])qFilters.toArray(), (String)"supplier");
        int index = 0;
        ArrayList<DynamicObject> paymentList = new ArrayList<DynamicObject>(16);
        for (DynamicObject supplierObj : supplierObjs) {
            StringBuilder key = new StringBuilder();
            key.append(supplierObj.getString("supplier"));
            if ("C020703".equals(feeway)) {
                key.append('|');
                key.append(supplierObj.getString("package"));
            }
            if (!existSupSet.add(key.toString())) continue;
            if ("775219867547625472".equals(feeitem)) {
                this.createDocAmountEntry(paymentList, supplierObj, feeCfgMap, index);
                ++index;
                continue;
            }
            if ("775220031326809088".equals(feeitem)) {
                this.createFeeAmountEntry(paymentList, supplierObj, feeCfgMap, index);
                ++index;
                continue;
            }
            this.createDocAmountEntry(paymentList, supplierObj, feeCfgMap, index);
            this.createFeeAmountEntry(paymentList, supplierObj, feeCfgMap, ++index);
            ++index;
        }
        if (null != paymentList && paymentList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])paymentList.toArray(new DynamicObject[paymentList.size()]));
        }
        if (context.getSurplustype().equals("1")) {
            FeeManageUtils.updateTenderPayInfoBatch(context);
        }
    }

    private void createDocAmountEntry(List<DynamicObject> paymentList, DynamicObject supplierObj, Map<String, Object> feeCfgMap, int index) {
        DynamicObject paymentObj = BusinessDataServiceHelper.newDynamicObject((String)"src_payment");
        PdsCommonUtils.setPrimaryKey(paymentObj);
        this.setEntryValue(paymentObj, supplierObj, feeCfgMap, index, "775219867547625472");
        paymentList.add(paymentObj);
    }

    private void createFeeAmountEntry(List<DynamicObject> paymentList, DynamicObject supplierObj, Map<String, Object> feeCfgMap, int index) {
        DynamicObject paymentObj = BusinessDataServiceHelper.newDynamicObject((String)"src_payment");
        PdsCommonUtils.setPrimaryKey(paymentObj);
        this.setEntryValue(paymentObj, supplierObj, feeCfgMap, index, "775220031326809088");
        this.setEntryValueSurplus(paymentObj, supplierObj, feeCfgMap, index);
        paymentList.add(paymentObj);
    }

    @Override
    public void createPaymentEntryInit(FeeManageContext context) {
        DynamicObject paymentObj = BusinessDataServiceHelper.newDynamicObject((String)"src_payment");
        ORM.create().setPrimaryKey(paymentObj);
        paymentObj.set("suppliertype", context.getDataMap().get("suppliertype"));
        paymentObj.set("supplier", context.getDataMap().get("supplier"));
        paymentObj.set("currency", context.getDataMap().get("currency"));
        paymentObj.set("paystatus", (Object)PayStatusEnums.TRANSFERED.getValue());
        paymentObj.set("entrystatus", (Object)BillStatusEnum.AUDIT.getVal());
        long surplusId = FeeManageUtils.createSurplusEntryInit(context);
        paymentObj.set("surplusid", (Object)surplusId);
        context.setSurplusId(surplusId);
        BigDecimal preSurplusAmont = FeeManageUtils.getSurplusAmount(surplusId);
        paymentObj.set("presurplusamount", (Object)preSurplusAmont);
        BigDecimal surplusamount = (BigDecimal)context.getDataMap().get("surplusamount");
        BigDecimal transferamount = surplusamount.subtract(preSurplusAmont);
        paymentObj.set("transferamount", (Object)transferamount);
        HashMap<String, BigDecimal> surplusMap = new HashMap<String, BigDecimal>(1);
        surplusMap.put(String.valueOf(surplusId), transferamount);
        FeeManageUtils.updateSurplus(surplusMap);
        BigDecimal surplusAmont = FeeManageUtils.getSurplusAmount(surplusId);
        paymentObj.set("surplusamount", (Object)surplusAmont);
        paymentObj.set("transferdate", (Object)TimeServiceHelper.now());
        paymentObj.set("transferuser", (Object)RequestContext.get().getCurrUserId());
        String remark = (String)context.getDataMap().get("remark");
        if (remark == null || "".equals(remark)) {
            remark = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d\u8c03\u6574", (String)"PaymentEntryHelper_0", (String)"scm-pds-common", (Object[])new Object[0]);
        }
        paymentObj.set("remark", (Object)remark);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{paymentObj});
        context.setPaymentObj(paymentObj);
        FeeManageUtils.updateSurplusTotal(context, "transferamount", "sumadjust");
    }

    @Override
    public void deletePaymentEntry(FeeManageContext context) {
        QFilter qfilters;
        DynamicObjectCollection rows;
        if (context.getProjectId() == 0L) {
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        }
        if (null == (rows = QueryServiceHelper.query((String)"src_payment", (String)"surplusid,usesurplus", (QFilter[])(qfilters = new QFilter("project.id", "=", (Object)context.getProjectId())).toArray())) || rows.size() == 0) {
            return;
        }
        HashMap<String, BigDecimal> surplusMap = new HashMap<String, BigDecimal>(8);
        for (DynamicObject row : rows) {
            String surplusId;
            BigDecimal usesurplus = row.getBigDecimal("usesurplus");
            if (usesurplus.compareTo(BigDecimal.ZERO) <= 0 || null == (surplusId = row.getString("surplusid")) || "0".equals(surplusId)) continue;
            if (null == surplusMap.get(surplusId)) {
                surplusMap.put(surplusId, usesurplus);
                continue;
            }
            surplusMap.put(surplusId, ((BigDecimal)surplusMap.get(surplusId)).add(usesurplus));
        }
        FeeManageUtils.updateSurplus(surplusMap);
        FeeManageUtils.clearTenderPayInfo(context);
        DeleteServiceHelper.delete((String)"src_payment", (QFilter[])qfilters.toArray());
    }

    public void setEntryValue(DynamicObject paymentObj, DynamicObject supplierObj, Map<String, Object> feeCfgMap, int index, String feeitem) {
        paymentObj.set("project", supplierObj.get("billid"));
        paymentObj.set("feeway", feeCfgMap.get("feewayid"));
        String feeway = (String)feeCfgMap.get("feeway");
        if ("C020703".equals(feeway)) {
            paymentObj.set("package", supplierObj.get("package"));
        }
        paymentObj.set("suppliertype", supplierObj.get("suppliertype"));
        paymentObj.set("supplier", supplierObj.get("supplier"));
        paymentObj.set("bizpartner", (Object)0L);
        paymentObj.set("feeamount", feeCfgMap.get("amount"));
        paymentObj.set("currency", feeCfgMap.get("currency"));
        paymentObj.set("paystatus", (Object)PayStatusEnums.NOPAY.getValue());
        paymentObj.set("entrystatus", (Object)BillStatusEnum.SAVE.getVal());
        paymentObj.set("result", (Object)"0");
        paymentObj.set("isfeeagent", supplierObj.get("isfeeagent"));
        paymentObj.set("org", feeCfgMap.get("org"));
        paymentObj.set("surplustype", feeCfgMap.get("surplustype"));
        BigDecimal feeAmount = BigDecimal.ZERO;
        if ("775219867547625472".equals(feeitem)) {
            feeAmount = this.getdocAmount(supplierObj, feeCfgMap);
            paymentObj.set("amount", (Object)feeAmount);
            paymentObj.set("packfeeitem", (Object)"775219867547625472");
            paymentObj.set("surplustype", (Object)"3");
        } else {
            feeAmount = this.getfeeAmount(supplierObj, feeCfgMap);
            paymentObj.set("packfeeitem", (Object)"775220031326809088");
        }
        paymentObj.set("feeamount", (Object)feeAmount);
        SupplierUtil.setSupplierUser(paymentObj, supplierObj.getLong("billid"), supplierObj.getLong("supplier"));
        PdsCommonUtils.setBillNo("src_payment", paymentObj);
    }

    public void setEntryValueSurplus(DynamicObject paymentObj, DynamicObject supplierObj, Map<String, Object> feeCfgMap, int index) {
        BigDecimal feeAmount = this.getfeeAmount(supplierObj, feeCfgMap);
        long surplusId = FeeManageUtils.createSurplusEntry(paymentObj);
        paymentObj.set("surplusid", (Object)surplusId);
        BigDecimal preSurplusAmont = FeeManageUtils.getSurplusAmount(surplusId);
        paymentObj.set("presurplusamount", (Object)preSurplusAmont);
        BigDecimal usesurplus = BigDecimal.ZERO;
        usesurplus = feeAmount.compareTo(preSurplusAmont) >= 0 ? preSurplusAmont : feeAmount;
        paymentObj.set("usesurplus", (Object)usesurplus);
        paymentObj.set("usedate", (Object)TimeServiceHelper.now());
        paymentObj.set("amount", (Object)feeAmount.subtract(usesurplus));
        if (usesurplus.compareTo(feeAmount) >= 0) {
            if (PdsCommonUtils.object2Boolean(feeCfgMap.get("isAutoExemptPayment"))) {
                paymentObj.set("paystatus", (Object)PayStatusEnums.EXEMPT.getValue());
                paymentObj.set("entrystatus", (Object)BillStatusEnum.AUDIT.getVal());
            } else {
                paymentObj.set("paystatus", (Object)PayStatusEnums.NOCONFIRM.getValue());
                paymentObj.set("entrystatus", (Object)BillStatusEnum.SUBMIT.getVal());
            }
        }
        if (usesurplus.compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, BigDecimal> surplusMap = new HashMap<String, BigDecimal>(1);
            surplusMap.put(String.valueOf(surplusId), usesurplus.negate());
            FeeManageUtils.updateSurplus(surplusMap);
            paymentObj.set("surplusamount", (Object)preSurplusAmont.subtract(usesurplus));
        }
    }

    private BigDecimal getfeeAmount(DynamicObject supplierObj, Map<String, Object> feeCfgMap) {
        BigDecimal feeAmount = BigDecimal.ZERO;
        feeAmount = "C020703".equals(feeCfgMap.get("feeway")) ? (BigDecimal)feeCfgMap.get(supplierObj.getString("package")) : (BigDecimal)feeCfgMap.get("feeamount");
        return feeAmount;
    }

    private BigDecimal getdocAmount(DynamicObject supplierObj, Map<String, Object> feeCfgMap) {
        BigDecimal docAmount = BigDecimal.ZERO;
        docAmount = "C020703".equals(feeCfgMap.get("feeway")) ? (BigDecimal)feeCfgMap.get(supplierObj.getString("package") + "_doc") : (BigDecimal)feeCfgMap.get("docamount");
        return docAmount;
    }

    @Override
    public void afterCreatePaymentEntry(FeeManageContext context) {
    }
}

