/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.feemanage.IPaymentStatusHelper;
import kd.scm.pds.common.feemanage.statusStrategy.IPaymentStatusStrategy;
import org.apache.commons.lang3.StringUtils;

public class PaymentStatusHelper
implements IPaymentStatusHelper {
    private static final long serialVersionUID = 1L;
    private static final String CLASSNAME_PREFIX = "PaymentStatus_";
    private static final String FULLCLASSNAME_PREFIX = "kd.scm.pds.common.feemanage.statusOp";

    @Override
    public void verifyPayStatus(FeeManageContext context) {
        IPaymentStatusStrategy statusStrategy = this.getInstance(context);
        if (statusStrategy == null) {
            return;
        }
        statusStrategy.verifyPayStatus(context);
    }

    @Override
    public void updatePayStatus(FeeManageContext context) {
        IPaymentStatusStrategy statusStrategy = this.getInstance(context);
        if (statusStrategy == null) {
            return;
        }
        statusStrategy.updatePayStatus(context);
    }

    @Override
    public void updateResult(FeeManageContext context) {
        String supplier = "supplier.id";
        String packages = "package.id";
        String result = "result";
        long projectId = context.getProjectId();
        QFilter qFilters = new QFilter("project.id", "=", (Object)projectId);
        DynamicObject[] paymentObjs = BusinessDataServiceHelper.load((String)"src_payment", (String)"suppliertype,supplier,project,package,feeway,result", (QFilter[])qFilters.toArray());
        if (null == paymentObjs || paymentObjs.length == 0) {
            return;
        }
        String feeway = paymentObjs[0].getString("feeway.number");
        if (!"C020702".equals(feeway) && !"C020703".equals(feeway)) {
            return;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"suppliertype,supplier.id,package.id,result", (QFilter[])(qFilters = qFilters.and(new QFilter("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue()))).toArray());
        if (null == rows || rows.size() == 0) {
            return;
        }
        for (DynamicObject paymentObj : paymentObjs) {
            if ("C020702".equals(feeway)) {
                if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == paymentObj.getLong("supplier.id") && e.getString("result").equals("1"))) {
                    paymentObj.set("result", (Object)"1");
                    continue;
                }
                if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == paymentObj.getLong("supplier.id") && e.getString("result").equals("2"))) {
                    paymentObj.set("result", (Object)"2");
                    continue;
                }
                if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == paymentObj.getLong("supplier.id") && e.getString("result").equals("5"))) {
                    paymentObj.set("result", (Object)"5");
                    continue;
                }
                paymentObj.set("result", (Object)"3");
                continue;
            }
            if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == paymentObj.getLong("supplier.id") && e.getLong("package.id") == paymentObj.getLong("package.id") && e.getString("result").equals("1"))) {
                paymentObj.set("result", (Object)"1");
                continue;
            }
            if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == paymentObj.getLong("supplier.id") && e.getLong("package.id") == paymentObj.getLong("package.id") && e.getString("result").equals("2"))) {
                paymentObj.set("result", (Object)"2");
                continue;
            }
            if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == paymentObj.getLong("supplier.id") && e.getLong("package.id") == paymentObj.getLong("package.id") && e.getString("result").equals("5"))) {
                paymentObj.set("result", (Object)"5");
                continue;
            }
            paymentObj.set("result", (Object)"3");
        }
        SaveServiceHelper.save((DynamicObject[])paymentObjs);
    }

    @Override
    public void giveBackSurplus(FeeManageContext context) {
        QFilter qFilters = new QFilter("project.id", "=", (Object)context.getProjectId());
        HashSet<String> statusSet = new HashSet<String>(3);
        statusSet.add(PayStatusEnums.NOPAY.getValue());
        statusSet.add(PayStatusEnums.NOCONFIRM.getValue());
        statusSet.add(PayStatusEnums.EXEMPT.getValue());
        statusSet.add(PayStatusEnums.CONFIRMED.getValue());
        qFilters = qFilters.and("paystatus", "in", statusSet);
        qFilters = qFilters.and(new QFilter("usesurplus", ">", (Object)BigDecimal.ZERO));
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_payment", (boolean)Boolean.FALSE);
        DynamicObject[] paymentObjs = BusinessDataServiceHelper.load((String)"src_payment", (String)selectFields, (QFilter[])qFilters.toArray());
        if (null == paymentObjs || paymentObjs.length == 0) {
            return;
        }
        for (DynamicObject paymentObj : paymentObjs) {
            if (PayStatusEnums.CONFIRMED.getValue().equals(paymentObj.get("paystatus"))) {
                paymentObj.set("transferamount", (Object)paymentObj.getBigDecimal("payamount").add(paymentObj.getBigDecimal("usesurplus")));
            } else {
                paymentObj.set("transferamount", (Object)paymentObj.getBigDecimal("usesurplus"));
            }
            paymentObj.set("paystatus", (Object)PayStatusEnums.TRANSFERED.getValue());
            context.setPaymentObj(paymentObj);
            FeeManageUtils.transferSurplus(context, "transferamount", Boolean.FALSE);
        }
    }

    private IPaymentStatusStrategy getInstance(FeeManageContext context) {
        IPaymentStatusStrategy statusStrategy = null;
        String opkey = context.getOpkey();
        if (StringUtils.isBlank((CharSequence)opkey) && StringUtils.isBlank((CharSequence)(opkey = (String)context.getDataMap().get("opkey")))) {
            return statusStrategy;
        }
        String className = CLASSNAME_PREFIX + opkey;
        statusStrategy = (IPaymentStatusStrategy)ExtPluginFactory.getInstance().getExtPluginInstance(className);
        if (statusStrategy != null) {
            return statusStrategy;
        }
        String fullClassName = FULLCLASSNAME_PREFIX + className;
        try {
            statusStrategy = (IPaymentStatusStrategy)Class.forName(fullClassName).newInstance();
        }
        catch (Exception e) {
            context.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u5f53\u524d\u64cd\u4f5c\u7684\u5b9e\u73b0\u7c7b\uff1a%1$s", (String)"PaymentStatusHelper_1", (String)"scm-pds-common", (Object[])new Object[0]), fullClassName));
        }
        return statusStrategy;
    }
}

