/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.ISurplusEditHelper;
import kd.scm.pds.common.util.PdsParameterUtils;

public class SurplusEditHelper
implements ISurplusEditHelper {
    @Override
    public void setSurplusFieldVisibleEdit(FeeManageContext context) {
        Set<String> fieldNameSet = PdsParameterUtils.getSurplusFieldSet();
        if (!fieldNameSet.contains("org")) {
            context.getView().setVisible(Boolean.FALSE, new String[]{"org"});
            ((BasedataEdit)context.getView().getControl("org")).setMustInput(false);
        } else {
            ((BasedataEdit)context.getView().getControl("org")).setMustInput(true);
            context.getView().setVisible(Boolean.FALSE, new String[]{"createorg"});
            ((BasedataEdit)context.getView().getControl("createorg")).setMustInput(false);
        }
        if (!fieldNameSet.contains("feeitem")) {
            context.getView().setVisible(Boolean.FALSE, new String[]{"feeitem"});
            ((BasedataEdit)context.getView().getControl("feeitem")).setMustInput(false);
        } else {
            ((BasedataEdit)context.getView().getControl("feeitem")).setMustInput(true);
        }
        if (!fieldNameSet.contains("source")) {
            context.getView().setVisible(Boolean.FALSE, new String[]{"source"});
            ((BasedataEdit)context.getView().getControl("source")).setMustInput(false);
        } else {
            ((BasedataEdit)context.getView().getControl("source")).setMustInput(true);
        }
    }

    @Override
    public void setSurplusFieldVisibleList(BeforeCreateListColumnsArgs args) {
        Set<String> fieldNameSet = PdsParameterUtils.getSurplusFieldSet();
        List columnList = args.getListColumns();
        Iterator it = columnList.iterator();
        while (it.hasNext()) {
            String key;
            String[] fields = ((IListColumn)it.next()).toString().split("\\.");
            switch (key = fields[0]) {
                case "org": {
                    if (fieldNameSet.contains("org")) break;
                    break;
                }
                case "feeitem": {
                    if (fieldNameSet.contains("feeitem")) break;
                    it.remove();
                    break;
                }
                case "source": {
                    if (fieldNameSet.contains("source")) break;
                    it.remove();
                    break;
                }
            }
        }
    }

    @Override
    public void createSurplusEntryEntity(FeeManageContext context) {
        String selectFields = "project,package,feeamount,presurplusamount,usesurplus,usedate,payamount,transferamount,transferdate,surplusamount,remark,remark,confirmopinion,rejectopinion,returnopinion,transferopinion,carryoveropinion";
        long surplusId = SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity());
        QFilter qfilters = new QFilter("surplusid", "=", (Object)surplusId).and(new QFilter("usesurplus", "!=", (Object)BigDecimal.ZERO).or("transferamount", "!=", (Object)BigDecimal.ZERO));
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_payment", (String)selectFields, (QFilter[])qfilters.toArray(), (String)"id");
        if (null == rows || rows.length == 0) {
            return;
        }
        List propertys = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)rows[0]);
        HashSet<String> specialSet = new HashSet<String>();
        specialSet.add("remark");
        specialSet.add("confirmopinion");
        specialSet.add("rejectopinion");
        specialSet.add("returnopinion");
        specialSet.add("transferopinion");
        specialSet.add("carryoveropinion");
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject row : rows) {
            StringBuilder sb = new StringBuilder();
            for (String property : propertys) {
                Object obj = row.get(property);
                try {
                    if (specialSet.contains(property)) {
                        if (StringUtils.isBlank((Object)obj)) continue;
                        sb = sb.append(obj).append(';');
                        continue;
                    }
                    if (obj instanceof DynamicObject) {
                        ts.set(property, ((DynamicObject)obj).getPkValue(), index);
                        continue;
                    }
                    if ("surplusamount".equals(property)) {
                        ts.set("cur" + property, obj, index);
                        continue;
                    }
                    ts.set(property, obj, index);
                }
                catch (Exception exception) {}
            }
            ts.set("remark", (Object)sb.toString(), index);
            ts.set("entryid", row.getPkValue(), index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    @Override
    public void openPaymentHandlePage(FeeManageContext context) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("entryid", context.getPaymentObj().getPkValue());
        paramMap.put("opkey", context.getOpkey());
        paramMap.put("feeway", context.getPaymentObj().get("feeway"));
        paramMap.put("amount", context.getPaymentObj().get("amount"));
        paramMap.put("payamount", context.getPaymentObj().get("payamount"));
        paramMap.put("paydate", context.getPaymentObj().get("paydate"));
        paramMap.put("suppliertype", context.getPaymentObj().get("suppliertype"));
        paramMap.put("supplier", context.getPaymentObj().get("supplier.id"));
        paramMap.put("currency", context.getPaymentObj().get("currency.id"));
        paramMap.put("entryid", context.getPaymentObj().get("id"));
        paramMap.put("usesurplus", context.getPaymentObj().get("usesurplus"));
        paramMap.put("feeamount", context.getPaymentObj().get("feeamount"));
        this.getAttachIds(context, paramMap, "voucher");
        this.getAttachIds(context, paramMap, "voucher2");
        context.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"src_paymenthandle", paramMap, null, (ShowType)ShowType.Modal));
    }

    public void getAttachIds(FeeManageContext context, Map<String, Object> paramMap, String attachField) {
        DynamicObjectCollection rows = context.getPaymentObj().getDynamicObjectCollection(attachField);
        if (null != rows && rows.size() > 0) {
            List attachIds = rows.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
            paramMap.put(attachField, attachIds);
        } else {
            paramMap.put(attachField, null);
        }
    }
}

