/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.feemanage.ISurplusEntryHelper;
import kd.scm.pds.common.util.PdsParameterUtils;

public class SurplusEntryHelper
implements ISurplusEntryHelper {
    @Override
    public long createSurplusEntry(FeeManageContext context) {
        Map<String, Object> surplusMap = FeeManageUtils.getSurplusFieldsValue(context);
        if (null == surplusMap || surplusMap.size() == 0) {
            return 0L;
        }
        String billid = (String)surplusMap.get("billid");
        QFilter qfilters = new QFilter("billid", "=", (Object)billid);
        DynamicObject surplusObj = QueryServiceHelper.queryOne((String)"src_feesurplus", (String)"id", (QFilter[])qfilters.toArray());
        if (null != surplusObj) {
            return surplusObj.getLong("id");
        }
        surplusObj = BusinessDataServiceHelper.newDynamicObject((String)"src_feesurplus");
        ORM.create().setPrimaryKey(surplusObj);
        if (Objects.nonNull(surplusObj)) {
            for (Map.Entry<String, Object> entry : surplusMap.entrySet()) {
                surplusObj.set(entry.getKey(), entry.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{surplusObj});
            return surplusObj.getLong("id");
        }
        return 0L;
    }

    @Override
    public long createSurplusEntryInit(FeeManageContext context) {
        Set<String> fieldNameSet = PdsParameterUtils.getSurplusFieldSet();
        String billId = FeeManageUtils.buildSurplusBillNo(context);
        if (billId == null || billId.trim().length() == 0) {
            return 0L;
        }
        QFilter qfilters = new QFilter("billid", "=", (Object)billId);
        DynamicObject surplusObj = BusinessDataServiceHelper.loadSingle((String)"src_feesurplus", (String)"id,createorg", (QFilter[])qfilters.toArray());
        if (null != surplusObj) {
            long createOrgId = (Long)context.getDataMap().get("createorg");
            if (surplusObj.getLong("createorg.id") != createOrgId) {
                surplusObj.set("createorg", (Object)createOrgId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{surplusObj});
            }
            return surplusObj.getLong("id");
        }
        surplusObj = BusinessDataServiceHelper.newDynamicObject((String)"src_feesurplus");
        ORM.create().setPrimaryKey(surplusObj);
        if (Objects.nonNull(surplusObj)) {
            surplusObj.set("billid", (Object)billId);
            surplusObj.set("surplustype", context.getDataMap().get("surplustype"));
            surplusObj.set("supplier", context.getDataMap().get("supplier"));
            surplusObj.set("currency", context.getDataMap().get("currency"));
            if (fieldNameSet.contains("org")) {
                surplusObj.set("org", context.getDataMap().get("org"));
            }
            if (fieldNameSet.contains("feeitem")) {
                surplusObj.set("feeitem", context.getDataMap().get("feeitem"));
            }
            if (fieldNameSet.contains("source")) {
                surplusObj.set("source", context.getDataMap().get("source"));
            }
            surplusObj.set("creator", (Object)RequestContext.get().getUserId());
            surplusObj.set("createtime", (Object)TimeServiceHelper.now());
            surplusObj.set("createorg", context.getDataMap().get("createorg"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{surplusObj});
            return surplusObj.getLong("id");
        }
        return 0L;
    }
}

