/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.feemanage.ISurplusStatusHelper;

public class SurplusStatusHelper
implements ISurplusStatusHelper {
    @Override
    public void updateSurplus(FeeManageContext context) {
        DynamicObject[] rows;
        if (null == context.getSurplusMap() || context.getSurplusMap().size() == 0) {
            return;
        }
        ArrayList ids = new ArrayList(16);
        context.getSurplusMap().forEach((key, value) -> ids.add(Long.valueOf(key)));
        QFilter qfilters = new QFilter("id", "in", ids);
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_feesurplus", (String)"surplusamount,issurplus", (QFilter[])qfilters.toArray())) {
            String key2 = row.getString("id");
            BigDecimal amount = context.getSurplusMap().get(key2);
            if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal surplusAmount = row.getBigDecimal("surplusamount").add(amount);
            row.set("surplusamount", (Object)surplusAmount);
            if (surplusAmount.compareTo(BigDecimal.ZERO) > 0) {
                row.set("issurplus", (Object)"1");
                continue;
            }
            row.set("issurplus", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])rows);
    }

    @Override
    public void transferSurplus(FeeManageContext context) {
        long surplusId = context.getPaymentObj().getLong("surplusid");
        if (surplusId == 0L) {
            return;
        }
        BigDecimal transferamount = context.getPaymentObj().getBigDecimal(context.getTransferField());
        if (transferamount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (context.isNegate()) {
            transferamount = transferamount.negate();
        }
        HashMap<String, BigDecimal> surplusMap = new HashMap<String, BigDecimal>(1);
        surplusMap.put(String.valueOf(surplusId), transferamount);
        context.setSurplusMap(surplusMap);
        this.updateSurplus(context);
        BigDecimal surplusAmont = FeeManageUtils.getSurplusAmount(surplusId);
        context.getPaymentObj().set("surplusamount", (Object)surplusAmont);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getPaymentObj()});
    }

    @Override
    public void updateSurplusTotal(FeeManageContext context) {
        DynamicObject[] rows;
        if (null == context.getSurplusMap() || context.getSurplusMap().size() == 0) {
            return;
        }
        ArrayList ids = new ArrayList(16);
        context.getSurplusMap().forEach((key, value) -> ids.add(Long.valueOf(key)));
        QFilter qfilters = new QFilter("id", "in", ids);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_feesurplus", (boolean)true);
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_feesurplus", (String)selectFields, (QFilter[])qfilters.toArray())) {
            String key2 = row.getString("id");
            BigDecimal amount = context.getSurplusMap().get(key2);
            if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal sumAmount = row.getBigDecimal(context.getTotalField()).add(amount);
            row.set(context.getTotalField(), (Object)sumAmount);
        }
        SaveServiceHelper.save((DynamicObject[])rows);
    }
}

