/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.ITenderStatusHelper;

public class TenderStatusHelper
implements ITenderStatusHelper {
    private static final long serialVersionUID = 1L;

    @Override
    public void updateTenderPayInfo(FeeManageContext context) {
        String selectFields;
        DynamicObject[] tenderObjs;
        String feeitem = context.getPaymentObj().getString("packfeeitem.id");
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getPaymentObj().getDynamicObject("project"));
        long packageId = SrmCommonUtil.getPkValue((DynamicObject)context.getPaymentObj().getDynamicObject("package"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)context.getPaymentObj().getDynamicObject("supplier"));
        String feeway = context.getPaymentObj().getString("feeway.number");
        BigDecimal payamount = context.getPaymentObj().getBigDecimal("payamount");
        BigDecimal usesurplus = context.getPaymentObj().getBigDecimal("usesurplus");
        int amtprecision = context.getPaymentObj().getInt("currency.amtprecision");
        String payStatus = context.getPaymentObj().getString("paystatus");
        QFilter qFilters = new QFilter("billid", "=", (Object)projectId).and("supplier.id", "=", (Object)supplierId);
        if ("C020703".equals(feeway)) {
            qFilters = qFilters.and("package.id", "=", (Object)packageId);
        }
        if ((tenderObjs = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)(selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)true)), (QFilter[])qFilters.toArray())) == null || tenderObjs.length == 0) {
            return;
        }
        for (DynamicObject tenderObj : tenderObjs) {
            if ("775219867547625472".equals(feeitem)) {
                tenderObj.set("ispaydocfee", (Object)Boolean.TRUE);
                tenderObj.set("docamount", (Object)payamount);
                continue;
            }
            if (PayStatusEnums.EXEMPT.getValue().equals(payStatus)) {
                tenderObj.set("isexempt", (Object)Boolean.TRUE);
            }
            tenderObj.set("ispayfee", (Object)Boolean.TRUE);
            tenderObj.set("feeamount", (Object)payamount);
            if (usesurplus.compareTo(BigDecimal.ZERO) <= 0) continue;
            tenderObj.set("note", (Object)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f7f\u7528\u4f59\u989d\uff1a%1$s", (String)"TenderStatusHelper_1", (String)"scm-pds-common", (Object[])new Object[0]), usesurplus.setScale(amtprecision)));
        }
        SaveServiceHelper.save((DynamicObject[])tenderObjs);
    }

    @Override
    public void updateTenderPayInfoBatch(FeeManageContext context) {
        QFilter qfilters = new QFilter("project.id", "=", (Object)context.getProjectId()).and("paystatus", "=", (Object)PayStatusEnums.EXEMPT.getValue());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_payment", (boolean)false);
        DynamicObject[] paymentObjs = BusinessDataServiceHelper.load((String)"src_payment", (String)selectFields, (QFilter[])qfilters.toArray());
        if (null == paymentObjs || paymentObjs.length == 0) {
            return;
        }
        for (DynamicObject paymentObj : paymentObjs) {
            context.setPaymentObj(paymentObj);
            this.updateTenderPayInfo(context);
        }
    }

    @Override
    public void clearTenderPayInfo(FeeManageContext context) {
        QFilter qfilters = new QFilter("billid", "=", (Object)context.getProjectId()).and("ispayfee", "=", (Object)Boolean.TRUE).and("isexempt", "=", (Object)Boolean.TRUE);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false);
        DynamicObject[] tenderObjs = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilters.toArray());
        if (null == tenderObjs || tenderObjs.length == 0) {
            return;
        }
        for (DynamicObject tenderObj : tenderObjs) {
            tenderObj.set("isexempt", (Object)Boolean.FALSE);
            tenderObj.set("ispayfee", (Object)Boolean.FALSE);
            tenderObj.set("feeamount", (Object)BigDecimal.ZERO);
            tenderObj.set("note", null);
        }
        SaveServiceHelper.save((DynamicObject[])tenderObjs);
    }
}

