/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage.statusStrategy;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.feemanage.FeeManageConfig;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public interface IPaymentStatusStrategy
extends Serializable {
    default public void handleContext(FeeManageContext context) {
        context.setSucced(false);
        if (context.getOpkey() == null) {
            String opkey = context.getDataMap().get("opkey").toString();
            context.setOpkey(opkey);
        }
        if (StringUtils.isBlank((CharSequence)context.getOpkey())) {
            return;
        }
        DynamicObject paymentObj = context.getPaymentObj();
        if (null == paymentObj) {
            long entryId = context.getEntryid();
            if (entryId == 0L) {
                entryId = PdsCommonUtils.object2Long(context.getDataMap().get("entryid"));
            }
            if (QueryServiceHelper.exists((String)"src_payment", (Object)entryId)) {
                paymentObj = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"src_payment");
            }
        }
        if (null == paymentObj) {
            return;
        }
        context.setPaymentObj(paymentObj);
        context.setSucced(true);
    }

    public void verifyPayStatus(FeeManageContext var1);

    default public void handleBaseInfo(FeeManageContext context) {
        String opKey = context.getOpkey();
        if ("submit".equals(opKey)) {
            return;
        }
        if ("exempt".equals(opKey)) {
            opKey = "confirm";
        }
        context.getPaymentObj().set(opKey + "user", context.getDataMap().get("cfm"));
        context.getPaymentObj().set(opKey + "date", context.getDataMap().get("cfmdate"));
        context.getPaymentObj().set(opKey + "opinion", context.getDataMap().get("cfmopinion"));
    }

    default public void handleAttachment(FeeManageContext context) {
        Object voucherObj = context.getDataMap().get("voucher2");
        if (null != voucherObj) {
            MultiBasedataUtils.setMultiBasedataForEntryRow(context.getPaymentObj(), (Set)voucherObj, "voucher2");
        }
    }

    public void handlePayStatus(FeeManageContext var1);

    default public void updatePayStatus(FeeManageContext context) {
        this.handleContext(context);
        this.verifyPayStatus(context);
        if (!context.isSucced()) {
            return;
        }
        this.handleBaseInfo(context);
        this.handleAttachment(context);
        this.handlePayStatus(context);
    }

    default public String getPayStatus(FeeManageContext context) {
        DynamicObject paymentObj = context.getPaymentObj();
        if (null == paymentObj) {
            long entryId = context.getEntryid();
            if (entryId == 0L) {
                entryId = this.getEntryIdByDataMap(context);
            }
            if (QueryServiceHelper.exists((String)"src_payment", (Object)entryId)) {
                paymentObj = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"src_payment");
                context.setPaymentObj(paymentObj);
            }
        }
        return paymentObj != null ? paymentObj.getString("paystatus") : null;
    }

    default public long getEntryIdByDataMap(FeeManageContext context) {
        long entryId = PdsCommonUtils.object2Long(context.getDataMap().get("entryid"));
        if (entryId > 0L) {
            return entryId;
        }
        long projectId = PdsCommonUtils.object2Long(context.getDataMap().get("projectid"));
        if (projectId == 0L) {
            return 0L;
        }
        context.setProjectId(projectId);
        FeeManageConfig configHandler = new FeeManageConfig();
        Map<String, Object> feeMap = configHandler.getFeeManageConfig(context);
        if (null == feeMap) {
            return 0L;
        }
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        if ("C020703".equals(PdsCommonUtils.object2String(feeMap.get("feeway"), "C020702"))) {
            long packageId = PdsCommonUtils.object2Long(context.getDataMap().get("packageid"));
            qfilters.and("package", "=", (Object)packageId);
        }
        String surplusType = PdsCommonUtils.object2String(context.getDataMap().get("surplustype"), "1");
        qfilters.and("surplustype", "=", (Object)surplusType);
        long supplierId = PdsCommonUtils.object2Long(context.getDataMap().get("supplierid"));
        qfilters.and("supplier", "=", (Object)supplierId);
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)context.getMessage())) {
            sb.append(context.getMessage()).append("\n");
        }
        sb.append(qfilters.toString());
        context.setMessage(sb.toString());
        DynamicObject paymentObj = QueryServiceHelper.queryOne((String)"src_payment", (String)"id", (QFilter[])qfilters.toArray());
        if (null == paymentObj) {
            return 0L;
        }
        return paymentObj.getLong("id");
    }
}

