/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.feemanage.statusStrategy;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.enums.PayStatusEnums;
import kd.scm.pds.common.feemanage.FeeManageContext;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.feemanage.statusStrategy.IPaymentStatusStrategy;

public class PaymentStatus_carryover
implements IPaymentStatusStrategy {
    @Override
    public void verifyPayStatus(FeeManageContext context) {
        context.setSucced(true);
        if (!PayStatusEnums.CONFIRMED.getValue().equals(this.getPayStatus(context))) {
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6536\u8d39\u72b6\u6001\u4e0d\u662f\u5df2\u6536\u6b3e|\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u8f6c\u5c65\u7ea6\u3002", (String)"PaymentStatus_carryover_0", (String)"scm-pds-common", (Object[])new Object[0]));
            context.setSucced(false);
        }
    }

    @Override
    public void handlePayStatus(FeeManageContext context) {
        this.handleSourcePayment(context);
        this.createTargetPayment(context);
    }

    public void handleSourcePayment(FeeManageContext context) {
        context.getPaymentObj().set("paystatus", (Object)PayStatusEnums.CARRYOVER.getValue());
        context.getPaymentObj().set("carryoveramount", context.getDataMap().get(context.getOpkey() + "amount"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getPaymentObj()});
        FeeManageUtils.updateSurplusTotal(context, "carryoveramount", "sumcarryover");
    }

    public void createTargetPayment(FeeManageContext context) {
        DynamicObject newPaymentObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)context.getPaymentObj(), (boolean)true, (boolean)true);
        ORM.create().setPrimaryKey(newPaymentObj);
        if (StringUtils.isBlank((Object)context.getDataMap().get("surplustype"))) {
            newPaymentObj.set("surplustype", (Object)"2");
        } else {
            newPaymentObj.set("surplustype", context.getDataMap().get("surplustype"));
        }
        long surplusId = FeeManageUtils.createSurplusEntry(newPaymentObj);
        newPaymentObj.set("surplusid", (Object)surplusId);
        newPaymentObj.set("remark", (Object)ResManager.loadKDString((String)"\u8f6c\u5c65\u7ea6\u4fdd\u8bc1\u91d1", (String)"PaymentStatus_carryover_1", (String)"scm-pds-common", (Object[])new Object[0]));
        newPaymentObj.set("transferuser_id", context.getDataMap().get("cfm"));
        newPaymentObj.set("transferdate", context.getDataMap().get("cfmdate"));
        newPaymentObj.set("transferopinion", context.getDataMap().get("cfmopinion"));
        newPaymentObj.set("transferamount", context.getDataMap().get(context.getOpkey() + "amount"));
        newPaymentObj.set("carryoveruser", null);
        newPaymentObj.set("carryoverdate", null);
        newPaymentObj.set("carryoveropinion", null);
        newPaymentObj.set("carryoveramount", (Object)0L);
        context.setPaymentObj(newPaymentObj);
        FeeManageUtils.transferSurplus(context, "transferamount", Boolean.FALSE);
        FeeManageUtils.updateSurplusTotal(context, "transferamount", "sumtransfer");
    }
}

