/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.RichTextEditor;
import kd.bos.logging.BizLog;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.constant.PdsMessageConstant;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;

public class PdsMessageUtils {
    public static String[] getBizTypes(DynamicObject billObj) {
        String srcBillType = PdsMessageUtils.getSrcBillType(billObj);
        String[] bizTypes = null;
        switch (srcBillType) {
            case "src_project": 
            case "src_bidpublish": {
                bizTypes = PdsMessageConstant.INVITE_TYPES();
                break;
            }
            case "src_decision": {
                bizTypes = PdsMessageUtils.getBizTypesBySupletterstype(billObj);
                if (bizTypes.length != 0) break;
                bizTypes = PdsMessageConstant.DECISION_TYPES();
                break;
            }
        }
        return bizTypes;
    }

    public static String[] getBizTypesBySupletterstype(DynamicObject billObj) {
        DynamicObjectCollection supplierRows = billObj.getDynamicObjectCollection("supplierentry");
        ArrayList<String> bizTypeList = new ArrayList<String>();
        if (supplierRows.size() == 0) {
            return bizTypeList.toArray(new String[0]);
        }
        List lettersTypes = supplierRows.stream().map(row -> row.getString("supletterstype")).distinct().collect(Collectors.toList());
        for (String lettersType : lettersTypes) {
            String bizType = PdsMessageConstant.LETTERTYPE_BIZTYPE_MAP().get(lettersType);
            if (null == bizType) continue;
            bizTypeList.add(bizType);
        }
        return bizTypeList.toArray(new String[0]);
    }

    public static void setTabVisiable(PdsMessageContext context) {
        String[] bizTypes = PdsMessageUtils.getBizTypes(context.getBillObj());
        if (null == bizTypes) {
            return;
        }
        HashSet<String> bizTypeSet = new HashSet<String>(Arrays.asList(bizTypes));
        IFormView view = context.getView();
        for (String bizType : PdsMessageConstant.BIZ_TYPES()) {
            if (bizTypeSet.contains(bizType)) {
                view.setVisible(Boolean.valueOf(true), new String[]{bizType + "tab"});
                continue;
            }
            view.setVisible(Boolean.valueOf(false), new String[]{bizType + "tab"});
        }
    }

    public static void hideAllTplControl(PdsMessageContext context) {
        for (String bizType : PdsMessageConstant.BIZ_TYPES()) {
            for (String tplType : PdsMessageConstant.TPL_TYPES()) {
                context.getView().setVisible(Boolean.valueOf(false), new String[]{bizType + tplType});
            }
        }
    }

    public static Map<String, String> getSendTypeBySrcBillType(PdsMessageContext context) {
        IDataModel model = context.getView().getModel();
        HashMap<String, String> sendTypeMap = new HashMap<String, String>();
        String[] bizTypes = PdsMessageUtils.getBizTypes(context.getBillObj());
        if (null == bizTypes) {
            return sendTypeMap;
        }
        block16: for (String bizType : bizTypes) {
            String sendType = model.getDataEntity().getString(bizType + "sendtype");
            if (sendType == null || sendType.equals("")) continue;
            switch (bizType) {
                case "win": {
                    sendTypeMap.put(PdsLettersTypeEnum.WIN.getVal(), sendType);
                    continue block16;
                }
                case "backup": {
                    sendTypeMap.put(PdsLettersTypeEnum.BACKUP.getVal(), sendType);
                    continue block16;
                }
                case "fail": {
                    sendTypeMap.put(PdsLettersTypeEnum.FAIL.getVal(), sendType);
                    continue block16;
                }
                case "invite": {
                    sendTypeMap.put(PdsLettersTypeEnum.INVITE.getVal(), sendType);
                    continue block16;
                }
                case "cultivate": {
                    sendTypeMap.put(PdsLettersTypeEnum.CULTIVATE.getVal(), sendType);
                    continue block16;
                }
                case "prewin": {
                    sendTypeMap.put(PdsLettersTypeEnum.PREWIN.getVal(), sendType);
                    continue block16;
                }
            }
        }
        return sendTypeMap;
    }

    public static void removeAllHisTabPage(PdsMessageContext context) {
        List<String> pageIds = PdsMessageUtils.getAllCachedPageIds(context);
        if (pageIds != null && pageIds.size() > 0) {
            for (String pageId : pageIds) {
                IFormView formView = context.getView().getView(pageId);
                if (formView == null) continue;
                formView.invokeOperation("close");
                HashMap<String, String> map = new HashMap<String, String>(0);
                map.put("pageid", pageId);
                ((IClientViewProxy)context.getView().getService(IClientViewProxy.class)).addAction("closeWindow", map);
            }
        }
        PdsMessageUtils.resetCachedPageIds(context);
    }

    public static List<String> getAllCachedPageIds(PdsMessageContext context) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String pageIdsObject = context.getView().getPageCache().get("docpageIds");
        if (pageIdsObject != null) {
            sb.append(pageIdsObject);
            String[] pageIds = sb.toString().split(";");
            for (int i = 0; i < pageIds.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)pageIds[i].trim())) continue;
                list.add(pageIds[i].trim());
            }
        }
        return list;
    }

    public static void resetCachedPageIds(PdsMessageContext context) {
        context.getView().getPageCache().put("docpageIds", "");
    }

    public static void getVieRule(PdsMessageContext context) {
        DynamicObject projectObj = context.getView().getModel().getDataEntity().getDynamicObject("project");
        DynamicObject vieRuleObj = context.getVieRuleObj();
        if (null == vieRuleObj) {
            vieRuleObj = BusinessDataServiceHelper.loadSingle((Object)projectObj.getPkValue(), (String)"src_vie_rule");
        }
        context.setVieRuleObj(vieRuleObj);
    }

    public static void getCopyPeopleEmail(PdsMessageContext context) {
        String copyPeopleEmails = context.getCopyPeopleEmails();
        if (null != copyPeopleEmails) {
            return;
        }
        String email = "";
        DynamicObjectCollection cols = context.getView().getModel().getDataEntity().getDynamicObjectCollection("copypeople");
        if (null != cols) {
            List<String> emails = cols.stream().map(col -> col.getDynamicObject("fbasedataid").getString("email")).collect(Collectors.toList());
            copyPeopleEmails = email = StringUtils.join((Object[])emails.toArray(new String[0]), (String)";");
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u83b7\u53d6\u6284\u9001\u4eba\u5458\u90ae\u7bb1\u6210\u529f\u3002", (String)"PdsMessageUtils_0", (String)"scm-pds-common", (Object[])new Object[0]));
        context.setCopyPeopleEmails(copyPeopleEmails);
    }

    public static String openContentPage(PdsMessageContext context, String title, Map<String, Object> params, int i) {
        IFormView view = context.getView();
        String tabpage = "tabpageap" + i;
        view.setVisible(Boolean.TRUE, new String[]{tabpage});
        TabPage page = (TabPage)context.getView().getControl(tabpage);
        if (null == page) {
            return null;
        }
        page.setText(new LocaleString(title));
        FormShowParameter lsp = new FormShowParameter();
        String billStatus = PdsCommonUtils.object2String(context.getBillObj().getString("billstatus"), BillStatusEnum.SAVE.getVal());
        if (billStatus.equals(BillStatusEnum.SAVE.getVal())) {
            lsp.setStatus(OperationStatus.EDIT);
        } else {
            lsp.setStatus(OperationStatus.VIEW);
        }
        lsp.setFormId("pds_noticecontent");
        lsp.setCustomParams(params);
        lsp.setCaption(title);
        lsp.getOpenStyle().setTargetKey(tabpage);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setParentFormId(view.getFormShowParameter().getFormId());
        view.showForm(lsp);
        PdsMessageUtils.addPageIdIntoCache(context, lsp.getPageId());
        return title + ":" + tabpage;
    }

    public static void addPageIdIntoCache(PdsMessageContext context, String pageId) {
        StringBuilder sb = new StringBuilder();
        String pageIds = context.getView().getPageCache().get("docpageIds");
        if (pageIds != null) {
            sb.append(pageIds);
        }
        sb.append(';');
        sb.append(pageId);
        context.getView().getPageCache().put("docpageIds", sb.toString());
    }

    public static void setNoticeContentSaveStatus(PdsMessageContext context) {
        List<String> pageIdList = PdsMessageUtils.getAllCachedPageIds(context);
        block0: for (String pageId : pageIdList) {
            IDataModel tabViewModel;
            IFormView tabView = context.getView().getView(pageId);
            if (tabView == null || null == (tabViewModel = tabView.getModel()) || !tabViewModel.isDataLoaded()) continue;
            Object supplierId = tabViewModel.getValue("supplierid");
            RichTextEditor doccontent = (RichTextEditor)tabView.getControl("portalcontent");
            String content = doccontent.getText();
            DynamicObjectCollection letterEntryCols = context.getView().getModel().getEntryEntity("lettersentry");
            for (DynamicObject col : letterEntryCols) {
                DynamicObject supplier = col.getDynamicObject("letterssupplier");
                if (null == supplier || !Objects.equals(supplierId, String.valueOf(supplier.getPkValue()))) continue;
                col.set("portalcontent", (Object)content);
                continue block0;
            }
        }
    }

    public static void updatePublisher(PdsMessageContext context) {
        DynamicObjectCollection supplierEntry = context.getView().getModel().getEntryEntity("supplierentry");
        DynamicObject publisher = context.getView().getModel().getDataEntity().getDynamicObject("publisher");
        for (DynamicObject supplier : supplierEntry) {
            supplier.set("purpublisher", (Object)publisher);
        }
        context.getView().updateView("supplierentry");
    }

    public static String isUpdate(PdsMessageContext context) {
        IPageCache cache = context.getView().getPageCache();
        String isupdate = cache.get("isupdate");
        if ("1".equals(isupdate)) {
            return isupdate;
        }
        DynamicObjectCollection rows = context.getView().getModel().getEntryEntity("lettersentry");
        if (null == rows || rows.size() == 0) {
            return "1";
        }
        if (null == ((DynamicObject)rows.get(0)).get("portalcontent") || StringUtils.isBlank((Object)((DynamicObject)rows.get(0)).get("portalcontent"))) {
            return "1";
        }
        return isupdate;
    }

    public static String getSrcBillType(PdsMessageContext context) {
        String srcBillType = PdsCommonUtils.object2String(PdsCommonUtils.getCustomParamValue(context.getView(), "srcbilltype"), "");
        if (!StringUtils.isBlank((CharSequence)srcBillType)) {
            return srcBillType;
        }
        DynamicObject billObj = context.getView().getModel().getDataEntity(true);
        if ("src_notifycomp".equals(context.getView().getEntityId())) {
            long projectId = context.getView().getParentView().getModel().getDataEntity().getLong("id");
            String pentityKey = context.getView().getParentView().getEntityId();
            if (projectId > 0L && !StringUtils.isBlank((CharSequence)pentityKey)) {
                DynamicObject currentNode = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)pentityKey);
                return PdsMessageUtils.getSrcBillTypeByCurrntNode(currentNode);
            }
            return "src_project";
        }
        return PdsMessageUtils.getSrcBillType(billObj);
    }

    public static String getSrcBillType(DynamicObject billObj) {
        String srcBillType = billObj.getString("srcbilltype");
        if (!StringUtils.isBlank((CharSequence)srcBillType)) {
            return srcBillType;
        }
        DynamicObject currentNode = billObj;
        if ("src_notifycomp".equals(billObj.getDataEntityType().getName())) {
            long projectId = billObj.getLong("project.id");
            String pentityKey = billObj.getString("pentitykey");
            if (projectId > 0L && !StringUtils.isBlank((CharSequence)pentityKey)) {
                currentNode = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)pentityKey);
                return PdsMessageUtils.getSrcBillTypeByCurrntNode(currentNode);
            }
            return "src_project";
        }
        return PdsMessageUtils.getSrcBillTypeByCurrntNode(currentNode);
    }

    public static String getSrcBillTypeByCurrntNode(DynamicObject currentNode) {
        String srcBillType = null;
        if ("pds_noticesupplier".equals(currentNode.getDataEntityType().getName())) {
            long projectId = currentNode.getLong("project.id");
            if (projectId == 0L) {
                return "src_project";
            }
            currentNode = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        }
        String preNodeNo = PdsFlowConfigUtils.getCurrPreviousNodeNo(currentNode);
        srcBillType = PdsBizNodeEnums.PROJECT.getValue().equals(preNodeNo) ? "src_project" : (PdsBizNodeEnums.BIDPUBLISH.getValue().equals(preNodeNo) ? "src_bidpublish" : (PdsBizNodeEnums.DECISION.getValue().equals(preNodeNo) ? "src_decision" : (BidOpenStatusEnums.NOOPEN.getValue().equals(currentNode.getString("openstatus")) ? (PdsFlowConfigUtils.existsSpecificNode(currentNode, PdsBizNodeEnums.BIDPUBLISH.getValue()) ? "src_bidpublish" : "src_project") : "src_decision")));
        return srcBillType;
    }
}

