/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.handle;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.message.IPdsMessageHandle;
import kd.scm.pds.common.message.PdsMessageContext;

public class PdsMessageBuildTreeData
implements IPdsMessageHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.buildTreeData(context);
    }

    protected void buildTreeData(PdsMessageContext context) {
        Map<String, List<String>> lettersType_pageIdList = context.getLettersType_pageIdList();
        TreeView tv = (TreeView)context.getView().getControl("treeviewap");
        tv.deleteAllNodes();
        TreeNode focusNode = null;
        for (Map.Entry<String, List<String>> pageIdEntry : lettersType_pageIdList.entrySet()) {
            String lettersType = pageIdEntry.getKey();
            String rootName = "";
            String rootKey = null;
            PdsLettersTypeEnum lettersTypeEnum = PdsLettersTypeEnum.fromVal(lettersType);
            switch (lettersTypeEnum) {
                case WIN: {
                    rootName = ResManager.loadKDString((String)"\u4e2d\u6807\u4f9b\u5e94\u5546", (String)"PdsMessageBuildTreeData_0", (String)"scm-pds-common", (Object[])new Object[0]);
                    rootKey = "winSup";
                    break;
                }
                case BACKUP: {
                    rootName = ResManager.loadKDString((String)"\u5907\u9009\u4f9b\u5e94\u5546", (String)"PdsMessageBuildTreeData_1", (String)"scm-pds-common", (Object[])new Object[0]);
                    rootKey = "backupSup";
                    break;
                }
                case FAIL: {
                    rootName = ResManager.loadKDString((String)"\u843d\u9009\u4f9b\u5e94\u5546", (String)"PdsMessageBuildTreeData_2", (String)"scm-pds-common", (Object[])new Object[0]);
                    rootKey = "failSup";
                    break;
                }
                case INVITE: {
                    rootName = ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u4f9b\u5e94\u5546", (String)"PdsMessageBuildTreeData_3", (String)"scm-pds-common", (Object[])new Object[0]);
                    rootKey = "inviteSup";
                    break;
                }
                case CULTIVATE: {
                    rootName = ResManager.loadKDString((String)"\u57f9\u517b\u4f9b\u5e94\u5546", (String)"PdsMessageBuildTreeData_4", (String)"scm-pds-common", (Object[])new Object[0]);
                    rootKey = "cultivateSup";
                    break;
                }
                case PREWIN: {
                    rootName = ResManager.loadKDString((String)"\u9884\u4e2d\u6807\u4f9b\u5e94\u5546", (String)"PdsMessageBuildTreeData_5", (String)"scm-pds-common", (Object[])new Object[0]);
                    rootKey = "prewinSup";
                    break;
                }
            }
            TreeNode supNode = new TreeNode(null, rootKey, rootName, true);
            supNode.setIsOpened(true);
            for (String pageId : pageIdEntry.getValue()) {
                String[] titleAndPageId = pageId.split(":");
                TreeNode node = new TreeNode(supNode.getId(), titleAndPageId[1], titleAndPageId[0], false);
                supNode.addChild(node);
                if (null != focusNode) continue;
                focusNode = node;
            }
            tv.addNode(supNode);
        }
        if (null != focusNode) {
            tv.focusNode(focusNode);
        }
    }
}

