/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.handle;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.message.IPdsMessageHandle;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageUtils;

public class PdsMessageRebuidContent
implements IPdsMessageHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.rebuidContent(context);
    }

    private void rebuidContent(PdsMessageContext context) {
        IDataModel model = context.getView().getModel();
        Map<String, Object> paramMap = context.getParamMap();
        String rebuidContent = context.getRebuidContent();
        DynamicObject supplierObj = context.getSupplierObj();
        DynamicObject publisher = model.getDataEntity().getDynamicObject("publisher");
        String publisherName = "";
        String publisherphone = "";
        if (null != publisher) {
            publisherName = publisher.getString("name");
            publisherphone = publisher.getString("phone");
        }
        DynamicObject project = model.getDataEntity().getDynamicObject("project");
        String stopbiddate = "";
        String opendate = ResManager.loadKDString((String)"\u65e0", (String)"PdsMessageRebuidContent_0", (String)"scm-pds-common", (Object[])new Object[0]);
        if (null != project) {
            DynamicObject sourceType = project.getDynamicObject("sourcetype");
            String sourceTypeNumber = sourceType.getString("number");
            Date stopBidDate = null;
            Date openDate = null;
            DynamicObject data = project;
            if (SourceTypeEnums.VIE.getValue().equals(sourceTypeNumber) || SourceTypeEnums.ELECTRONIC_AUCTION.getValue().equals(sourceTypeNumber)) {
                PdsMessageUtils.getVieRule(context);
                data = context.getVieRuleObj();
            }
            stopBidDate = data.getDate("stopbiddate");
            openDate = data.getDate("opendate");
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (null != stopBidDate) {
                stopbiddate = sf.format(stopBidDate);
            }
            if (openDate != null) {
                opendate = sf.format(openDate);
            }
        }
        int size = paramMap.size();
        String supplierName = supplierObj.getString("name");
        if (null != supplierName) {
            rebuidContent = rebuidContent.replace("{supplier}", supplierName);
            HashMap<String, String> supMap = new HashMap<String, String>(1);
            supMap.put("supplier", supplierName);
            paramMap.put(String.valueOf(size++), supMap);
        }
        rebuidContent = rebuidContent.replace("{publisherphone}", publisherphone);
        HashMap<String, String> phoneMap = new HashMap<String, String>(1);
        phoneMap.put("publisherphone", publisherphone);
        paramMap.put(String.valueOf(size++), phoneMap);
        rebuidContent = rebuidContent.replace("{publisher}", publisherName);
        HashMap<String, String> publisherMap = new HashMap<String, String>(1);
        publisherMap.put("publisher", publisherName);
        paramMap.put(String.valueOf(size++), publisherMap);
        rebuidContent = rebuidContent.replace("{stopbiddate}", stopbiddate);
        HashMap<String, String> stopDateMap = new HashMap<String, String>(1);
        stopDateMap.put("stopbiddate", stopbiddate);
        paramMap.put(String.valueOf(size++), stopDateMap);
        rebuidContent = rebuidContent.replace("{opendate}", opendate);
        HashMap<String, String> openDateMap = new HashMap<String, String>(1);
        openDateMap.put("opendate", opendate);
        paramMap.put(String.valueOf(size++), openDateMap);
        context.setRebuidContent(rebuidContent);
    }
}

