/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.handle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.pds.common.constant.PdsMessageConstant;
import kd.scm.pds.common.message.IPdsMessageHandle;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageUtils;
import kd.scm.pds.common.util.PdsDocTplUtil;

public class PdsMessageSetTplValue
implements IPdsMessageHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.setTplDefaultVal(context);
    }

    protected void setTplDefaultVal(PdsMessageContext context) {
        String bizType = context.getBizType();
        String sendType = context.getSendType();
        sendType = this.setDefaultSendType(context, bizType, sendType);
        boolean isSRM = false;
        boolean isEmail = false;
        boolean isMessage = false;
        boolean isYzj = false;
        boolean isWeixin = false;
        if (sendType.contains("portal")) {
            isSRM = true;
        }
        if (sendType.contains("email")) {
            isEmail = true;
        }
        if (sendType.contains("message")) {
            isMessage = true;
        }
        if (sendType.contains("yzj")) {
            isYzj = true;
        }
        if (sendType.contains("weixin")) {
            isWeixin = true;
        }
        if (!(isSRM || isEmail || isMessage || isYzj || isWeixin)) {
            isSRM = true;
        }
        ArrayList<String> hideKey = new ArrayList<String>();
        ArrayList<String> visibleKey = new ArrayList<String>();
        if (isSRM) {
            visibleKey.add("portaltpl");
        } else {
            hideKey.add("portaltpl");
        }
        if (isEmail) {
            visibleKey.add("emailtpl");
        } else {
            hideKey.add("emailtpl");
        }
        if (isMessage) {
            visibleKey.add("messagetpl");
        } else {
            hideKey.add("messagetpl");
        }
        if (isYzj) {
            visibleKey.add("yzjtpl");
        } else {
            hideKey.add("yzjtpl");
        }
        if (isWeixin) {
            visibleKey.add("weixintpl");
        } else {
            hideKey.add("weixintpl");
        }
        this.setDefaultTplValue(context, bizType, hideKey, visibleKey);
    }

    protected String setDefaultSendType(PdsMessageContext context, String bizType, String sendType) {
        IDataModel model = context.getView().getModel();
        if (!sendType.contains("portal")) {
            String sendTypeVal = sendType.replaceAll(",", "");
            sendType = sendType.length() != 0 && sendTypeVal.trim().length() > 0 ? ",portal," + sendType : ",portal,";
            model.beginInit();
            model.setValue(bizType + "sendtype", (Object)sendType);
            model.endInit();
        }
        return sendType;
    }

    protected void setDefaultTplValue(PdsMessageContext context, String bizType, List<String> hideKey, List<String> visibleKey) {
        IDataModel model = context.getView().getModel();
        String letterType = PdsMessageConstant.BIZTYPE_LETTERTYPE_MAP().get(bizType);
        String billType = PdsMessageUtils.getSrcBillType(model.getDataEntity());
        HashSet<String> updateViewTpkKeySet = new HashSet<String>(8);
        model.beginInit();
        for (String tplKey : visibleKey) {
            DynamicObject tpl;
            String sendTypeNumber = "";
            if ("portaltpl".equals(tplKey)) {
                sendTypeNumber = "C020301";
            } else if ("emailtpl".equals(tplKey)) {
                sendTypeNumber = "C020302";
            } else if ("messagetpl".equals(tplKey)) {
                sendTypeNumber = "C020303";
            } else if ("yzjtpl".equals(tplKey)) {
                sendTypeNumber = "C020304";
            } else if ("weixintpl".equals(tplKey)) {
                sendTypeNumber = "C020305";
            }
            if (null == (tpl = PdsDocTplUtil.getDocTpl(context, billType, sendTypeNumber, letterType))) continue;
            model.setValue(bizType + tplKey, tpl.getPkValue());
            updateViewTpkKeySet.add(bizType + tplKey);
        }
        model.endInit();
        for (String updateKey : updateViewTpkKeySet) {
            context.getView().updateView(updateKey);
        }
        for (String tplKey : hideKey) {
            model.setValue(bizType + tplKey, (Object)0L);
        }
    }
}

