/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.message.IPdsMessageHandle;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageFacade;
import kd.scm.pds.common.message.PdsMessageUtils;

public class PdsMessageShowDocContent
implements IPdsMessageHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.showDocContent(context);
    }

    private void showDocContent(PdsMessageContext context) {
        Map<String, String> sendTypeMap = PdsMessageUtils.getSendTypeBySrcBillType(context);
        if (sendTypeMap.size() == 0) {
            context.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u9001\u65b9\u5f0f\u3002", (String)"PdsMessageShowDocContent_0", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry<String, String> sendTypeMapEntry : sendTypeMap.entrySet()) {
            if (PdsMessageFacade.verifySendTypeTpl(context, sendTypeMapEntry.getKey(), sendTypeMapEntry.getValue())) continue;
            return;
        }
        PdsMessageUtils.removeAllHisTabPage(context);
        HashSet<Long> supplierIdsSet = new HashSet<Long>();
        PdsMessageFacade.getLettersSupMap(context);
        Map<Long, Map<String, Object>> lettersSupMap = context.getLettersSupMap();
        DynamicObjectCollection lettersEntry = context.getView().getModel().getEntryEntity("lettersentry");
        HashMap<String, List<String>> lettersType_pageIdList = new HashMap<String, List<String>>(16);
        Map<Object, List<DynamicObject>> lettersType_objMap = lettersEntry.stream().collect(Collectors.groupingBy(row -> row.getString("letterstype")));
        String titleAndPageId = null;
        for (Map.Entry<String, String> sendTypeMapEntry : sendTypeMap.entrySet()) {
            List<DynamicObject> supObjList = lettersType_objMap.get(sendTypeMapEntry.getKey());
            if (null == supObjList) continue;
            String sendType = sendTypeMapEntry.getValue();
            PdsMessageFacade.updateLettersSupMap(context, lettersSupMap, sendTypeMapEntry.getKey(), sendType);
            Map<Object, Object> params = new HashMap(16);
            ArrayList<String> supList = new ArrayList<String>(16);
            for (DynamicObject row2 : supObjList) {
                long supId;
                DynamicObject supplier = row2.getDynamicObject("letterssupplier");
                if (supplier == null || !supplierIdsSet.add(supId = supplier.getLong("id"))) continue;
                params = lettersSupMap.get(supId);
                params.put("supplierid", supId);
                params.put("sendtype", sendType);
                String supName = supplier.getString("name");
                supList.add(supName + ":" + supId);
                if (null != titleAndPageId) continue;
                titleAndPageId = PdsMessageUtils.openContentPage(context, supName, params, 1);
            }
            lettersType_pageIdList.put(sendTypeMapEntry.getKey(), supList);
        }
        PdsMessageFacade.setLettersEntryValue(context, lettersSupMap);
        PdsMessageFacade.buildTreeData(context, lettersType_pageIdList);
    }
}

