/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.initbase;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.message.IPdsMessageInitBase;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public class PdsMessageInitBaseInfo
implements IPdsMessageInitBase {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.initBaseInfo(context);
    }

    public void initBaseInfo(PdsMessageContext context) {
        Map params = context.getView().getFormShowParameter().getCustomParams();
        IDataModel model = context.getView().getModel();
        Object srcBillId = params.get("srcbillid");
        if (null == srcBillId) {
            IFormView parentView = context.getView().getParentView();
            if (null == parentView) {
                return;
            }
            srcBillId = parentView.getModel().getDataEntity().getPkValue();
        }
        model.setValue("srcbillid", srcBillId);
        model.setValue("project", srcBillId);
        Object srcBillType = params.get("srcbilltype");
        if (StringUtils.isBlank(srcBillType)) {
            srcBillType = PdsMessageUtils.getSrcBillType(context);
        }
        model.setValue("srcbilltype", srcBillType);
        String billStatus = model.getDataEntity().getString("billstatus");
        if (null == billStatus || billStatus.trim().length() == 0) {
            model.setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        }
        if (model.getDataEntity().getDate("replydate") == null) {
            if (params.get("letterstype") == null || params.get("letterstype").equals("")) {
                model.setValue("replydate", (Object)model.getDataEntity().getDate("project.stopbiddate"));
            } else {
                model.setValue("replydate", (Object)SrcDateUtils.getDateByOffsetDay(TimeServiceHelper.now(), 7));
            }
        }
    }
}

