/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.initpage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.pds.common.message.IPdsMessageInitPage;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageFacade;
import kd.scm.pds.common.message.PdsMessageUtils;

public class PdsMessageInitPage
implements IPdsMessageInitPage {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.initPage(context);
    }

    private void initPage(PdsMessageContext context) {
        String isupdate = PdsMessageUtils.isUpdate(context);
        String isNew = (String)context.getView().getFormShowParameter().getCustomParam("noticesupplier_isnew");
        DynamicObject data = context.getView().getModel().getDataEntity();
        if (null != data && 0L != data.getLong("id")) {
            isNew = null;
        }
        if (null == isNew && !"1".equals(isupdate)) {
            this.showLettersSupContent(context);
        } else {
            PdsMessageFacade.showDocContent(context);
        }
        if (!this.isResendVisible(context)) {
            context.getView().setVisible(Boolean.valueOf(false), new String[]{"resend"});
        }
    }

    public boolean isResendVisible(PdsMessageContext context) {
        if (!"C".equals(context.getView().getModel().getDataEntity().getString("billstatus"))) {
            return false;
        }
        DynamicObjectCollection rows = context.getView().getModel().getDataEntity().getDynamicObjectCollection("supplierentry");
        if (rows.size() == 0) {
            return false;
        }
        return rows.stream().anyMatch(e -> "A".equals(e.getString("entrystatus")));
    }

    private void showLettersSupContent(PdsMessageContext context) {
        HashSet<Long> supplierIdsSet = new HashSet<Long>();
        DynamicObjectCollection lettersEntry = context.getView().getModel().getEntryEntity("lettersentry");
        HashMap<String, List<String>> lettersType_pageIdList = new HashMap<String, List<String>>(16);
        Map<Object, List<DynamicObject>> lettersType_objMap = lettersEntry.stream().collect(Collectors.groupingBy(row -> row.getString("letterstype")));
        String titleAndPageId = null;
        Map<String, String> sendTypeMap = PdsMessageUtils.getSendTypeBySrcBillType(context);
        for (Map.Entry<String, String> sendTypeMapEntry : sendTypeMap.entrySet()) {
            List<DynamicObject> supObjList = lettersType_objMap.get(sendTypeMapEntry.getKey());
            if (null == supObjList) continue;
            String sendType = sendTypeMapEntry.getValue();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("sendtype", sendType);
            String[] types = sendType.split(",");
            ArrayList<String> supList = new ArrayList<String>(16);
            for (DynamicObject row2 : supObjList) {
                long supId;
                PdsMessageFacade.setParamMap(context, params, types, row2);
                DynamicObject supplier = row2.getDynamicObject("letterssupplier");
                if (null == supplier || !supplierIdsSet.add(supId = supplier.getLong("id"))) continue;
                params.put("supplierid", supId);
                String supName = supplier.getString("name");
                supList.add(supName + ":" + supId);
                if (null != titleAndPageId) continue;
                titleAndPageId = PdsMessageUtils.openContentPage(context, supName, params, 1);
            }
            lettersType_pageIdList.put(sendTypeMapEntry.getKey(), supList);
        }
        PdsMessageFacade.buildTreeData(context, lettersType_pageIdList);
    }
}

