/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.initpage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.message.IPdsMessageInitPage;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageUtils;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import org.apache.commons.lang3.StringUtils;

public class PdsMessageInitSupplier
implements IPdsMessageInitPage {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.initSupplier(context);
    }

    private void initSupplier(PdsMessageContext context) {
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        String billStatus = model.getDataEntity().getString("billstatus");
        if (BillStatusEnum.SUBMIT.getVal().equals(billStatus) || BillStatusEnum.AUDIT.getVal().equals(billStatus)) {
            return;
        }
        DynamicObjectCollection rows = model.getEntryEntity("supplierentry");
        context.setSupplierIdsSet(new HashSet<Object>(rows.stream().collect(Collectors.groupingBy(col -> col.getDynamicObject("supplier").getPkValue())).keySet()));
        Map<String, List<DynamicObject>> lettersType_supObjMap = this.getSupGroupDataMap(context);
        this.delCantSendSupEntry(context);
        IPageCache cache = context.getView().getPageCache();
        cache.put("isupdate", "0");
        for (Map.Entry<String, List<DynamicObject>> lettersType_supObjEntry : lettersType_supObjMap.entrySet()) {
            this.updateSendSupEntry(context, lettersType_supObjEntry.getValue(), lettersType_supObjEntry.getKey());
        }
        for (Map.Entry<String, List<DynamicObject>> lettersType_supObjEntry : lettersType_supObjMap.entrySet()) {
            this.setSupplierData(context, lettersType_supObjEntry.getValue(), lettersType_supObjEntry.getKey());
        }
        context.getView().updateView("supplierentry");
    }

    protected Map<String, List<DynamicObject>> getSupGroupDataMap(PdsMessageContext context) {
        IDataModel model = context.getView().getModel();
        String srcBillId = model.getDataEntity().getString("srcbillid");
        Map<String, List<DynamicObject>> lettersType_supObjMap = new HashMap<String, List<DynamicObject>>();
        if (null == srcBillId) {
            return lettersType_supObjMap;
        }
        String billType = PdsMessageUtils.getSrcBillType(model.getDataEntity());
        lettersType_supObjMap = this.getSupDataBySrcBill(context, srcBillId, billType);
        return lettersType_supObjMap;
    }

    protected Map<String, List<DynamicObject>> getSupDataBySrcBill(PdsMessageContext context, String srcBillId, String billType) {
        Map<String, List<DynamicObject>> lettersType_supObjMap = new HashMap<String, List<DynamicObject>>();
        if ("src_decision".equals(billType)) {
            DynamicObjectCollection rows;
            QFilter filter = new QFilter("project", "=", (Object)Long.parseLong(srcBillId));
            filter.and("entrystatus", "=", (Object)"C");
            filter.and("result", "!=", (Object)" ");
            String selectFiled = "result,suppliertype,supplier";
            DynamicObjectCollection supplierEntryColl = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFiled, (QFilter[])new QFilter[]{filter}, (String)"result");
            for (DynamicObject obj : supplierEntryColl) {
                String result = obj.getString("result");
                if (!result.equals(PdsLettersTypeEnum.UNKNOW.getVal()) && !result.equals(PdsLettersTypeEnum.NOTRECOMMEND.getVal()) && !result.equals("7")) continue;
                obj.set("result", (Object)PdsLettersTypeEnum.FAIL.getVal());
            }
            String letterType = PdsCommonUtils.object2String(PdsCommonUtils.getCustomParamValue(context.getView(), "letterstype"), "");
            if (StringUtils.isBlank((CharSequence)letterType) && null != (rows = context.getView().getModel().getEntryEntity("supplierentry")) && rows.size() > 0) {
                letterType = ((DynamicObject)rows.get(0)).getString("supletterstype");
            }
            if (PdsLettersTypeEnum.PREWIN.getVal().equals(letterType)) {
                context.setAllSupplierIdsSet(supplierEntryColl.stream().filter(row -> PdsLettersTypeEnum.WIN.getVal().equals(row.getString("result"))).collect(Collectors.groupingBy(col -> col.get("supplier"))).keySet());
                lettersType_supObjMap = supplierEntryColl.stream().filter(row -> PdsLettersTypeEnum.WIN.getVal().equals(row.getString("result"))).collect(Collectors.groupingBy(row -> PdsLettersTypeEnum.PREWIN.getVal()));
            } else {
                context.setAllSupplierIdsSet(supplierEntryColl.stream().collect(Collectors.groupingBy(col -> col.get("supplier"))).keySet());
                lettersType_supObjMap = supplierEntryColl.stream().collect(Collectors.groupingBy(row -> row.getString("result")));
            }
            LinkedHashMap<String, List<DynamicObject>> newLettersType_supObjMap = new LinkedHashMap<String, List<DynamicObject>>();
            newLettersType_supObjMap.putAll(lettersType_supObjMap);
            if (null != lettersType_supObjMap.get(PdsLettersTypeEnum.FAIL.getVal())) {
                newLettersType_supObjMap.remove(PdsLettersTypeEnum.FAIL.getVal());
                newLettersType_supObjMap.put(PdsLettersTypeEnum.FAIL.getVal(), lettersType_supObjMap.get(PdsLettersTypeEnum.FAIL.getVal()));
                return newLettersType_supObjMap;
            }
        } else if ("src_project".equals(billType)) {
            String selectFiled = "entrysupplier.suppliertype,entrysupplier.supplier,isinvite,entrysupplier.isaptitude";
            QFilter filter = TemplateUtil.getComponentQfilter(srcBillId, "src_supplier_invite");
            DynamicObject supplierCompData = BusinessDataServiceHelper.loadSingle((String)"src_supplier_invite", (String)selectFiled, (QFilter[])new QFilter[]{filter});
            if (supplierCompData == null) {
                return lettersType_supObjMap;
            }
            DynamicObjectCollection supplierEntryColl = supplierCompData.getDynamicObjectCollection("entrysupplier");
            if (supplierEntryColl.size() == 0) {
                context.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u56de\u6807\u8be6\u60c5\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u901a\u77e5\u4f9b\u5e94\u5546\u3002", (String)"PdsMessageInitSupplier_0", (String)"scm-pds-common", (Object[])new Object[0]));
                return lettersType_supObjMap;
            }
            context.setAllSupplierIdsSet(supplierEntryColl.stream().filter(e -> !"2".equals(e.getString("isaptitude"))).collect(Collectors.groupingBy(col -> col.getDynamicObject("supplier").getPkValue())).keySet());
            lettersType_supObjMap = supplierEntryColl.stream().filter(col -> col.getBoolean("isinvite")).collect(Collectors.groupingBy(row -> PdsLettersTypeEnum.INVITE.getVal()));
        } else if ("src_bidpublish".equals(billType)) {
            String selectFiled = "suppliertype,supplier,isinvite,isaptitude";
            QFilter filter = new QFilter("entryparentid", "=", (Object)srcBillId);
            filter.or("billid", "=", (Object)Long.parseLong(srcBillId));
            DynamicObject[] supplierCompDatas = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFiled, (QFilter[])new QFilter[]{filter});
            if (supplierCompDatas == null || supplierCompDatas.length == 0) {
                context.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u56de\u6807\u8be6\u60c5\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u901a\u77e5\u4f9b\u5e94\u5546\u3002", (String)"PdsMessageInitSupplier_0", (String)"scm-pds-common", (Object[])new Object[0]));
                return lettersType_supObjMap;
            }
            context.setAllSupplierIdsSet(Arrays.asList(supplierCompDatas).stream().collect(Collectors.groupingBy(col -> col.getDynamicObject("supplier").getPkValue())).keySet());
            lettersType_supObjMap = Arrays.asList(supplierCompDatas).stream().filter(e -> !"2".equals(e.getString("isaptitude"))).collect(Collectors.groupingBy(row -> PdsLettersTypeEnum.INVITE.getVal()));
        }
        return lettersType_supObjMap;
    }

    private void updateSendSupEntry(PdsMessageContext context, List<DynamicObject> supDataList, String lettersType) {
        IDataModel model = context.getView().getModel();
        DynamicObjectCollection entrycols = model.getDataEntity().getDynamicObjectCollection("supplierentry");
        if (entrycols == null || entrycols.size() == 0) {
            return;
        }
        DynamicObjectCollection lettercols = model.getDataEntity().getDynamicObjectCollection("lettersentry");
        boolean isUpdate = false;
        block0: for (DynamicObject supplierEntry : supDataList) {
            supplierEntry.get("suppliertype");
            Object entrySupplier = supplierEntry.get("supplier");
            Object entrySupplierId = null;
            entrySupplierId = entrySupplier instanceof DynamicObject ? ((DynamicObject)entrySupplier).get("id") : entrySupplier;
            if (!context.getUpdateSupplierIdsSet().add(entrySupplierId)) continue;
            for (DynamicObject entry : entrycols) {
                Object docsupplier = entry.get("supplier.id");
                Object doclettersType = entry.get("supletterstype");
                if (!docsupplier.equals(entrySupplierId) || lettersType.equals(doclettersType)) continue;
                entry.set("supletterstype", (Object)lettersType);
                isUpdate = true;
                break;
            }
            for (DynamicObject letterEntry : lettercols) {
                Object lettersupplier = letterEntry.get("letterssupplier.id");
                Object lelettersType = letterEntry.get("letterstype");
                if (!lettersupplier.equals(entrySupplierId) || lettersType.equals(lelettersType)) continue;
                letterEntry.set("letterstype", (Object)lettersType);
                isUpdate = true;
                continue block0;
            }
        }
        if (isUpdate) {
            IPageCache cache = context.getView().getPageCache();
            cache.put("isupdate", "1");
        }
    }

    private void setSupplierData(PdsMessageContext context, List<DynamicObject> supDataList, String lettersType) {
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        String srcBillId = model.getDataEntity().getString("srcbillid");
        TableValueSetter supEntryTs = new TableValueSetter(new String[0]);
        TableValueSetter letterEntryTs = new TableValueSetter(new String[0]);
        long orgId = model.getDataEntity().getLong("project.org.id");
        int index = 0;
        for (DynamicObject supplierEntry : supDataList) {
            Object supplierType = supplierEntry.get("suppliertype");
            Object supplier = supplierEntry.get("supplier");
            Object supplierId = null;
            supplierId = supplier instanceof DynamicObject ? ((DynamicObject)supplier).get("id") : supplier;
            if (supplier == null || !context.getSupplierIdsSet().add(supplierId)) continue;
            supEntryTs.set("suppliertype", supplierType, index);
            supEntryTs.set("supplier", supplierId, index);
            supEntryTs.set("supletterstype", (Object)lettersType, index);
            supEntryTs.set("entryproject", (Object)srcBillId, index);
            supEntryTs.set("purpublisher", (Object)RequestContext.get().getCurrUserId(), index);
            letterEntryTs.set("letterssuppliertype", supplierType, index);
            letterEntryTs.set("letterssupplier", supplierId, index);
            letterEntryTs.set("letterstype", (Object)lettersType, index);
            supEntryTs.set("org", (Object)orgId, index);
            ++index;
        }
        model.batchCreateNewEntryRow("supplierentry", supEntryTs);
        model.batchCreateNewEntryRow("lettersentry", letterEntryTs);
        this.setSupplierContractEntry(context);
    }

    private void setSupplierContractEntry(PdsMessageContext context) {
        DynamicObjectCollection supplierRows = context.getView().getModel().getEntryEntity("supplierentry");
        int i = 0;
        for (DynamicObject supplierRow : supplierRows) {
            String suppliertype = supplierRow.getString("suppliertype");
            DynamicObject supplier = supplierRow.getDynamicObject("supplier");
            Object linkMan = context.getView().getModel().getValue("linkman", i);
            if (null != linkMan && linkMan.toString().trim().length() != 0) {
                ++i;
                continue;
            }
            this.setSupplierContractInfo(context, suppliertype, supplier, i);
            ++i;
        }
    }

    private void setSupplierContractInfo(PdsMessageContext context, String suppliertype, DynamicObject newValue, int index) {
        HashMap<Object, Object> supMap = new HashMap(8);
        switch (suppliertype) {
            case "src_supplier": {
                supMap = PdsLinkManFacade.getRegSupplierLinkMan(newValue.get("id"));
                break;
            }
            case "bd_supplier": {
                supMap = PdsLinkManFacade.getSupplierLinkMan(newValue.get("id"));
                break;
            }
        }
        if (supMap.size() != 0) {
            IDataModel model = context.getView().getModel();
            model.beginInit();
            model.setValue("linkman", supMap.get("linkman"), index);
            model.setValue("duty", supMap.get("duty"), index);
            model.setValue("phone", supMap.get("phone"), index);
            model.setValue("email", supMap.get("email"), index);
            model.setValue("address", supMap.get("address"), index);
            SupplierUtil.setSupplierUser2Entry(model, index, SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity().getDynamicObject("project")), SrmCommonUtil.getPkValue((DynamicObject)newValue));
            model.endInit();
        }
    }

    private void delCantSendSupEntry(PdsMessageContext context) {
        HashSet<Object> cantSendSupIdSet = new HashSet<Object>(context.getSupplierIdsSet());
        Set<Object> allSupIdsSet = context.getAllSupplierIdsSet();
        if (null != allSupIdsSet && allSupIdsSet.size() > 0) {
            cantSendSupIdSet.removeAll(context.getAllSupplierIdsSet());
        }
        if (cantSendSupIdSet.size() == 0) {
            return;
        }
        IDataModel model = context.getView().getModel();
        model.beginInit();
        this.delEntry(context, cantSendSupIdSet, "supplierentry", "supplier");
        this.delEntry(context, cantSendSupIdSet, "lettersentry", "letterssupplier");
        model.endInit();
    }

    private void delEntry(PdsMessageContext context, Set<Object> cantSendSupIdSet, String entryKey, String supPro) {
        IDataModel model = context.getView().getModel();
        int supEntryRowCount = model.getEntryRowCount(entryKey);
        for (int i = 0; i < supEntryRowCount; ++i) {
            Object supId;
            Object supObj = model.getValue(supPro, i);
            if (null == supObj || !(supObj instanceof DynamicObject) || !cantSendSupIdSet.contains(supId = ((DynamicObject)supObj).getPkValue())) continue;
            model.deleteEntryRow(entryKey, i);
        }
    }
}

