/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.interactive;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.constant.PdsMessageConstant;
import kd.scm.pds.common.message.IPdsMessageInteractive;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageUtils;
import kd.scm.pds.common.util.PdsDocTplUtil;

public class PdsMessageBeforeF7Select
implements IPdsMessageInteractive {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        String fieldKey = context.getBeforef7evt().getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)context.getBeforef7evt().getFormShowParameter();
        if ("supplier".equals(fieldKey)) {
            this.supplierBeforeF7Select(context.getBillObj(), showParameter);
        }
        this.tplBeforeF7Select(context.getBillObj(), showParameter, fieldKey);
    }

    protected void tplBeforeF7Select(DynamicObject billObj, ListShowParameter showParameter, String fieldKey) {
        String[] bizTypes = PdsMessageUtils.getBizTypes(billObj);
        if (null == bizTypes) {
            return;
        }
        for (String bizType : bizTypes) {
            String letterType = PdsMessageConstant.BIZTYPE_LETTERTYPE_MAP().get(bizType);
            for (String tplType : PdsMessageConstant.TPL_TYPES()) {
                String tplName = bizType + tplType;
                if (!fieldKey.equals(tplName)) continue;
                QFilter tplFilter = new QFilter("biznode.bizobject", "=", billObj.get("srcbilltype"));
                if (null != letterType) {
                    tplFilter.and("letterstype", "=", (Object)letterType);
                }
                tplFilter.and("enable", "=", (Object)"1");
                QFilter scopeFilter = PdsDocTplUtil.getTplScopeFilter(billObj.getDynamicObject("project"));
                if (null != scopeFilter) {
                    tplFilter.and(scopeFilter);
                }
                String orderBy = "isdefault desc, lastupdatetime desc, number";
                showParameter.getListFilterParameter().setFilter(tplFilter);
                showParameter.getListFilterParameter().setOrderBy(orderBy);
                return;
            }
        }
    }

    protected void supplierBeforeF7Select(DynamicObject billObj, ListShowParameter showParameter) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("supplierentry");
        Set supplierIds = rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter treeFilter = new QFilter("id", "in", supplierIds);
        showParameter.getListFilterParameter().setFilter(treeFilter);
    }
}

