/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.params;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.constant.PdsMessageConstant;
import kd.scm.pds.common.message.IPdsMessageParams;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageFacade;
import kd.scm.pds.common.message.PdsMessageUtils;
import kd.scm.pds.common.noticetpl.IPdsNoticeInterface;
import kd.scm.pds.common.noticetpl.PdsNoticeTplContext;
import kd.scm.pds.common.noticetpl.PdsNoticeTplFactory;
import kd.scm.pds.common.util.PdsNoticeContentUtil;
import org.apache.commons.lang3.StringUtils;

public class PdsMessageUpdateLettersSupMap
implements IPdsMessageParams {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.updateLettersSupMap(context);
    }

    private void updateLettersSupMap(PdsMessageContext context) {
        Map<Long, Map<String, Object>> lettersSupMap = context.getLettersSupMap();
        String lettersType = context.getLettersType();
        String msgType = context.getSendType();
        String bizType = PdsMessageConstant.LETTERTYPE_BIZTYPE_MAP().get(lettersType);
        String[] msgTypes = msgType.split(",");
        IDataModel model = context.getView().getModel();
        String srcBillId = context.getBillObj().getString("srcbillid");
        String srcBillType = PdsMessageUtils.getSrcBillType(context.getBillObj());
        if (StringUtils.isBlank((CharSequence)srcBillId) || StringUtils.isBlank((CharSequence)srcBillType)) {
            return;
        }
        DynamicObject srcBillObj = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)srcBillType);
        Object title = model.getValue(bizType + "title");
        DynamicObjectCollection supplierColls = model.getEntryEntity("supplierentry");
        for (DynamicObject supplierRow : supplierColls) {
            Object currLettersType;
            DynamicObject supplier;
            long supplierId;
            Map<String, Object> params;
            if (!supplierRow.getBoolean("issend") || null == (params = lettersSupMap.get(supplierId = (supplier = supplierRow.getDynamicObject("supplier")).getLong("id"))) || null == (currLettersType = params.get("letterstype")) || !lettersType.equals(currLettersType.toString())) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("supplier", supplier);
            paramMap.put("letterstype", currLettersType);
            HashMap<String, Object> rebuildParamMap = new HashMap<String, Object>(2);
            block7: for (String type : msgTypes) {
                DynamicObject tpl = null;
                String content = "";
                String rebuidContent = "";
                if (type == null) continue;
                switch (type) {
                    case "portal": {
                        tpl = (DynamicObject)model.getValue(bizType + "portaltpl");
                        content = tpl.getString("content");
                        PdsMessageFacade.rebuidContent(context, rebuildParamMap, content, supplier);
                        rebuidContent = context.getRebuidContent();
                        rebuidContent = PdsNoticeContentUtil.updateContentTplKey(rebuidContent, srcBillType);
                        tpl.set("content", (Object)rebuidContent);
                        rebuidContent = this.getContent(srcBillObj, tpl, paramMap);
                        tpl.set("content", (Object)content);
                        params.put("portalcontent", rebuidContent);
                        params.put("portaltitle", title);
                        continue block7;
                    }
                    default: {
                        continue block7;
                    }
                }
            }
        }
    }

    private String getContent(DynamicObject srcBillObj, DynamicObject tpl, Map<String, Object> paramMap) {
        PdsNoticeTplContext noticeContext = new PdsNoticeTplContext(tpl, srcBillObj);
        noticeContext.setEntityKey(srcBillObj.getDynamicObjectType().getName());
        noticeContext.setContentTpl(tpl.getString("content"));
        noticeContext.setParamMap(paramMap);
        IPdsNoticeInterface pdsNoticePlugin = PdsNoticeTplFactory.getPdsNoticePluginInstance(noticeContext);
        String contents = pdsNoticePlugin.decorateContent(noticeContext);
        return contents;
    }
}

