/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.send;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pds.common.message.IPdsMessageSend;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageUtils;

public class PdsMessageSendEvents
implements IPdsMessageSend {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        this.sendEvents(context);
    }

    private void sendEvents(PdsMessageContext context) {
        String billType;
        String opKey = context.getOpKey();
        if (!"send".equals(opKey) && !"audit".equals(opKey)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        DynamicObject billObj = context.getBillObj();
        switch (billType = PdsMessageUtils.getSrcBillType(billObj)) {
            case "src_project": 
            case "src_bidpublish": {
                OperationServiceHelper.executeOperate((String)"sendinvite", (String)"pds_noticesupplier", (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
                break;
            }
            case "src_decision": {
                OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pds_noticesupplier", (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
                OperationServiceHelper.executeOperate((String)"sendmsgtowinsup", (String)"pds_noticesupplier", (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
                OperationServiceHelper.executeOperate((String)"sendmsgtofailsup", (String)"pds_noticesupplier", (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
                break;
            }
        }
    }
}

