/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.send;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.message.PdsMessageContext;
import kd.scm.pds.common.message.PdsMessageFacade;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsMessageSendOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("srcbilltype");
        e.getFieldKeys().add("replydate");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("supplierentry.issend");
        e.getFieldKeys().add("supplierentry.entrystatus");
        e.getFieldKeys().add("supplierentry.senddate");
        e.getFieldKeys().add("supplierentry.supreplydate");
        e.getFieldKeys().add("inviteportaltpl");
        e.getFieldKeys().add("prewinportaltpl");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] billObjs;
        super.beginOperationTransaction(args);
        for (DynamicObject billObj : billObjs = args.getDataEntities()) {
            PdsMessageContext context = new PdsMessageContext();
            context.setBillObj(billObj);
            context.setOpKey(args.getOperationKey());
            PdsMessageFacade.sendPortal(context);
            this.updateProjectInviteStatus(billObj, args.getOperationKey());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] billObjs;
        for (DynamicObject billObj : billObjs = e.getDataEntities()) {
            PdsMessageContext context = new PdsMessageContext();
            context.setBillObj(billObj);
            context.setOpKey(e.getOperationKey());
            context.setAfterOperationArgs(e);
            PdsMessageFacade.sendEvents(context);
        }
    }

    private void updateProjectInviteStatus(DynamicObject billObj, String opKey) {
        DynamicObject projectObj;
        long projectId = billObj.getLong("project.id");
        String entityName = "src_project";
        String fieldName = "isneedinvite";
        if (null == billObj.get("inviteportaltpl")) {
            entityName = "src_decision";
            if (null != billObj.get("prewinportaltpl")) {
                fieldName = "isneedinvite2";
            }
        }
        if (null != (projectObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)fieldName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)}))) {
            if ("audit".equals(opKey)) {
                projectObj.set(fieldName, (Object)"2");
            } else {
                projectObj.set(fieldName, (Object)"1");
            }
            PdsCommonUtils.saveDynamicObjects(projectObj);
        }
    }
}

