/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.message.send;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.message.IPdsMessageSend;
import kd.scm.pds.common.message.PdsMessageContext;

public class PdsMessageSendPortal
implements IPdsMessageSend {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsMessageContext context) {
        if ("send".equals(context.getOpKey()) || "audit".equals(context.getOpKey())) {
            this.sendPortal(context);
        } else {
            this.unSendPortal(context);
        }
    }

    private void sendPortal(PdsMessageContext context) {
        DynamicObject billObj = context.getBillObj();
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("supplierentry").append(".").append("entrystatus");
        selectFieldsSb.append(",").append("supplierentry").append(".").append("senddate");
        selectFieldsSb.append(",").append("supplierentry").append(".").append("issend");
        selectFieldsSb.append(",").append("supplierentry").append(".").append("supreplydate");
        selectFieldsSb.append(",").append("billstatus");
        QFilter fitler = new QFilter("id", "=", billObj.getPkValue());
        DynamicObject noticeObj = BusinessDataServiceHelper.loadSingle((String)billObj.getDataEntityType().getName(), (String)selectFieldsSb.toString(), (QFilter[])fitler.toArray());
        if (null == noticeObj) {
            return;
        }
        DynamicObjectCollection rows = noticeObj.getDynamicObjectCollection("supplierentry");
        for (DynamicObject row : rows) {
            if (!row.getBoolean("issend") || "C".equals(row.getString("entrystatus"))) continue;
            row.set("entrystatus", (Object)"C");
            row.set("senddate", (Object)TimeServiceHelper.now());
            row.set("supreplydate", billObj.get("replydate"));
        }
        noticeObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noticeObj});
    }

    private void unSendPortal(PdsMessageContext context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("supplierentry");
        for (DynamicObject row : rows) {
            if (!row.getBoolean("issend") || "A".equals(row.getString("entrystatus"))) continue;
            row.set("entrystatus", (Object)"A");
            row.set("senddate", null);
            row.set("supreplydate", null);
        }
        billObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
    }
}

