/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.mytask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.enums.MyTaskStatusEnums;
import kd.scm.pds.common.mytask.ISrcMyTaskEntrustHandler;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;

public class SrcMyTaskEntrustHandler
implements ISrcMyTaskEntrustHandler {
    @Override
    public void process(SrcMyTaskContext context) {
        DynamicObject[] myTaskObjs = SrcMyTaskFacade.getMyTaskByHandleIds(context.getHandleIds());
        ArrayList<DynamicObject> newMyTaskList = new ArrayList<DynamicObject>(myTaskObjs.length);
        ArrayList<DynamicObject> scoreTaskList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> bidOpenCfgList = new ArrayList<DynamicObject>(8);
        this.entrustMyTask(context, myTaskObjs, newMyTaskList);
        this.entrustScoreTask(context, myTaskObjs, scoreTaskList);
        this.entrustBidOpenConfig(context, myTaskObjs, bidOpenCfgList);
        this.saveResult(myTaskObjs, newMyTaskList, scoreTaskList, bidOpenCfgList);
        context.setNewMyTaskList(newMyTaskList);
        String message = String.format(ResManager.loadKDString((String)"\u8f6c\u4ea4\u5904\u7406\u6210\u529f\uff0c\u5171\u5904\u7406\uff1a %1$s \u4e2a\u4efb\u52a1\u3002", (String)"SrcMyTaskEntrustHandler_0", (String)"scm-pds-common", (Object[])new Object[0]), newMyTaskList.size());
        context.setHandleMessage(message);
    }

    private void entrustMyTask(SrcMyTaskContext context, DynamicObject[] myTaskObjs, List<DynamicObject> newMyTaskList) {
        Map myTaskMap = Arrays.asList(myTaskObjs).stream().collect(Collectors.groupingBy(e -> e.getString("billid"), Collectors.toList()));
        for (Map.Entry myTask : myTaskMap.entrySet()) {
            int seq = SrcMyTaskFacade.getBillEntrySeq(Long.parseLong(myTask.getKey()));
            for (DynamicObject myTaskObj : myTask.getValue()) {
                this.setMyTaskValue(context, myTaskObj);
                DynamicObject newMyTaskObj = BusinessDataServiceHelper.newDynamicObject((String)"src_memberclarify");
                newMyTaskObj.set("fseq", (Object)seq++);
                this.setNewMyTaskValue(context, myTaskObj, newMyTaskObj);
                newMyTaskList.add(newMyTaskObj);
            }
        }
    }

    private void entrustScoreTask(SrcMyTaskContext context, DynamicObject[] myTaskObjs, List<DynamicObject> scoreTaskList) {
        Set projectIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        if (projectIds == null || projectIds.size() == 0) {
            return;
        }
        Set srcEntryIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        Set bidderIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("bidder.id") > 0L).map(e -> e.getLong("bidder.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("project", "in", projectIds);
        qfilter.and("srcentryid", "in", srcEntryIds);
        qfilter.and("scorer", "in", bidderIds);
        qfilter.and("billid.bizstatus", "!=", (Object)"E");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoreanalyse", (String)"scorer", (QFilter[])qfilter.toArray());
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("scorer", (Object)context.getUserId());
            scoreTaskList.add(row);
        }
    }

    private void entrustBidOpenConfig(SrcMyTaskContext context, DynamicObject[] myTaskObjs, List<DynamicObject> bidOpenCfgList) {
        Set srcEntryIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        Set bidderIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("bidder.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", srcEntryIds);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_bidopenconfig", (String)"scorer", (QFilter[])qfilter.toArray());
        if (!(rows != null && rows.length != 0 || (rows = BusinessDataServiceHelper.load((String)"src_aptitudeconfigf7", (String)"scorer", (QFilter[])qfilter.toArray())) != null && rows.length != 0)) {
            rows = BusinessDataServiceHelper.load((String)"src_aptitudeconfig2f7", (String)"scorer", (QFilter[])qfilter.toArray());
        }
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection scorerRows = row.getDynamicObjectCollection("scorer");
            Boolean isChanged = false;
            for (DynamicObject scorerRow : scorerRows) {
                DynamicObject basedataObj = scorerRow.getDynamicObject("fbasedataid");
                Long scorerId = (Long)basedataObj.getPkValue();
                if (!bidderIds.contains(scorerId)) continue;
                scorerRow.set("fbasedataid", (Object)context.getUserId());
                isChanged = true;
            }
            if (!isChanged.booleanValue()) continue;
            bidOpenCfgList.add(row);
        }
    }

    private void setMyTaskValue(SrcMyTaskContext context, DynamicObject myTaskObj) {
        myTaskObj.set("entrystatus", (Object)MyTaskStatusEnums.ENTRUSTED.getValue());
        myTaskObj.set("remark", (Object)this.buildeRemark(context, myTaskObj));
    }

    private void setNewMyTaskValue(SrcMyTaskContext context, DynamicObject myTaskObj, DynamicObject newMyTaskObj) {
        newMyTaskObj.set("billid", (Object)myTaskObj.getString("billid"));
        newMyTaskObj.set("project", (Object)myTaskObj.getLong("project.id"));
        newMyTaskObj.set("bidder", (Object)context.getUserId());
        newMyTaskObj.set("type", (Object)myTaskObj.getString("type"));
        newMyTaskObj.set("bizrole", myTaskObj.get("bizrole"));
        DynamicObjectCollection rows = myTaskObj.getDynamicObjectCollection("biztype");
        if (null != rows && rows.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForObject(newMyTaskObj, rows, "biztype");
        }
        newMyTaskObj.set("note", (Object)myTaskObj.getString("note"));
        newMyTaskObj.set("remark", (Object)myTaskObj.getString("remark"));
        newMyTaskObj.set("entrystatus", (Object)MyTaskStatusEnums.NOTSTARTED.getValue());
        newMyTaskObj.set("isclarify", (Object)"0");
        newMyTaskObj.set("isbenifit", (Object)"2");
        newMyTaskObj.set("isnotify", (Object)"1");
        newMyTaskObj.set("creator", (Object)myTaskObj.getLong("bidder.id"));
        newMyTaskObj.set("createtime", (Object)TimeServiceHelper.now());
        newMyTaskObj.set("srcentryid", (Object)myTaskObj.getLong("srcentryid"));
        SrcClarifyUtils.setUserInfo(newMyTaskObj, context.getUserId());
    }

    private void saveResult(DynamicObject[] myTaskObjs, List<DynamicObject> newMyTaskList, List<DynamicObject> scoreTaskList, List<DynamicObject> bidOpenCfgList) {
        try (TXHandle h = TX.required();){
            try {
                PdsCommonUtils.saveDynamicObjects(myTaskObjs);
                PdsCommonUtils.saveDynamicObjects(newMyTaskList);
                PdsCommonUtils.saveDynamicObjects(scoreTaskList);
                PdsCommonUtils.saveDynamicObjects(bidOpenCfgList);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    private String buildeRemark(SrcMyTaskContext context, DynamicObject myTaskObj) {
        String bidderName = myTaskObj.getString("bidder.name");
        String entrustType = ResManager.loadKDString((String)" \u8f6c\u4ea4\u7ed9 ", (String)"SrcMyTaskEntrustHandler_1", (String)"scm-pds-common", (Object[])new Object[0]);
        StringBuilder remark = new StringBuilder(context.getDescription());
        remark = remark.toString().trim().length() == 0 ? remark.append(bidderName).append(entrustType).append(context.getUserName()) : remark.append(',').append(bidderName).append(entrustType).append(context.getUserName());
        return remark.toString();
    }
}

