/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.mytask;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.mytask.ISrcMyTaskClarifyHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskClarifyVerifier;
import kd.scm.pds.common.mytask.ISrcMyTaskCreateByMember;
import kd.scm.pds.common.mytask.ISrcMyTaskCreateByReference;
import kd.scm.pds.common.mytask.ISrcMyTaskCreateByScorer;
import kd.scm.pds.common.mytask.ISrcMyTaskEntrustHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskEntrustVerifier;
import kd.scm.pds.common.mytask.ISrcMyTaskNotifyHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskNotifyVerifier;
import kd.scm.pds.common.mytask.ISrcMyTaskOperationHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskScoreHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskScoreVerifier;
import kd.scm.pds.common.mytask.ISrcMyTaskSigninHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskSigninVerifier;
import kd.scm.pds.common.mytask.ISrcMyTaskTerminateHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskTerminateVerifier;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFactory;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class SrcMyTaskFacade {
    public static void createMyTaskByMember(SrcMyTaskContext context) {
        List<ISrcMyTaskCreateByMember> clarifyVerifiers = SrcMyTaskFactory.getCreateByMemberInstances();
        for (ISrcMyTaskCreateByMember clarifyVerifier : clarifyVerifiers) {
            clarifyVerifier.process(context);
        }
    }

    public static void createMyTaskByReference(SrcMyTaskContext context) {
        List<ISrcMyTaskCreateByReference> createByReferences = SrcMyTaskFactory.getCreateByReferenceInstances();
        for (ISrcMyTaskCreateByReference createByReference : createByReferences) {
            createByReference.process(context);
        }
    }

    public static void createMyTaskByScorer(SrcMyTaskContext context) {
        List<ISrcMyTaskCreateByScorer> createByScorers = SrcMyTaskFactory.getCreateByScorerInstances();
        for (ISrcMyTaskCreateByScorer createByScorer : createByScorers) {
            createByScorer.process(context);
        }
    }

    public static void clarifyVerify(SrcMyTaskContext context) {
        List<ISrcMyTaskClarifyVerifier> clarifyVerifiers = SrcMyTaskFactory.getClarifyVerifierInstances();
        for (ISrcMyTaskClarifyVerifier clarifyVerifier : clarifyVerifiers) {
            clarifyVerifier.process(context);
        }
    }

    public static void ClarifyHandle(SrcMyTaskContext context) {
        List<ISrcMyTaskClarifyHandler> clarifyHandlers = SrcMyTaskFactory.getClarifyHandlerInstances();
        for (ISrcMyTaskClarifyHandler clarifyHandler : clarifyHandlers) {
            clarifyHandler.process(context);
        }
    }

    public static void SigninVerify(SrcMyTaskContext context) {
        List<ISrcMyTaskSigninVerifier> signinVerifiers = SrcMyTaskFactory.getSigninVerifierInstances();
        for (ISrcMyTaskSigninVerifier signinVerifier : signinVerifiers) {
            signinVerifier.process(context);
        }
    }

    public static void signinHandle(SrcMyTaskContext context) {
        List<ISrcMyTaskSigninHandler> signinHandlers = SrcMyTaskFactory.getSigninHandlerInstances();
        for (ISrcMyTaskSigninHandler signinHandler : signinHandlers) {
            signinHandler.process(context);
        }
    }

    public static void notifyVerify(SrcMyTaskContext context) {
        List<ISrcMyTaskNotifyVerifier> verifiers = SrcMyTaskFactory.getNotifyVerifierInstances();
        for (ISrcMyTaskNotifyVerifier verifier : verifiers) {
            verifier.process(context);
        }
    }

    public static void notifyHandle(SrcMyTaskContext context) {
        List<ISrcMyTaskNotifyHandler> handlers = SrcMyTaskFactory.getNotifyHandlerInstances();
        for (ISrcMyTaskNotifyHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void entrustVerify(SrcMyTaskContext context) {
        List<ISrcMyTaskEntrustVerifier> entrustVerifiers = SrcMyTaskFactory.getEntrustVerifierInstances();
        for (ISrcMyTaskEntrustVerifier entrustVerifier : entrustVerifiers) {
            entrustVerifier.process(context);
        }
    }

    public static void entrustHandle(SrcMyTaskContext context) {
        List<ISrcMyTaskEntrustHandler> entrustHandlers = SrcMyTaskFactory.getEntrustHandlerInstances();
        for (ISrcMyTaskEntrustHandler entrustHandler : entrustHandlers) {
            entrustHandler.process(context);
        }
    }

    public static void scoreVerify(SrcMyTaskContext context) {
        List<ISrcMyTaskScoreVerifier> scoreVerifiers = SrcMyTaskFactory.getScoreVerifierInstances();
        for (ISrcMyTaskScoreVerifier scoreVerifier : scoreVerifiers) {
            scoreVerifier.process(context);
        }
    }

    public static void scoreHandle(SrcMyTaskContext context) {
        List<ISrcMyTaskScoreHandler> scoreHandlers = SrcMyTaskFactory.getScoreHandlerInstances();
        for (ISrcMyTaskScoreHandler scoreHandler : scoreHandlers) {
            scoreHandler.process(context);
        }
    }

    public static void terminateVerify(SrcMyTaskContext context) {
        List<ISrcMyTaskTerminateVerifier> terminateVerifiers = SrcMyTaskFactory.getTerminateVerifierInstances();
        for (ISrcMyTaskTerminateVerifier terminateVerifier : terminateVerifiers) {
            terminateVerifier.process(context);
        }
    }

    public static void terminateHandle(SrcMyTaskContext context) {
        List<ISrcMyTaskTerminateHandler> terminateHandlers = SrcMyTaskFactory.getTerminateHandlerInstances();
        for (ISrcMyTaskTerminateHandler terminateHandler : terminateHandlers) {
            terminateHandler.process(context);
        }
    }

    public static DynamicObject[] getMyTaskByHandleIds(Set<Long> handleIds) {
        QFilter qfilter = new QFilter("id", "in", handleIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_memberclarify", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_memberclarify", (String)selectFields, (QFilter[])qfilter.toArray());
    }

    public static Map<String, String> getProjectInfoByHandleIds(Set<Long> handleIds) {
        DynamicObject[] myTaskObjs = SrcMyTaskFacade.getMyTaskByHandleIds(handleIds);
        Map myTaskMap = Arrays.asList(myTaskObjs).stream().collect(Collectors.groupingBy(e -> e.getString("project.id"), Collectors.toList()));
        StringBuilder billNo = new StringBuilder();
        StringBuilder bidName = new StringBuilder();
        for (Map.Entry myTask : myTaskMap.entrySet()) {
            billNo.append(((DynamicObject)myTask.getValue().get(0)).getString("project.billno")).append(',');
            bidName.append(((DynamicObject)myTask.getValue().get(0)).getString("project.bidname")).append(',');
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        resultMap.put("billno", billNo.length() == 0 ? "" : billNo.substring(0, billNo.length() - 1));
        resultMap.put("bidname", bidName.length() == 0 ? "" : bidName.substring(0, bidName.length() - 1));
        return resultMap;
    }

    public static int getBillEntrySeq(long billId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)billId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"id", (QFilter[])qfilter.toArray());
        if (rows != null && rows.size() > 0) {
            return rows.size();
        }
        return 1;
    }

    public static Set<Long> getHandleIdsFromView(IFormView view) {
        Map paramMap = view.getFormShowParameter().getCustomParams();
        if (paramMap == null || paramMap.size() == 0) {
            return null;
        }
        Object handleIdsObj = paramMap.get("id");
        if (handleIdsObj != null) {
            return (Set)SerializationUtils.fromJsonString((String)handleIdsObj.toString(), Set.class);
        }
        Object pkId = paramMap.get("pkId");
        if (pkId != null) {
            HashSet<Long> idSet = new HashSet<Long>(1);
            idSet.add(PdsCommonUtils.object2Long(pkId));
            return idSet;
        }
        return null;
    }

    public static Set<String> getTodoTaskSet(DynamicObject myTaskObj) {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setMyTaskObj(myTaskObj);
        List<ISrcMyTaskOperationHandler> handlers = SrcMyTaskFactory.getOperationHandlerInstances();
        for (ISrcMyTaskOperationHandler handler : handlers) {
            handler.process(context);
        }
        return context.getTodoTaskSet();
    }

    public static QFilter getScoreTaskFilter(DynamicObject myTaskObj, Set<String> baseTypeSet) {
        QFilter qfilters = new QFilter("scorer", "=", (Object)RequestContext.get().getCurrUserId());
        qfilters.and("scored", "=", (Object)"0");
        qfilters.and("billid.bizstatus", "!=", (Object)"E");
        qfilters.and("index.indextype.basetype", "in", baseTypeSet);
        if (null != myTaskObj) {
            long projectId = myTaskObj.getLong("project.id");
            qfilters.and("project", "=", (Object)projectId);
            qfilters.and("srcentryid", "=", (Object)myTaskObj.getLong("srcentryid"));
        }
        return qfilters;
    }

    public static Set<String> getBaseTypeSet(DynamicObject myTaskObj) {
        DynamicObjectCollection bizTypeObjs = myTaskObj.getDynamicObjectCollection("biztype");
        return SrcMyTaskFacade.getBaseTypeSet(bizTypeObjs);
    }

    public static Set<String> getBaseTypeSet(DynamicObjectCollection bizTypeObjs) {
        HashSet<String> baseTypeSet = new HashSet<String>(4);
        for (DynamicObject bizTypeObj : bizTypeObjs) {
            SrcMyTaskFacade.getBaseType(bizTypeObj, baseTypeSet);
        }
        return baseTypeSet;
    }

    public static Set<String> getBaseTypeSet(Map<Long, DynamicObject> bizTypeObjsMap) {
        HashSet<String> baseTypeSet = new HashSet<String>(4);
        for (Map.Entry<Long, DynamicObject> entry : bizTypeObjsMap.entrySet()) {
            SrcMyTaskFacade.getBaseType(entry.getValue(), baseTypeSet);
        }
        return baseTypeSet;
    }

    public static void getBaseType(DynamicObject bizTypeObj, Set<String> baseTypeSet) {
        String number;
        switch (number = bizTypeObj.getString("fbasedataid.number")) {
            case "C021801": {
                baseTypeSet.add("1");
                break;
            }
            case "C021802": {
                baseTypeSet.add("2");
                break;
            }
            case "C021803": {
                baseTypeSet.add("3");
                break;
            }
            case "C021806": {
                baseTypeSet.add("1");
                baseTypeSet.add("2");
                baseTypeSet.add("3");
                break;
            }
            case "C021804": {
                baseTypeSet.add("4");
                break;
            }
            case "C021807": {
                baseTypeSet.add("7");
                break;
            }
        }
    }

    public static Set<String> getMyTaskOperationRoleSet(String operationKey) {
        Set<String> operationRoleSet = new HashSet<String>(4);
        String operationRoles = (String)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)operationKey);
        if (null != operationRoles) {
            operationRoleSet = Arrays.stream(operationRoles.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList()).stream().collect(Collectors.toSet());
        }
        if (operationRoleSet.size() == 0) {
            operationRoleSet.add("1");
            operationRoleSet.add("2");
        }
        return operationRoleSet;
    }

    public static QFilter getMyTaskUserFilter(String operationKey, Set<String> baseTypeSet) {
        QFilter userFilter = null;
        Set<String> userRoleSet = SrcMyTaskFacade.getMyTaskOperationRoleSet(operationKey);
        if (userRoleSet.contains("1")) {
            userFilter = SrcMyTaskFacade.buildQFilter(userFilter, new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId()));
        }
        if (userRoleSet.contains("2")) {
            userFilter = SrcMyTaskFacade.buildQFilter(userFilter, new QFilter("project.creator", "=", (Object)RequestContext.get().getCurrUserId()));
        }
        if (userRoleSet.contains("3")) {
            userFilter = SrcMyTaskFacade.buildQFilter(userFilter, new QFilter("bidder1", "=", (Object)RequestContext.get().getCurrUserId()));
        }
        if (userRoleSet.contains("4")) {
            userFilter = baseTypeSet.contains("4") ? SrcMyTaskFacade.buildQFilter(userFilter, new QFilter("bidder2", "=", (Object)RequestContext.get().getCurrUserId())) : (baseTypeSet.contains("7") ? SrcMyTaskFacade.buildQFilter(userFilter, new QFilter("bidder3", "=", (Object)RequestContext.get().getCurrUserId())) : SrcMyTaskFacade.buildQFilter(userFilter, new QFilter("bidder4", "=", (Object)RequestContext.get().getCurrUserId())));
        }
        return userFilter;
    }

    private static QFilter buildQFilter(QFilter userFilter, QFilter qfilter) {
        if (userFilter != null) {
            userFilter.or(qfilter);
        } else {
            userFilter = qfilter;
        }
        return userFilter;
    }

    public static Map<String, Long> getBizRoleUserMap(long projectId) {
        HashMap<String, Long> bizRoleUserMap = new HashMap(8);
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("bizrole", "!=", (Object)0L);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"bizrole.number,bidder.id", (QFilter[])qfilter.toArray());
        bizRoleUserMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("bizrole.number"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getLong("bidder.id"))));
        return bizRoleUserMap;
    }

    public static void setBizRoleUserValue(Map<String, Long> bizRoleUserMap, DynamicObject mytaskObj) {
        mytaskObj.set("bidder1", (Object)bizRoleUserMap.get("SYS001"));
        mytaskObj.set("bidder2", (Object)bizRoleUserMap.get("SYS019"));
        mytaskObj.set("bidder3", (Object)bizRoleUserMap.get("SYS020"));
        mytaskObj.set("bidder4", (Object)bizRoleUserMap.get("SYS017"));
        mytaskObj.set("bidder5", (Object)bizRoleUserMap.get("SYS014"));
    }

    public static void setBizRoleUser(long projectId, DynamicObject row) {
        DynamicObjectCollection rows = new DynamicObjectCollection();
        rows.add((Object)row);
        SrcMyTaskFacade.setBizRoleUsers(projectId, rows);
    }

    public static void setBizRoleUsers(long projectId, DynamicObjectCollection rows) {
        if (rows.size() == 0) {
            return;
        }
        Map<String, Long> bizRoleUserMap = SrcMyTaskFacade.getBizRoleUserMap(projectId);
        Map<String, Long> bizRoleUserMap2 = rows.stream().filter(e -> !Objects.isNull(e.getString("bizrole.number"))).collect(Collectors.groupingBy(e -> e.getString("bizrole.number"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getLong("bidder.id"))));
        bizRoleUserMap.putAll(bizRoleUserMap2);
        if (bizRoleUserMap.size() == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            SrcMyTaskFacade.setBizRoleUserValue(bizRoleUserMap, row);
        }
    }

    public static void getMyTaskObjAndBaseTypeSet(SrcMyTaskContext context) {
        DynamicObject[] myTaskObjs = SrcMyTaskFacade.getMyTaskByHandleIds(context.getSelectIds());
        if (myTaskObjs.length == 0) {
            return;
        }
        DynamicObject myTaskObj = myTaskObjs[0];
        context.setMyTaskObj(myTaskObj);
        context.setBaseTypeSet(SrcMyTaskFacade.getBaseTypeSet(myTaskObj));
    }

    public static DynamicObject[] getSelectMytaskObjs(IFormView view) {
        Set<Long> idSet = ListSelectUtils.getListSelectPrimaryKeys(view);
        if (null == idSet || idSet.size() == 0) {
            return null;
        }
        QFilter qfilter = new QFilter("id", "in", idSet);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_memberclarify", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_memberclarify", (String)selectFields, (QFilter[])qfilter.toArray());
    }

    public static Set<String> getSelectBizTypeSet(DynamicObject[] myTaskObjs) {
        if (null == myTaskObjs || myTaskObjs.length == 0) {
            return null;
        }
        DynamicObjectCollection bizTypeObjs = new DynamicObjectCollection();
        for (DynamicObject myTaskObj : myTaskObjs) {
            bizTypeObjs.addAll((Collection)myTaskObj.getDynamicObjectCollection("biztype"));
        }
        if (bizTypeObjs.size() == 0) {
            return null;
        }
        Map<Long, DynamicObject> bizTypeObjsMap = bizTypeObjs.stream().collect(Collectors.groupingBy(e -> e.getLong("fbasedataid.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        return SrcMyTaskFacade.getBaseTypeSet(bizTypeObjsMap);
    }

    public static Set<Long> getSelectProjectIds(DynamicObject[] mytaskObjs) {
        if (null == mytaskObjs || mytaskObjs.length == 0) {
            return null;
        }
        return Arrays.asList(mytaskObjs).stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
    }
}

