/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.mytask;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.mytask.ISrcMyTaskOperationHandler;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcMyTaskOperationHandler
implements ISrcMyTaskOperationHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcMyTaskContext context) {
        this.getTodoTaskSet(context);
    }

    protected void getTodoTaskSet(SrcMyTaskContext context) {
        boolean isOpenControl;
        DynamicObject myTaskObj = context.getMyTaskObj();
        Set<String> baseTypeSet = SrcMyTaskFacade.getBaseTypeSet(myTaskObj);
        boolean isBidder = myTaskObj.getLong("bidder.id") == RequestContext.get().getCurrUserId();
        boolean isCreator = myTaskObj.getLong("project.creator.id") == RequestContext.get().getCurrUserId();
        boolean isProjectManager = myTaskObj.getLong("bidder1.id") == RequestContext.get().getCurrUserId();
        boolean isScoreManager = false;
        if (baseTypeSet.contains("4")) {
            isScoreManager = myTaskObj.getLong("bidder2.id") == RequestContext.get().getCurrUserId();
        } else if (baseTypeSet.contains("7")) {
            isScoreManager = myTaskObj.getLong("bidder3.id") == RequestContext.get().getCurrUserId();
        } else {
            boolean bl = isScoreManager = myTaskObj.getLong("bidder4.id") == RequestContext.get().getCurrUserId();
        }
        if (!(isBidder || isCreator || isProjectManager || isScoreManager)) {
            return;
        }
        if (!"A".equals(myTaskObj.getString("entrystatus")) && !"C".equals(myTaskObj.getString("entrystatus"))) {
            return;
        }
        String openStatus = myTaskObj.getString("project.openstatus");
        if (BidOpenStatusEnums.DECISION.getValue().equals(openStatus) || BidOpenStatusEnums.ARCHIVED.getValue().equals(openStatus) || BidOpenStatusEnums.TERMINATED.getValue().equals(openStatus)) {
            return;
        }
        Set<String> todoTaskSet = SrcMyTaskOperationHandler.getInitTodoTaskSet();
        if (myTaskObj.getLong("bidder.id") != RequestContext.get().getCurrUserId()) {
            todoTaskSet.remove("clarify");
            todoTaskSet.remove("signin");
            todoTaskSet.remove("handle");
        }
        if (todoTaskSet.contains("entrust")) {
            this.removeInvalidOperation(todoTaskSet, isBidder, isCreator, isProjectManager, isScoreManager, "entrust");
        }
        if (todoTaskSet.contains("terminate")) {
            this.removeInvalidOperation(todoTaskSet, isBidder, isCreator, isProjectManager, isScoreManager, "terminate");
        }
        if (!myTaskObj.getString("type").equals("3")) {
            todoTaskSet.remove("handle");
        } else {
            todoTaskSet.remove("encrypt");
            todoTaskSet.remove("bidopen");
        }
        if (myTaskObj.getBoolean("issignin")) {
            todoTaskSet.remove("signin");
        }
        if (myTaskObj.getString("type").equals("3") || !myTaskObj.getBoolean("needsignin")) {
            // empty if block
        }
        if (myTaskObj.getBoolean("isclarify")) {
            todoTaskSet.remove("clarify");
        }
        if (!((isOpenControl = myTaskObj.getBoolean("project.isopencontrol")) && (BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.BIZOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.OPEN.getValue().equals(openStatus)))) {
            todoTaskSet.remove("encrypt");
            todoTaskSet.remove("bidopen");
        }
        this.resetHandleVisible(myTaskObj, todoTaskSet);
        this.resetEncryptVisible(myTaskObj, todoTaskSet);
        this.resetBidOpenVisible(myTaskObj, todoTaskSet);
        context.setTodoTaskSet(todoTaskSet);
    }

    protected void resetHandleVisible(DynamicObject myTaskObj, Set<String> todoTaskSet) {
        if (todoTaskSet.remove("handle")) {
            String scoreType = PdsCommonUtils.object2String(myTaskObj.get("project.scoretype"), "1");
            String aptitudeType = PdsCommonUtils.object2String(myTaskObj.get("project.aptitudetype"), "1");
            if ("1".equals(scoreType) || "1".equals(aptitudeType)) {
                QFilter qfilters = SrcMyTaskFacade.getScoreTaskFilter(myTaskObj, SrcMyTaskFacade.getBaseTypeSet(myTaskObj));
                qfilters.and("billid.bizstatus", "!=", (Object)"E");
                if (QueryServiceHelper.exists((String)"src_scoreanalyse", (QFilter[])qfilters.toArray())) {
                    todoTaskSet.add("handle");
                }
            }
        }
    }

    protected void resetEncryptVisible(DynamicObject myTaskObj, Set<String> todoTaskSet) {
        if (todoTaskSet.remove("encrypt")) {
            QFilter qfilter = new QFilter("project", "=", (Object)myTaskObj.getLong("project.id"));
            qfilter.and(new QFilter("isencrypt", "=", (Object)"0").or("isdecrypt", "=", (Object)"0"));
            QFilter userFilter = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
            userFilter.or("project.creator", "=", (Object)RequestContext.get().getCurrUserId());
            qfilter.and(userFilter);
            if (QueryServiceHelper.exists((String)"pds_encryptdetail", (QFilter[])qfilter.toArray())) {
                todoTaskSet.add("encrypt");
            }
        }
    }

    protected void resetBidOpenVisible(DynamicObject myTaskObj, Set<String> todoTaskSet) {
        if (todoTaskSet.remove("bidopen")) {
            QFilter qfilter = new QFilter("project", "=", (Object)myTaskObj.getLong("project.id"));
            qfilter.and("isbidopen", "=", (Object)"0");
            QFilter userFilter = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
            userFilter.or("project.creator", "=", (Object)RequestContext.get().getCurrUserId());
            qfilter.and(userFilter);
            if (QueryServiceHelper.exists((String)"pds_bidopendetail", (QFilter[])qfilter.toArray())) {
                todoTaskSet.add("bidopen");
            }
        }
    }

    private void removeInvalidOperation(Set<String> todoTaskSet, boolean isBidder, boolean isCreator, boolean isProjectManager, boolean isScoreManager, String operationKey) {
        Set<String> roleSet = SrcMyTaskFacade.getMyTaskOperationRoleSet(operationKey);
        boolean isHander = false;
        if (roleSet.contains("1") && isBidder) {
            isHander = true;
        } else if (roleSet.contains("2") && isCreator) {
            isHander = true;
        } else if (roleSet.contains("3") && isProjectManager) {
            isHander = true;
        } else if (roleSet.contains("4") && isScoreManager) {
            isHander = true;
        }
        if (!isHander) {
            todoTaskSet.remove(operationKey);
        }
    }

    public static Set<String> getInitTodoTaskSet() {
        return new HashSet<String>(){
            {
                this.add("clarify");
                this.add("signin");
                this.add("handle");
                this.add("entrust");
                this.add("terminate");
                this.add("encrypt");
                this.add("bidopen");
            }
        };
    }
}

