/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.mytask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.MyTaskStatusEnums;
import kd.scm.pds.common.mytask.ISrcMyTaskTerminateHandler;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.mytask.SrcMyTaskFacade;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public class SrcMyTaskTerminateHandler
implements ISrcMyTaskTerminateHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcMyTaskContext context) {
        DynamicObject[] myTaskObjs = SrcMyTaskFacade.getMyTaskByHandleIds(context.getHandleIds());
        ArrayList<DynamicObject> bidOpenCfgList = new ArrayList<DynamicObject>(8);
        this.terminateMyTask(myTaskObjs);
        this.deleteScoreTask(myTaskObjs);
        this.deleteBidOpenConfig(myTaskObjs, bidOpenCfgList);
        this.saveResult(myTaskObjs, bidOpenCfgList);
        String message = String.format(ResManager.loadKDString((String)"\u7ec8\u6b62\u5904\u7406\u6210\u529f\uff0c\u5171\u5904\u7406\uff1a %1$s \u4e2a\u4efb\u52a1\u3002", (String)"SrcMyTaskTerminateHandler_0", (String)"scm-pds-common", (Object[])new Object[0]), myTaskObjs.length);
        context.setHandleMessage(message);
    }

    private void terminateMyTask(DynamicObject[] myTaskObjs) {
        for (DynamicObject myTaskObj : myTaskObjs) {
            myTaskObj.set("entrystatus", (Object)MyTaskStatusEnums.TERMINATED.getValue());
            String remark = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab%1$s\u7ec8\u6b62\uff0c\u7ec8\u6b62\u65f6\u95f4\uff1a%2$s", (String)"SrcMyTaskTerminateHandler_1", (String)"scm-pds-common", (Object[])new Object[0]), RequestContext.get().getUserName(), SrcDateUtils.getCurrentDateTime());
            myTaskObj.set("remark", (Object)remark);
        }
    }

    private void deleteScoreTask(DynamicObject[] myTaskObjs) {
        Set projectIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        if (projectIds == null || projectIds.size() == 0) {
            return;
        }
        Set srcEntryIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        Set bidderIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("bidder.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("project", "in", projectIds);
        qfilter.and("srcentryid", "in", srcEntryIds);
        qfilter.and("scorer", "in", bidderIds);
        qfilter.and("billid.bizstatus", "!=", (Object)"E");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_scoreanalyse", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoreanalyse", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows == null || rows.length == 0) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(rows.length);
        HashSet<Long> billIdSet = new HashSet<Long>(1);
        for (DynamicObject myTaskObj : myTaskObjs) {
            long projectId = myTaskObj.getLong("project.id");
            long srcEntryId = myTaskObj.getLong("srcentryid");
            long bidderId = myTaskObj.getLong("bidder.id");
            for (DynamicObject row : rows) {
                long projectId2 = row.getLong("project.id");
                long srcEntryId2 = row.getLong("srcentryid");
                long bidderId2 = row.getLong("scorer.id");
                if (projectId != projectId2 || srcEntryId != srcEntryId2 || bidderId != bidderId2) continue;
                idSet.add((Long)row.getPkValue());
                billIdSet.add(row.getLong("billid.id"));
            }
        }
        QFilter qfilters = new QFilter("id", "in", idSet);
        DeleteServiceHelper.delete((String)"src_scoreanalyse", (QFilter[])qfilters.toArray());
        this.updateScoreTaskStatus(billIdSet);
    }

    protected void updateScoreTaskStatus(Set<Long> billIdSet) {
        QFilter billFilter = new QFilter("id", "in", billIdSet);
        billFilter.and("bizstatus", "!=", (Object)"E");
        DynamicObject[] scoretaskObjs = BusinessDataServiceHelper.load((String)"src_scoretask", (String)"bizstatus,sumscore,finishdate", (QFilter[])billFilter.toArray());
        if (scoretaskObjs.length == 0) {
            return;
        }
        HashSet<Long> deleteIds = new HashSet<Long>(8);
        for (DynamicObject scoretaskObj : scoretaskObjs) {
            long billId = SrmCommonUtil.getPkValue((DynamicObject)scoretaskObj);
            QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
            billIdFilter.and("billid.bizstatus", "!=", (Object)"E");
            if (!QueryServiceHelper.exists((String)"src_scoreanalyse", (QFilter[])billIdFilter.toArray())) {
                deleteIds.add(billId);
                continue;
            }
            QFilter unScoreFilter = new QFilter("billid", "=", (Object)billId).and("scored", "=", (Object)"0");
            unScoreFilter.and("billid.bizstatus", "!=", (Object)"E");
            if (!QueryServiceHelper.exists((String)"src_scoreanalyse", (QFilter[])unScoreFilter.toArray())) {
                scoretaskObj.set("bizstatus", (Object)SrmScoreStatusEnum.SCORED.getValue());
                continue;
            }
            QFilter hasScoreFilter = new QFilter("billid", "=", (Object)billId).and("scored", "=", (Object)"1");
            hasScoreFilter.and("billid.bizstatus", "!=", (Object)"E");
            if (!QueryServiceHelper.exists((String)"src_scoreanalyse", (QFilter[])hasScoreFilter.toArray())) {
                scoretaskObj.set("bizstatus", (Object)SrmScoreStatusEnum.TOBESCORE.getValue());
                continue;
            }
            scoretaskObj.set("bizstatus", (Object)SrmScoreStatusEnum.PARTSCORED.getValue());
        }
        PdsCommonUtils.saveDynamicObjects(scoretaskObjs);
        this.deleteAllScoreTask(deleteIds);
    }

    private void deleteAllScoreTask(Set<Long> deleteIds) {
        if (deleteIds.size() > 0) {
            this.deleteScoreTask("src_scoretask", "id", deleteIds);
            this.deleteScoreTask("src_scoresuggestionf7", "billid", deleteIds);
            this.deleteScoreTask("src_bidassess_tec", "scoretask", deleteIds);
            this.deleteScoreTask("src_aptituderesultf7", "scoretask", deleteIds);
            this.deleteScoreTask("src_aptituderesult2f7", "scoretask", deleteIds);
        }
    }

    private void deleteScoreTask(String entityName, String key, Set<Long> deleteIds) {
        QFilter qfilter = new QFilter(key, "in", deleteIds);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qfilter.toArray());
    }

    private void deleteBidOpenConfig(DynamicObject[] myTaskObjs, List<DynamicObject> bidOpenCfgList) {
        Set srcEntryIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        Set bidderIds = Arrays.asList(myTaskObjs).stream().filter(e -> e.getLong("srcentryid") > 0L).map(e -> e.getLong("bidder.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", srcEntryIds);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_bidopenconfig", (String)"scorer", (QFilter[])qfilter.toArray());
        if (rows == null || rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection scorerRows = row.getDynamicObjectCollection("scorer");
            Boolean isChanged = false;
            Iterator ite = scorerRows.iterator();
            while (ite.hasNext()) {
                DynamicObject scorerRow = (DynamicObject)ite.next();
                DynamicObject basedataObj = scorerRow.getDynamicObject("fbasedataid");
                Long scorerId = (Long)basedataObj.getPkValue();
                if (!bidderIds.contains(scorerId)) continue;
                ite.remove();
                isChanged = true;
            }
            if (!isChanged.booleanValue()) continue;
            bidOpenCfgList.add(row);
        }
    }

    private void saveResult(DynamicObject[] myTaskObjs, List<DynamicObject> bidOpenCfgList) {
        try (TXHandle h = TX.required();){
            try {
                PdsCommonUtils.saveDynamicObjects(myTaskObjs);
                PdsCommonUtils.saveDynamicObjects(bidOpenCfgList);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }
}

