/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.nodehandler;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodehandler.PdsNodeUserContext;

public abstract class PdsNodeUserHandler {
    public abstract void getNodeCreator(PdsNodeUserContext var1);

    public abstract void getNodeModifier(PdsNodeUserContext var1);

    public abstract void getNodeSubmitter(PdsNodeUserContext var1);

    public abstract void getNodeUnSubmitter(PdsNodeUserContext var1);

    public abstract void getNodeAuditor(PdsNodeUserContext var1);

    public abstract void getNodeUnAuditor(PdsNodeUserContext var1);

    public abstract void getNodeTecScorer(PdsNodeUserContext var1);

    public abstract void getNodeBizScorer(PdsNodeUserContext var1);

    public abstract void getNodeFlowUser(PdsNodeUserContext var1);

    public void getNodeUserData(PdsNodeUserContext context) {
        this.getNodeCreator(context);
        this.getNodeModifier(context);
        this.getNodeSubmitter(context);
        this.getNodeUnSubmitter(context);
        this.getNodeAuditor(context);
        this.getNodeUnAuditor(context);
        this.getNodeTecScorer(context);
        this.getNodeBizScorer(context);
        this.getNodeFlowUser(context);
    }

    public String getNodeUserString(PdsNodeUserContext context) {
        String bizStatus = context.getBillObj().getString("bizstatus");
        if (ProcessStatusEnums.CLOSED.getValue().equals(bizStatus) || ProcessStatusEnums.TERMINATED.getValue().equals(bizStatus)) {
            return null;
        }
        this.getNodeUserData(context);
        List<DynamicObject> userObjs = context.getUserList();
        if (userObjs == null || userObjs.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject userObj : userObjs) {
            sb.append(userObj.get("number"));
            sb.append('-');
            sb.append(userObj.get("name"));
            sb.append(',');
        }
        int index = sb.toString().lastIndexOf(44);
        return sb.substring(0, index);
    }

    public static String getBillStatus(PdsNodeUserContext context) {
        String billStatus = context.getBillObj().getString("billstatus");
        if (billStatus == null) {
            return "Z";
        }
        if ("".equals(billStatus.trim())) {
            return "A";
        }
        return billStatus;
    }

    public static String getBizStatus(PdsNodeUserContext context) {
        String bizStatus = context.getBillObj().getString("bizstatus");
        if (bizStatus == null) {
            return "A";
        }
        if ("".equals(bizStatus.trim())) {
            return "A";
        }
        return bizStatus;
    }

    public static DynamicObject getBillUser(PdsNodeUserContext context, String userType) {
        DynamicObject userObj = context.getBillObj().getDynamicObject(userType);
        if (userObj == null || SrmCommonUtil.getPkValue((DynamicObject)userObj) == 0L) {
            return null;
        }
        return userObj;
    }

    public static void addUserList(PdsNodeUserContext context, DynamicObject userObj) {
        if (userObj != null) {
            List<DynamicObject> userList = context.getUserList();
            if (userList == null) {
                userList = new ArrayList<DynamicObject>(8);
            }
            userList.add(userObj);
            context.setUserList(userList);
        }
    }
}

