/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.nodehandler;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.nodehandler.PdsNodeUserContext;
import kd.scm.pds.common.nodehandler.PdsNodeUserHandler;

public class PdsNodeUserHandlerFactory {
    private Map<String, String> PLUGINNAME_MAP = new HashMap<String, String>();
    private Map<String, PdsNodeUserHandler> INSTANCE_MAP = new HashMap<String, PdsNodeUserHandler>();

    public PdsNodeUserHandler getStrategyInstance(PdsNodeUserContext context) {
        PdsNodeUserHandler nodeUserHandler = null;
        String nodeId = context.getEntityName();
        String strategyPlugin = this.PLUGINNAME_MAP.get(nodeId);
        if (strategyPlugin == null) {
            strategyPlugin = PdsNodeUserHandlerFactory.getPluginName(context);
            this.PLUGINNAME_MAP.put(nodeId, strategyPlugin);
        }
        if (strategyPlugin == null) {
            return nodeUserHandler;
        }
        nodeUserHandler = this.INSTANCE_MAP.get(strategyPlugin);
        if (nodeUserHandler != null) {
            return nodeUserHandler;
        }
        try {
            nodeUserHandler = (PdsNodeUserHandler)Class.forName(strategyPlugin).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        if (nodeUserHandler instanceof PdsNodeUserHandler) {
            this.INSTANCE_MAP.put(strategyPlugin, nodeUserHandler);
            return nodeUserHandler;
        }
        return null;
    }

    private PdsNodeUserHandlerFactory() {
    }

    public static PdsNodeUserHandlerFactory getInstance() {
        return SingletonHolder.SINSTANCE;
    }

    public static String getPluginName(PdsNodeUserContext context) {
        QFilter qFilter = new QFilter("bizobject.number", "=", (Object)context.getEntityName()).and("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("enable", "=", (Object)"1").and("userplugin", "is not null", (Object)"");
        DynamicObject node = QueryServiceHelper.queryOne((String)"pds_biznode", (String)"userplugin", (QFilter[])new QFilter[]{qFilter});
        if (node == null || "".equals(node.getString("userplugin"))) {
            return "kd.scm.pds.common.nodehandler.PdsNodeUserHandlerStand";
        }
        return node.getString("userplugin");
    }

    private static class SingletonHolder {
        private static final PdsNodeUserHandlerFactory SINSTANCE = new PdsNodeUserHandlerFactory();

        private SingletonHolder() {
        }
    }
}

