/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.nodehandler;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodehandler.PdsNodeUserContext;
import kd.scm.pds.common.nodehandler.PdsNodeUserHandler;

public class PdsNodeUserHandlerStand
extends PdsNodeUserHandler {
    @Override
    public void getNodeCreator(PdsNodeUserContext context) {
        String billStatus = PdsNodeUserHandler.getBillStatus(context);
        if (!"A".equals(billStatus)) {
            return;
        }
        if ("src_bidassess".equals(context.getEntityName()) || "src_scorertask".equals(context.getEntityName()) || "src_compare".equals(context.getEntityName())) {
            return;
        }
        DynamicObject unSubmitterObj = PdsNodeUserHandler.getBillUser(context, "unsubmitter");
        DynamicObject unAuditorObj = PdsNodeUserHandler.getBillUser(context, "unauditor");
        if (unSubmitterObj != null || unAuditorObj != null) {
            return;
        }
        DynamicObject userObj = PdsNodeUserHandler.getBillUser(context, "creator");
        PdsNodeUserHandler.addUserList(context, userObj);
    }

    @Override
    public void getNodeModifier(PdsNodeUserContext context) {
    }

    @Override
    public void getNodeSubmitter(PdsNodeUserContext context) {
        DynamicObject billObj = context.getBillObj();
        if (null == billObj) {
            return;
        }
        if (WorkflowServiceHelper.inProcess((String)String.valueOf(billObj.getPkValue()))) {
            return;
        }
        String billStatus = PdsNodeUserHandler.getBillStatus(context);
        if (!"B".equals(billStatus)) {
            return;
        }
        if ("src_bidassess".equals(context.getEntityName()) || "src_scorertask".equals(context.getEntityName()) || "src_compare".equals(context.getEntityName())) {
            return;
        }
        DynamicObject userObj = PdsNodeUserHandler.getBillUser(context, "submitter");
        PdsNodeUserHandler.addUserList(context, userObj);
    }

    @Override
    public void getNodeUnSubmitter(PdsNodeUserContext context) {
        String billStatus = PdsNodeUserHandler.getBillStatus(context);
        if (!"A".equals(billStatus)) {
            return;
        }
        if ("src_bidassess".equals(context.getEntityName()) || "src_scorertask".equals(context.getEntityName()) || "src_compare".equals(context.getEntityName())) {
            return;
        }
        DynamicObject unSubmitterObj = PdsNodeUserHandler.getBillUser(context, "unsubmitter");
        DynamicObject unAuditorObj = PdsNodeUserHandler.getBillUser(context, "unauditor");
        if (unSubmitterObj != null && unAuditorObj == null) {
            PdsNodeUserHandler.addUserList(context, unSubmitterObj);
        }
    }

    @Override
    public void getNodeAuditor(PdsNodeUserContext context) {
        if ("src_bidassess".equals(context.getEntityName()) || "src_scorertask".equals(context.getEntityName()) || "src_compare".equals(context.getEntityName())) {
            return;
        }
        String billStatus = PdsNodeUserHandler.getBillStatus(context);
        if ("C".equals(billStatus)) {
            context.setUserList(null);
        }
    }

    @Override
    public void getNodeUnAuditor(PdsNodeUserContext context) {
        String billStatus = PdsNodeUserHandler.getBillStatus(context);
        if (!"A".equals(billStatus)) {
            return;
        }
        if ("src_bidassess".equals(context.getEntityName()) || "src_scorertask".equals(context.getEntityName()) || "src_compare".equals(context.getEntityName())) {
            return;
        }
        DynamicObject unAuditorObj = PdsNodeUserHandler.getBillUser(context, "unauditor");
        if (unAuditorObj != null) {
            PdsNodeUserHandler.addUserList(context, unAuditorObj);
        }
    }

    @Override
    public void getNodeTecScorer(PdsNodeUserContext context) {
        if (!"src_bidassess".equals(context.getEntityName()) && !"src_scorertask".equals(context.getEntityName())) {
            return;
        }
        String bizStatus = PdsNodeUserHandler.getBizStatus(context);
        if (ProcessStatusEnums.CLOSED.getValue().equals(bizStatus) || ProcessStatusEnums.TERMINATED.getValue().equals(bizStatus)) {
            return;
        }
        QFilter scorerFilters = new QFilter("billid", "=", context.getBillObj().getPkValue()).and(new QFilter("indextype.basetype", "=", (Object)"1").or("indextype.basetype", "=", (Object)"3"));
        DynamicObject[] scorerRows = BusinessDataServiceHelper.load((String)"src_bidopenconfig", (String)"scorer", (QFilter[])scorerFilters.toArray());
        if (scorerRows == null || scorerRows.length == 0) {
            return;
        }
        QFilter scoredFilters = new QFilter("project.id", "=", context.getBillObj().getPkValue()).and("scorerscored", "=", (Object)"1");
        scoredFilters.and("billid.bizstatus", "!=", (Object)"E");
        DynamicObjectCollection scoredRows = QueryServiceHelper.query((String)"src_scoretask_scorerf7", (String)"scorer.id", (QFilter[])scoredFilters.toArray());
        HashSet<Long> scoredSet = new HashSet<Long>(16);
        if (scoredRows != null && scoredRows.size() > 0) {
            for (DynamicObject scoredRow : scoredRows) {
                scoredSet.add(scoredRow.getLong("scorer.id"));
            }
        }
        HashSet<Long> scorerSet = new HashSet<Long>(16);
        for (DynamicObject scorerRow : scorerRows) {
            DynamicObjectCollection rows = (DynamicObjectCollection)scorerRow.get("scorer");
            if (rows == null || rows.size() == 0) continue;
            for (DynamicObject row : rows) {
                DynamicObject scorerObj = row.getDynamicObject("fbasedataid");
                long scorerId = SrmCommonUtil.getPkValue((DynamicObject)scorerObj);
                if (scoredSet.contains(scorerId) || !scorerSet.add(scorerId)) continue;
                PdsNodeUserHandler.addUserList(context, scorerObj);
            }
        }
    }

    @Override
    public void getNodeBizScorer(PdsNodeUserContext context) {
        QFilter scorerFilters;
        DynamicObject[] scorerRows;
        if (!"src_compare".equals(context.getEntityName())) {
            return;
        }
        String bizStatus = PdsNodeUserHandler.getBizStatus(context);
        if (ProcessStatusEnums.CLOSED.getValue().equals(bizStatus) || ProcessStatusEnums.TERMINATED.getValue().equals(bizStatus)) {
            return;
        }
        if (context.getBillObj().getBoolean("ismanualscore")) {
            if (QueryServiceHelper.exists((String)"src_manualscore_meta", (QFilter[])new QFilter("billid", "=", context.getBillObj().getPkValue()).toArray())) {
                context.setUserList(null);
                return;
            }
        } else if (!QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])new QFilter("billid", "=", context.getBillObj().getPkValue()).and("isbizopen", "=", (Object)"0").toArray())) {
            context.setUserList(null);
            return;
        }
        if ((scorerRows = BusinessDataServiceHelper.load((String)"src_bidopenconfig", (String)"scorer", (QFilter[])(scorerFilters = new QFilter("billid", "=", context.getBillObj().getPkValue()).and(new QFilter("indextype.basetype", "=", (Object)"2"))).toArray())) == null || scorerRows.length == 0) {
            return;
        }
        HashSet<Long> scorerSet = new HashSet<Long>(16);
        for (DynamicObject scorerRow : scorerRows) {
            DynamicObjectCollection rows = (DynamicObjectCollection)scorerRow.get("scorer");
            if (rows == null || rows.size() == 0) continue;
            for (DynamicObject row : rows) {
                DynamicObject scorerObj = row.getDynamicObject("fbasedataid");
                long scorerId = SrmCommonUtil.getPkValue((DynamicObject)scorerObj);
                if (!scorerSet.add(scorerId)) continue;
                PdsNodeUserHandler.addUserList(context, scorerObj);
            }
        }
    }

    @Override
    public void getNodeFlowUser(PdsNodeUserContext context) {
        String billId = String.valueOf(context.getBillObj().getPkValue());
        if (!WorkflowServiceHelper.inProcess((String)billId)) {
            return;
        }
        String billStatus = PdsNodeUserHandler.getBillStatus(context);
        if (ProcessStatusEnums.CLOSED.getValue().equals(billStatus) || ProcessStatusEnums.TERMINATED.getValue().equals(billStatus)) {
            return;
        }
        List approves = WorkflowServiceHelper.getApproverByBusinessKey((String)billId);
        if (CollectionUtils.isEmpty((Collection)approves)) {
            return;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"bos_user", (boolean)true);
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)approves)});
        users.forEach(user -> PdsNodeUserHandler.addUserList(context, user));
    }
}

