/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.nodestatus;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusData;
import kd.scm.pds.common.util.SrcDateUtils;

public abstract class SrcNodeStatusHandler
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract void getNodeStatusFilter(SrcNodeStatusContext var1);

    public abstract void getNodeStatusFields(SrcNodeStatusContext var1);

    public void getNodeStatusRows(SrcNodeStatusContext context) {
        if (context.getFilters() == null) {
            context.setRows(null);
        } else if (null != context.getNodeObj()) {
            String entityName = context.getNodeObj().getDynamicObject("biznode").getString("bizobject.number");
            DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)context.getSelectFields(), (QFilter[])context.getFilters(), (String)context.getOrderBy());
            context.setRows(rows);
        } else {
            context.setRows(null);
        }
    }

    public void getNodeStatusData(SrcNodeStatusContext context) {
        context.setBizStatus("A");
        DynamicObjectCollection rows = context.getRows();
        if (rows == null || rows.size() == 0) {
            return;
        }
        List<SrcNodeStatusData> nodeList = context.getNodeList();
        for (DynamicObject row : rows) {
            try {
                SrcNodeStatusData nodeData = new SrcNodeStatusData();
                nodeData.setNodeSeq(context.getNodeSeq());
                nodeData.setNodeName(this.getNodeName(context, row));
                nodeData.setEntityName(context.getNodeObj().getDynamicObject("biznode").getString("bizobject.number"));
                nodeData.setBillId(row.getLong("id"));
                nodeData.setBillNo(row.getString("billno"));
                nodeData.setBillName(row.getString("billname"));
                nodeData.setBillDate(this.getBillDate(context, row));
                nodeData.setEndDate(this.getEndDate(context, row));
                nodeData.setRemark(this.getRemark(context, row));
                nodeData.setBizStatus(this.getBizStatus(context, row));
                context.setBizStatus(this.getBizStatus(context, row));
                nodeList.add(nodeData);
            }
            catch (Exception exception) {}
        }
        context.setNodeList(nodeList);
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        return "A".equals(row.getString("bizstatus")) ? "B" : row.getString("bizstatus");
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        return context.getNodeObj().getString("biznode.name");
    }

    public String getRemark(SrcNodeStatusContext context, DynamicObject row) {
        return row.getString("remark");
    }

    public Date getBillDate(SrcNodeStatusContext context, DynamicObject row) {
        return row.getDate("billdate");
    }

    public Date getEndDate(SrcNodeStatusContext context, DynamicObject row) {
        if (null != row.getDate("enddate") && row.getDate("enddate").before(SrcDateUtils.getMaxDate())) {
            return row.getDate("enddate");
        }
        return null;
    }

    public void nodeStatusHandle(SrcNodeStatusContext context) {
        this.getNodeStatusFilter(context);
        this.getNodeStatusFields(context);
        this.getNodeStatusRows(context);
        this.getNodeStatusData(context);
    }
}

