/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.noticetpl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.BizLog;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.noticetpl.IPdsNoticeContentHandle;
import kd.scm.pds.common.noticetpl.context.PdsNoticeContentContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PdsNoticeContentHandle
implements IPdsNoticeContentHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public String handle(PdsNoticeContentContext context) {
        return this.previewTemplate(context);
    }

    public String previewTemplate(PdsNoticeContentContext context) {
        String contentTpl = context.getContentTpl();
        if (contentTpl == null || "".equals(contentTpl)) {
            return null;
        }
        DynamicObject billObj = context.getBillObj();
        StringBuilder entryReplaceKey = new StringBuilder();
        if (context.isEntry()) {
            String entryKey = billObj.getDataEntityType().getName();
            entryReplaceKey.append(entryKey).append(".");
        }
        DynamicObject getValObj = billObj;
        String currEntityKey = context.getCurrEntityKey();
        String regex = "\\{[^}]*\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(contentTpl);
        while (m.find()) {
            String fieldContext;
            String g = m.group();
            String realPro = fieldContext = g.substring(1, g.length() - 1);
            String target = null;
            Object attribute = null;
            String fieldFormat = null;
            String entityKey = null;
            try {
                String[] tdProText = fieldContext.split("\\$");
                if (tdProText.length <= 1 || !(entityKey = tdProText[0]).equals(currEntityKey)) continue;
                fieldContext = tdProText[1];
                if (fieldContext.indexOf(44) != -1) {
                    String[] fields = fieldContext.split("\\,");
                    target = fields[0];
                    fieldFormat = fields[1];
                } else {
                    target = fieldContext;
                }
                if (context.isEntry()) {
                    if (target.contains(entryReplaceKey.toString())) {
                        target = target.replaceFirst(entryReplaceKey.toString(), "");
                    } else {
                        getValObj = (DynamicObject)billObj.getParent();
                    }
                }
                if (target.indexOf(46) != -1) {
                    String[] subTarget = target.split("\\.");
                    DynamicObject obj = getValObj.getDynamicObject(subTarget[0]);
                    if (obj != null) {
                        attribute = obj.get(subTarget[1]);
                    }
                } else {
                    ComboProp comboPro;
                    String comboName;
                    attribute = getValObj.get(target);
                    DynamicProperty property = getValObj.getDynamicObjectType().getProperty(target);
                    if (null != property && property instanceof ComboProp && StringUtils.isNotEmpty((String)(comboName = (comboPro = (ComboProp)property).getItemByName(String.valueOf(attribute))))) {
                        attribute = comboName;
                    }
                }
                attribute = this.getVal(getValObj, attribute, fieldFormat);
                String replaceAttr = null == attribute ? "" : StringEscapeUtils.escapeHtml((String)String.valueOf(attribute));
                contentTpl = contentTpl.replace("{" + realPro + "}", replaceAttr);
            }
            catch (Exception e) {
                BizLog.log((String)("###PdsNoticeContentHandle {" + realPro + "} excption:" + e.getMessage()));
                contentTpl = contentTpl.replace("{" + realPro + "}", "");
            }
        }
        return contentTpl;
    }

    public Object getVal(DynamicObject obj, Object attribute, String fieldFormat) {
        if (attribute instanceof DynamicObject) {
            if (((DynamicObject)attribute).get("name") != null) {
                attribute = ((DynamicObject)attribute).get("name");
            }
        } else if (attribute instanceof BigDecimal) {
            int scale = fieldFormat == null ? ((BigDecimal)attribute).scale() : Integer.parseInt(fieldFormat);
            attribute = ((BigDecimal)attribute).setScale(scale, 4);
        } else if (attribute instanceof Date) {
            attribute = null != fieldFormat && ("yyyy-MM-dd".equals(fieldFormat) || "yyyy-MM-dd HH:mm".equals(fieldFormat) || "yyyy-MM-dd HH:mm:ss".equals(fieldFormat)) ? DateUtil.date2str((Date)((Date)attribute), (String)fieldFormat) : DateUtil.date2str((Date)((Date)attribute), (String)"yyyy-MM-dd HH:mm:ss");
        } else if (attribute instanceof Boolean) {
            attribute = (Boolean)attribute != false ? ResManager.loadKDString((String)"\u662f", (String)"PdsNoticeContentHandle_0", (String)"scm-pds-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PdsNoticeContentHandle_1", (String)"scm-pds-common", (Object[])new Object[0]);
        }
        return attribute;
    }
}

