/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.noticetpl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.noticetpl.IPdsNoticeInterface;
import kd.scm.pds.common.noticetpl.IPdsNoticeTplInitDataHandle;
import kd.scm.pds.common.noticetpl.PdsNoticeInitDataHandle;
import kd.scm.pds.common.noticetpl.PdsNoticeTplContext;
import kd.scm.pds.common.noticetpl.context.PdsNoticeContentContext;
import kd.scm.pds.common.noticetpl.context.PdsNoticeCustomDataContext;
import kd.scm.pds.common.util.PdsNoticeTplUtil;
import kd.scm.pds.common.util.TemplateUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PdsNoticeContentStand
implements IPdsNoticeInterface {
    private static final long serialVersionUID = 1L;

    @Override
    public String decorateContent(PdsNoticeTplContext noticeTplContext) {
        String contentTpl = noticeTplContext.getContentTpl();
        if (null == contentTpl || contentTpl.trim().length() == 0) {
            return "";
        }
        this.initHandleData(noticeTplContext);
        String content = contentTpl;
        DynamicObject billObj = null;
        String nodeEntityKey = noticeTplContext.getEntityKey();
        Set<String> entityKeySet = this.getEntityKeySetByTpl(content);
        PdsNoticeContentContext contentContext = new PdsNoticeContentContext();
        for (String entityKey : entityKeySet) {
            billObj = !nodeEntityKey.equals(entityKey) ? this.getCompData(noticeTplContext, entityKey) : noticeTplContext.getBillObj();
            Document dcument = Jsoup.parse((String)content);
            Elements tableElements = dcument.select("table");
            for (Element tableEle : tableElements) {
                Elements elements = tableEle.select("tr");
                if (elements.size() <= 1) continue;
                Element element = (Element)elements.get(1);
                this.decorateTableContent(noticeTplContext, element, billObj, entityKey);
            }
            Map<String, String> customDataMap = this.getCustomHeadData(noticeTplContext, entityKey);
            String replaceContent = dcument.body().html();
            if (customDataMap.size() > 0) {
                replaceContent = this.replaceContent(customDataMap, replaceContent, false);
            }
            if (null != billObj) {
                contentContext.setContentTpl(replaceContent).setCurrEntityKey(entityKey).setBillObj(billObj).setIsEntry(false);
                content = noticeTplContext.getContentHandle().handle(contentContext);
                continue;
            }
            content = replaceContent;
        }
        return content;
    }

    public void decorateTableContent(PdsNoticeTplContext noticeTplContext, Element rowElement, DynamicObject billObj, String entityKey) {
        String rowHtml = rowElement.outerHtml();
        entityKey = null == billObj ? entityKey : billObj.getDynamicObjectType().getName();
        Set<String> tableEntityKeySet = this.getEntityKeySetByTpl(rowHtml);
        if (tableEntityKeySet.add(entityKey)) {
            return;
        }
        Set<String> entryEntityKeySet = this.getEntryKeySetByTpl(rowHtml);
        String entryKey = null;
        if (entryEntityKeySet.size() > 1) {
            return;
        }
        Iterator<String> iterator = entryEntityKeySet.iterator();
        while (iterator.hasNext()) {
            String string;
            entryKey = string = iterator.next();
        }
        List<Map<String, String>> customTableDataList = this.getCustomTableData(noticeTplContext, entityKey, entryKey);
        if (customTableDataList.size() > 0) {
            for (Map<String, String> map : customTableDataList) {
                String content = this.replaceContent(map, rowHtml, true);
                rowElement.after(content);
            }
        } else if (null != billObj) {
            Map<String, DynamicObject> map = this.getEntryDataByExtFilter(noticeTplContext, billObj, entityKey, entryKey);
            DynamicObjectCollection dynamicObjectCollection = this.getEntryData(billObj, entryKey);
            if (null == dynamicObjectCollection) {
                return;
            }
            PdsNoticeContentContext contentContext = new PdsNoticeContentContext();
            int count = dynamicObjectCollection.size();
            for (int i = 0; i < count; ++i) {
                if (null != map && null == map.get(String.valueOf(((DynamicObject)dynamicObjectCollection.get(i)).getPkValue()))) continue;
                contentContext.setContentTpl(rowHtml).setCurrEntityKey(entityKey).setBillObj((DynamicObject)dynamicObjectCollection.get(i)).setIsEntry(true);
                String content = noticeTplContext.getContentHandle().handle(contentContext);
                rowElement.before(content);
            }
        }
        rowElement.remove();
    }

    private Map<String, DynamicObject> getEntryDataByExtFilter(PdsNoticeTplContext noticeTplContext, DynamicObject billObj, String entityKey, String entryKey) {
        String tplNumber = noticeTplContext.getNoticeTpl().getString("number");
        String filterNumber = tplNumber + "-" + entityKey;
        QFilter extFilter = ExtFilterUtils.getExtQFilters("pds_extfilter", filterNumber, null, null);
        Map entryIdMap = null;
        if (null != extFilter) {
            StringBuilder selectFields = new StringBuilder("id");
            selectFields.append(",").append(entryKey).append(".id as entryid");
            extFilter.and("id", "=", billObj.getPkValue());
            DynamicObjectCollection cols = QueryServiceHelper.query((String)entityKey, (String)selectFields.toString(), (QFilter[])extFilter.toArray());
            entryIdMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)cols, (String)"entryid");
        }
        return entryIdMap;
    }

    public Map<String, String> getCustomHeadData(PdsNoticeTplContext noticeTplContext, String entityKey) {
        Map<String, String> customData = null;
        if (null != noticeTplContext.getCustomDataHandle()) {
            PdsNoticeCustomDataContext dataContext = new PdsNoticeCustomDataContext();
            dataContext.setNoticeTplContext(noticeTplContext).setEntityKey(entityKey);
            customData = noticeTplContext.getCustomDataHandle().getCustomHeadData(dataContext);
        }
        if (null == customData) {
            customData = Collections.emptyMap();
        }
        return customData;
    }

    public List<Map<String, String>> getCustomTableData(PdsNoticeTplContext noticeTplContext, String entityKey, String entryKey) {
        List<Map<String, String>> customTableData = null;
        if (null != noticeTplContext.getCustomDataHandle()) {
            PdsNoticeCustomDataContext dataContext = new PdsNoticeCustomDataContext();
            dataContext.setNoticeTplContext(noticeTplContext).setEntityKey(entityKey).setEntryKey(entryKey);
            customTableData = noticeTplContext.getCustomDataHandle().getCustomTableData(dataContext);
        }
        if (null == customTableData) {
            customTableData = Collections.emptyList();
        }
        return customTableData;
    }

    public String replaceContent(Map<String, String> customData, String rowHtml, boolean isTable) {
        for (Map.Entry<String, String> customDataEntry : customData.entrySet()) {
            String val = customDataEntry.getValue();
            rowHtml = rowHtml.replace("{" + customDataEntry.getKey() + "}", null == val ? "" : val);
        }
        return rowHtml;
    }

    public DynamicObject getCompData(PdsNoticeTplContext noticeTplContext, String compKey) {
        DynamicObject billObj = noticeTplContext.getBillObj();
        DynamicObject compData = null;
        try {
            compData = TemplateUtil.getCompData(billObj, compKey);
        }
        catch (Exception e) {
            BizLog.log((String)("cont find compData : " + e.getMessage()));
        }
        return compData;
    }

    public DynamicObjectCollection getEntryData(DynamicObject billObj, String entryKey) {
        Object data;
        DynamicObjectCollection cols = null;
        DynamicProperty pro = billObj.getDynamicObjectType().getProperty(entryKey);
        if (null != pro && null != (data = billObj.get(entryKey)) && data instanceof DynamicObjectCollection) {
            cols = billObj.getDynamicObjectCollection(entryKey);
        }
        return cols;
    }

    public Set<String> getEntityKeySetByTpl(String contentTpl) {
        return PdsNoticeTplUtil.getEntityKeySetByTpl(contentTpl);
    }

    public Set<String> getEntryKeySetByTpl(String contentTpl) {
        return PdsNoticeTplUtil.getEntryKeySetByTpl(contentTpl);
    }

    public void initHandleData(PdsNoticeTplContext noticeTplContext) {
        IPdsNoticeTplInitDataHandle initHandle = (IPdsNoticeTplInitDataHandle)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(IPdsNoticeTplInitDataHandle.class.getSimpleName(), null);
        if (null == initHandle) {
            initHandle = new PdsNoticeInitDataHandle();
        }
        initHandle.initData(noticeTplContext);
    }
}

