/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidTypeEnums;
import kd.scm.pds.common.opencontrol.IPdsOpenControlHandler;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsOpenContextInit
implements IPdsOpenControlHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsOpenControlContext context) {
        if (context.getProjectId() == 0L && context.getProjectObj() != null) {
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        }
        if (context.getProjectId() == 0L && context.getBillObj() != null) {
            context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()));
        }
        this.getOpentyepBidtypeMap(context);
        Map<Long, List<DynamicObject>> bizRoleMap = PdsOpenControlUtils.getBizRoleMap(context);
        context.setBizRoleMap(bizRoleMap);
        Set<Long> packageSet = PdsOpenControlUtils.getPackageSet(context);
        context.setPackageSet(packageSet);
        context.setExistEncryptKeys(PdsOpenControlUtils.getExistKeySet(context, "pds_encryptdetail"));
        context.setExistSupEncryptKeys(PdsOpenControlUtils.getExistKeySet(context, "pds_supencryptdetail"));
        context.setExistOpenKeys(PdsOpenControlUtils.getExistKeySet(context, "pds_bidopendetail"));
        Map<Long, List<DynamicObject>> supplierMap = PdsOpenControlUtils.getSupplierMap(context);
        context.setSupplierMap(supplierMap);
        DynamicObject baseInfoObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_project_base");
        DynamicObject aptSchemeObj = baseInfoObj.getDynamicObject("aptscheme");
        context.setAptSchemeObj(aptSchemeObj);
        DynamicObject tecSchemeObj = baseInfoObj.getDynamicObject("tecscheme");
        context.setTecSchemeObj(tecSchemeObj);
        DynamicObject bizSchemeObj = baseInfoObj.getDynamicObject("bizscheme");
        context.setBizSchemeObj(bizSchemeObj);
        context.setOpenBySupplier(PdsCommonUtils.isOpenBySupplier(context.getBillObj()));
        context.setManageType(baseInfoObj.getString("managetype"));
    }

    protected void getOpentyepBidtypeMap(PdsOpenControlContext context) {
        HashSet<Long> aptSet = new HashSet<Long>();
        aptSet.add(BidTypeEnums.APT.getId());
        aptSet.add(BidTypeEnums.APT2.getId());
        context.getOpentypeBidtypeMap().put("1", aptSet);
        HashSet<Long> tecSet = new HashSet<Long>();
        tecSet.add(BidTypeEnums.TEC.getId());
        tecSet.add(BidTypeEnums.OTH.getId());
        tecSet.add(BidTypeEnums.SYN.getId());
        context.getOpentypeBidtypeMap().put("2", tecSet);
        HashSet<Long> bizSet = new HashSet<Long>();
        bizSet.add(BidTypeEnums.BIZ.getId());
        bizSet.add(BidTypeEnums.SYN.getId());
        context.getOpentypeBidtypeMap().put("3", bizSet);
    }
}

