/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.mytask.ISrcMyTaskHandler;
import kd.scm.pds.common.mytask.ISrcMyTaskOperationHandler;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.IPdsOpenControlHandler;
import kd.scm.pds.common.opencontrol.PdsOpenContextInit;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.control.IPdsOpenControlValidator;
import kd.scm.pds.common.opencontrol.control.PdsNeedOpenCtlValidator;
import kd.scm.pds.common.opencontrol.create.IPdsControlDetailCreater;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsOpenControlFacade {
    public static PdsOpenControlContext initContext(ExtPluginContext context) {
        PdsOpenControlContext ctlContext = new PdsOpenControlContext();
        ctlContext.setBillObj(context.getBillObj());
        ctlContext.setProjectObj(context.getProjectObj());
        ctlContext.setProjectId(context.getProjectId());
        ctlContext.setEntityId(context.getEntityId());
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(PdsOpenContextInit.class.getSimpleName(), PdsOpenContextInit.class.getName());
        for (IPdsOpenControlHandler handler : handlers) {
            handler.process(ctlContext);
        }
        return ctlContext;
    }

    public static void createControlDetail(ExtPluginContext context) {
        PdsOpenControlContext ctlContext = PdsOpenControlFacade.initContext(context);
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsControlDetailCreater.class.getSimpleName(), null);
        for (IPdsOpenControlHandler handler : handlers) {
            handler.process(ctlContext);
        }
    }

    public static Set<String> getTodoTaskSet(DynamicObject myTaskObj, String number) {
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setMyTaskObj(myTaskObj);
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, null);
        for (ISrcMyTaskOperationHandler handler : handlers) {
            handler.process(context);
        }
        return context.getTodoTaskSet();
    }

    public static boolean isProjectTaskEnd(DynamicObject myTaskObj) {
        if (myTaskObj.getBoolean("isterminate")) {
            return true;
        }
        boolean isOpenControl = myTaskObj.getBoolean("project.isopencontrol");
        String openStatus = myTaskObj.getString("project.openstatus");
        if (BidOpenStatusEnums.DECISION.getValue().equals(openStatus) || BidOpenStatusEnums.ARCHIVED.getValue().equals(openStatus) || BidOpenStatusEnums.TERMINATED.getValue().equals(openStatus)) {
            return true;
        }
        return !isOpenControl || !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.BIZOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.OPEN.getValue().equals(openStatus);
    }

    public static void taskVerify(SrcMyTaskContext context, String number) {
        List verifiers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, null);
        for (ISrcMyTaskHandler verifier : verifiers) {
            verifier.process(context);
        }
    }

    public static void taskProcess(SrcMyTaskContext context, String number) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, null);
        for (ISrcMyTaskHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static PdsOpenControlContext openControlValidate(DynamicObject billObj, String operationKey, Set<Long> openPackageIds, Set<Long> openSupplierIds, Map<Object, Object> paramMap) {
        PdsOpenControlContext context = new PdsOpenControlContext();
        context.setBillObj(billObj);
        context.setProjectObj(billObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
        context.setOperationKey(operationKey);
        context.setOpenPackageIds(openPackageIds);
        context.setOpenSupplierIds(openSupplierIds);
        context.setParamMap(paramMap);
        context.setOpenType(PdsOpenControlUtils.getOpenTypeByOpkey(operationKey));
        context.setOpenBySupplier(PdsCommonUtils.isOpenBySupplier(context.getBillObj()));
        context.setManageType(billObj.getString("managetype"));
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(IPdsOpenControlValidator.class.getSimpleName(), null);
        for (IPdsOpenControlValidator handler : handlers) {
            handler.process(context);
            if (context.isNeedOpenCtlValidate()) continue;
            return context;
        }
        return context;
    }

    public static PdsOpenControlContext isNeedOpenCtlValidate(DynamicObject billObj, DynamicObject baseInfoObj) {
        PdsOpenControlContext context = new PdsOpenControlContext();
        context.setBillObj(billObj);
        context.setProjectObj(billObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
        context.setBaseInfoObj(baseInfoObj);
        IPdsOpenControlValidator handler = (IPdsOpenControlValidator)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(PdsNeedOpenCtlValidator.class.getSimpleName(), PdsNeedOpenCtlValidator.class.getName());
        handler.process(context);
        return context;
    }
}

