/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.RandomUtils;
import kd.scm.pds.common.util.SupplierUtil;
import org.apache.commons.lang3.StringUtils;

public class PdsOpenControlUtils {
    public static void deleteEncryptDetail(ExtPluginContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("entityid", "=", (Object)context.getEntityId());
        DeleteServiceHelper.delete((String)"pds_encryptdetail", (QFilter[])qfilter.toArray());
    }

    public static void deleteSupEncryptDetail(ExtPluginContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("entityid", "=", (Object)context.getEntityId());
        DeleteServiceHelper.delete((String)"pds_supencryptdetail", (QFilter[])qfilter.toArray());
    }

    public static void deleteBidOpenDetail(ExtPluginContext context, Set<Long> supplierIds) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("entityid", "=", (Object)context.getEntityId());
        if (null != supplierIds && supplierIds.size() > 0) {
            qfilter.and("supplier", "in", supplierIds);
        }
        DeleteServiceHelper.delete((String)"pds_bidopendetail", (QFilter[])qfilter.toArray());
    }

    public static void createEncryptDetail(PdsOpenControlContext context, long packageId, long supplierId, long bidderId, String openType, List<DynamicObject> objList, boolean isAutoEncrypt) {
        String key = PdsOpenControlUtils.buildKey(packageId, supplierId, bidderId, openType);
        if (context.getExistEncryptKeys().add(key)) {
            DynamicObject newObj = PdsOpenControlUtils.newDynamicObject(context, "pds_encryptdetail", packageId, supplierId, bidderId, openType);
            if (isAutoEncrypt) {
                PdsOpenControlUtils.autoEncrypt(context, newObj, bidderId, 0L);
            }
            objList.add(newObj);
        }
    }

    public static void createSupEncryptDetail(PdsOpenControlContext context, long packageId, long supplierId, long bidderId, String openType, List<DynamicObject> objList, boolean isAutoEncrypt) {
        String key = PdsOpenControlUtils.buildKey(packageId, supplierId, bidderId, openType);
        if (context.getExistSupEncryptKeys().add(key)) {
            DynamicObject newObj = PdsOpenControlUtils.newDynamicObject(context, "pds_supencryptdetail", packageId, supplierId, bidderId, openType);
            if (context.getSupplierusers().size() > 0) {
                MultiBasedataUtils.setMultiBasedataForObject(newObj, context.getSupplierusers(), "supplieruser");
            }
            if (isAutoEncrypt) {
                PdsOpenControlUtils.autoEncrypt(context, newObj, 0L, supplierId);
            }
            objList.add(newObj);
        }
    }

    public static void createBidOpenDetail(PdsOpenControlContext context, long packageId, long supplierId, long bidderId, String openType, List<DynamicObject> objList) {
        String key = PdsOpenControlUtils.buildKey(packageId, supplierId, bidderId, openType);
        if (context.getExistOpenKeys().add(key)) {
            DynamicObject newObj = PdsOpenControlUtils.newDynamicObject(context, "pds_bidopendetail", packageId, supplierId, bidderId, openType);
            objList.add(newObj);
        }
    }

    public static DynamicObject newDynamicObject(PdsOpenControlContext context, String entityName, long packageId, long supplierId, long bidderId, String openType) {
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        PdsCommonUtils.setPrimaryKey(newObj);
        newObj.set("project", (Object)context.getProjectId());
        newObj.set("package", (Object)packageId);
        newObj.set("supplier", (Object)supplierId);
        newObj.set("bidder", (Object)bidderId);
        newObj.set("opentype", (Object)openType);
        newObj.set("entityid", (Object)context.getEntityId());
        return newObj;
    }

    public static void autoEncrypt(PdsOpenControlContext context, DynamicObject newObj, long bidderId, long supplierId) {
        long codeId;
        String encryptCode = null;
        long l = codeId = bidderId > 0L ? bidderId : supplierId;
        if (codeId > 0L) {
            encryptCode = context.getCodeMap().get(codeId);
            if (null == encryptCode) {
                encryptCode = RandomUtils.generateRandomCode(6, new HashSet<String>());
                context.getCodeMap().put(codeId, encryptCode);
            }
        } else {
            encryptCode = RandomUtils.generateRandomCode(6, new HashSet<String>());
        }
        newObj.set("isencrypt", (Object)"1");
        newObj.set("encryptdate", (Object)TimeServiceHelper.now());
        newObj.set("encryptcode", (Object)EncrypterFactory.getAesEncrypter().encrypt(encryptCode));
        newObj.set("encryptcode2", (Object)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u8bc1\u7801\uff1a%1$s", (String)"PdsOpenControlUtils_2", (String)"scm-pds-common", (Object[])new Object[0]), encryptCode));
    }

    public static String buildKey(long packageId, long supplierId, long bidderId, String openType) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(packageId)).append('_');
        sb.append(String.valueOf(supplierId)).append('_');
        sb.append(String.valueOf(bidderId)).append('_');
        sb.append(openType);
        return sb.toString();
    }

    public static Map<Long, List<DynamicObject>> getBizRoleMap(ExtPluginContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("bizrole", ">", (Object)0);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_memberclarify", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("bizrole.id")));
    }

    public static Map<Long, List<DynamicObject>> getSupplierMap(PdsOpenControlContext context) {
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getProjectId());
        qfilter.and("isinvite", "=", (Object)"1");
        qfilter.and("supplier", "not in", context.getExistSupplierIds());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("supplier.id")));
    }

    public static Set<Long> getPackageSet(ExtPluginContext context) {
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopenpackage", (String)"package.id", (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
    }

    public static boolean isBidTypeMatch(PdsOpenControlContext context, DynamicObject mytaskObj, String openType) {
        Set<Long> bizTypeSet = MultiBasedataUtils.getBasedataIdSet(mytaskObj, "biztype");
        if (null == bizTypeSet || bizTypeSet.size() == 0) {
            return true;
        }
        for (long bidTypeId : bizTypeSet) {
            if (!context.getOpentypeBidtypeMap().get(openType).contains(bidTypeId)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getExistKeySet(PdsOpenControlContext context, String entityName) {
        String selectFields = "package.id,supplier.id,bidder.id,opentype";
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return new HashSet<String>();
        }
        Set supplierIds = rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        context.getExistSupplierIds().addAll(supplierIds);
        Map<String, List<DynamicObject>> keyMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("package.id") + '_' + e.getString("supplier.id") + '_' + e.getString("bidder.id") + '_' + e.getString("opentype")));
        return new HashSet<String>(keyMap.keySet());
    }

    public static QFilter getSupEncryptUserFilter() {
        Set<Long> supplierUserIds = SupplierUtil.getSupplierUserIdsByCurrUserId();
        QFilter userFilter = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter supUserFilter = ExtFilterUtils.getMultiBaseDataFilter("supplieruser", supplierUserIds);
        QFilter userFilter2 = new QFilter("bidder", "=", (Object)0L).and(supUserFilter);
        userFilter.or(userFilter2);
        return userFilter;
    }

    public static void getHandleInfo(DynamicObjectCollection rows, SrcMyTaskContext context) {
        context.setHandleIds(rows.stream().filter(e -> e.getLong("id") > 0L).map(e -> e.getLong("id")).collect(Collectors.toSet()));
        context.setProjectIds(rows.stream().filter(e -> e.getLong("project.id") > 0L).map(e -> e.getLong("project.id")).collect(Collectors.toSet()));
        context.setPackageIds(rows.stream().filter(e -> e.getLong("package.id") > 0L).map(e -> e.getLong("package.id")).collect(Collectors.toSet()));
        context.setSupplierIds(rows.stream().filter(e -> e.getLong("supplier.id") > 0L).map(e -> e.getLong("supplier.id")).collect(Collectors.toSet()));
        context.setOpenTypes(rows.stream().filter(e -> !StringUtils.isBlank((CharSequence)e.getString("opentype"))).map(e -> e.getString("opentype")).collect(Collectors.toSet()));
    }

    public static Map<String, Object> getHandleInfoMap(SrcMyTaskContext context) {
        HashMap<String, Object> handleInfoMap = new HashMap<String, Object>(4);
        handleInfoMap.put("id", context.getHandleIds());
        handleInfoMap.put("project", context.getProjectIds());
        handleInfoMap.put("package", context.getPackageIds());
        handleInfoMap.put("supplier", context.getSupplierIds());
        handleInfoMap.put("opentype", context.getOpenTypes());
        handleInfoMap.put("message", context.getVerifyMessage());
        return handleInfoMap;
    }

    public static String getOpenTypeByOpkey(String opKey) {
        String openType = "2";
        if ("aptopen".equals(opKey)) {
            openType = "1";
        } else if ("allopen".equals(opKey) || "tecopen".equals(opKey)) {
            openType = "2";
        } else if ("bizopen".equals(opKey)) {
            openType = "3";
        }
        return openType;
    }

    public static QFilter getBaseFilter(PdsOpenControlContext context, boolean isControlByPkg) {
        QFilter baseFilter = new QFilter("project", "=", (Object)context.getProjectId());
        baseFilter.and("opentype", "=", (Object)context.getOpenType());
        baseFilter.and("isterminate", "=", (Object)"0");
        if (isControlByPkg && context.getManageType().equals("2") && null != context.getOpenPackageIds() && context.getOpenPackageIds().size() > 0) {
            baseFilter.and("package", "in", context.getOpenPackageIds());
        }
        if (context.isOpenBySupplier() && null != context.getOpenSupplierIds() && context.getOpenSupplierIds().size() > 0) {
            baseFilter.and("supplier", "in", context.getOpenSupplierIds());
        }
        return baseFilter;
    }

    public static StringBuilder verifyFinishNum(String title, String passType, int finishNum, int allNum) {
        StringBuilder sb = new StringBuilder();
        switch (passType) {
            case "1": {
                if (finishNum != 0) break;
                sb.append((CharSequence)PdsOpenControlUtils.buildMessage(title, finishNum, 1));
                break;
            }
            case "2": {
                if (finishNum >= PdsCommonUtils.getMoreThanHalfCount(allNum)) break;
                sb.append((CharSequence)PdsOpenControlUtils.buildMessage(title, finishNum, PdsCommonUtils.getMoreThanHalfCount(allNum)));
                break;
            }
            case "3": {
                if (finishNum >= allNum) break;
                sb.append((CharSequence)PdsOpenControlUtils.buildMessage(title, finishNum, allNum));
                break;
            }
        }
        return sb;
    }

    private static StringBuilder buildMessage(String title, int count1, int count2) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d%1$s\u4eba\u6570\u4e3a(%2$s), \u4e0d\u7b26\u5408\u6700\u4f4e\u4eba\u6570\u8981\u6c42(%3$s)", (String)"PdsOpenControlUtils_0", (String)"scm-pds-common", (Object[])new Object[0]), title, count1, count2));
        return sb;
    }

    public static boolean isExistsSupUnProcessTask(DynamicObject billObj) {
        if (!billObj.getBoolean("project.isopencontrol")) {
            return false;
        }
        String openStatus = billObj.getString("project.openstatus");
        if (!(BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.BIZOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.OPEN.getValue().equals(openStatus))) {
            return false;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("project"));
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and(new QFilter("isencrypt", "=", (Object)"0").or("isdecrypt", "=", (Object)"0"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        qfilters.and("supplier", "=", (Object)supplierId);
        QFilter userFilter = ExtFilterUtils.getMultiBaseDataFilter("supplieruser", SupplierUtil.getSupplierUserIdsByCurrUserId());
        qfilters.and(userFilter);
        return QueryServiceHelper.exists((String)"pds_supencryptdetail", (QFilter[])qfilters.toArray());
    }

    public static void getSchemeRoleMap(long projectId, Map<String, Set<Long>> openRoleMap, Map<String, Set<Long>> encryptRoleMap) {
        DynamicObject baseInfoObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_base");
        if (null == baseInfoObj) {
            return;
        }
        if (!baseInfoObj.getBoolean("isopencontrol")) {
            return;
        }
        PdsOpenControlUtils.getRoleSet(baseInfoObj, "aptscheme", "1", openRoleMap, encryptRoleMap);
        PdsOpenControlUtils.getRoleSet(baseInfoObj, "tecscheme", "2", openRoleMap, encryptRoleMap);
        PdsOpenControlUtils.getRoleSet(baseInfoObj, "bizscheme", "3", openRoleMap, encryptRoleMap);
    }

    public static void getRoleSet(DynamicObject baseInfoObj, String schemeField, String type, Map<String, Set<Long>> openRoleMap, Map<String, Set<Long>> encryptRoleMap) {
        DynamicObject schemeObj = baseInfoObj.getDynamicObject(schemeField);
        if (null != schemeObj) {
            DynamicObjectCollection rows = schemeObj.getDynamicObjectCollection("openrole");
            if (rows.size() > 0) {
                openRoleMap.put(type, rows.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet()));
            }
            if ((rows = schemeObj.getDynamicObjectCollection("encryptrole")).size() > 0) {
                encryptRoleMap.put(type, rows.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet()));
            }
        }
    }

    public static void updateBidder(long projectId, Map<String, Map<Long, Long>> openRoleUserMap, String entityName) {
        DynamicObject[] rows;
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("isterminate", "=", (Object)"0");
        if ("pds_encryptdetail".equals(entityName)) {
            qfilter.and("isdecrypt", "=", (Object)"0");
        }
        if ("pds_bidopendetail".equals(entityName)) {
            qfilter.and("isbidopen", "=", (Object)"0");
        }
        if (null == (rows = PdsCommonUtils.loadBillObjsByQFilter(entityName, qfilter)) || rows.length == 0) {
            return;
        }
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(rows.length);
        for (DynamicObject row : rows) {
            PdsOpenControlUtils.updateBidder(entityName, row, openRoleUserMap, objList);
        }
        if (objList.size() > 0) {
            PdsCommonUtils.saveDynamicObjects(objList);
        }
    }

    public static void updateBidder(String entityName, DynamicObject row, Map<String, Map<Long, Long>> roleUserMap, List<DynamicObject> objList) {
        long newBidderId;
        String openType = row.getString("opentype");
        Map<Long, Long> userMap = roleUserMap.get(openType);
        if (null != userMap && userMap.size() > 0 && (newBidderId = PdsCommonUtils.object2Long(userMap.get(row.getLong("bidder.id")))) > 0L) {
            row.set("bidder", (Object)newBidderId);
            if ("pds_encryptdetail".equals(entityName) && row.getString("isencrypt").equals("true")) {
                row.set("encryptcode", null);
                row.set("isencrypt", (Object)"0");
                row.set("encryptdate", null);
            }
            objList.add(row);
        }
    }

    public static void getRoleUserMap(DynamicObject proManChgObj, Map<String, Set<Long>> openRoleMap, Map<String, Set<Long>> encryptRoleMap, Map<String, Map<Long, Long>> openRoleUserMap, Map<String, Map<Long, Long>> encryptRoleUserMap) {
        DynamicObjectCollection rows = proManChgObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            PdsOpenControlUtils.addUserKeyToMap("1", row, openRoleMap, encryptRoleMap, openRoleUserMap, encryptRoleUserMap);
            PdsOpenControlUtils.addUserKeyToMap("2", row, openRoleMap, encryptRoleMap, openRoleUserMap, encryptRoleUserMap);
            PdsOpenControlUtils.addUserKeyToMap("3", row, openRoleMap, encryptRoleMap, openRoleUserMap, encryptRoleUserMap);
        }
    }

    public static void addUserKeyToMap(String type, DynamicObject row, Map<String, Set<Long>> openRoleMap, Map<String, Set<Long>> encryptRoleMap, Map<String, Map<Long, Long>> openRoleUserMap, Map<String, Map<Long, Long>> encryptRoleUserMap) {
        long bizroleId = row.getLong("bizrole.id");
        long bidderId = row.getLong("bidder.id");
        long newBidderId = row.getLong("newbidder.id");
        if (bizroleId == 0L || bidderId == 0L || newBidderId == 0L) {
            return;
        }
        PdsOpenControlUtils.addUserKeyToMap(type, bizroleId, bidderId, newBidderId, openRoleMap, openRoleUserMap);
        PdsOpenControlUtils.addUserKeyToMap(type, bizroleId, bidderId, newBidderId, encryptRoleMap, encryptRoleUserMap);
    }

    public static void addUserKeyToMap(String type, long bizroleId, long bidderId, long newBidderId, Map<String, Set<Long>> roleMap, Map<String, Map<Long, Long>> roleUserMap) {
        if (null != roleMap.get(type) && roleMap.get(type).contains(bizroleId)) {
            Map<Long, Long> userMap = roleUserMap.get(type);
            if (null == userMap) {
                userMap = new HashMap<Long, Long>();
            }
            userMap.put(bidderId, newBidderId);
            roleUserMap.put(type, userMap);
        }
    }
}

