/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol;

import java.util.EventObject;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.pds.common.mytask.SrcMyTaskContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlFacade;
import kd.scm.pds.common.opencontrol.PdsOpenEncryptUtils;
import kd.scm.pds.common.opencontrol.process.PdsBidOpenTaskProcess;
import kd.scm.pds.common.opencontrol.process.PdsDecryptTaskProcess;
import kd.scm.pds.common.opencontrol.process.PdsEncryptTaskProcess;
import kd.scm.pds.common.opencontrol.process.PdsSupDecryptTaskProcess;
import kd.scm.pds.common.opencontrol.process.PdsSupEncryptTaskProcess;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsOpenToolCommonEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PdsCommonUtils.setMultiBasedataValue(this.getView(), "project");
        PdsCommonUtils.setMultiBasedataValue(this.getView(), "package");
        PdsCommonUtils.setMultiBasedataValue(this.getView(), "supplier");
        PdsCommonUtils.setMultiListValue(this.getView(), "opentype");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (opKey.equals("refresh") || opKey.equals("close")) {
            return;
        }
        evt.setCancel(true);
        String verifyMessage = null;
        String message = this.getView().getFormShowParameter().getCustomParam("message").toString();
        switch (opKey) {
            case "encrypt": {
                verifyMessage = PdsOpenEncryptUtils.encryptVerify(this.getModel().getDataEntity());
                if (null == verifyMessage) {
                    this.getView().showConfirm(message, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(opKey));
                    break;
                }
                this.getView().showTipNotification(verifyMessage);
                break;
            }
            case "decrypt": {
                verifyMessage = PdsOpenEncryptUtils.decryptVerify(this.getModel().getDataEntity());
                if (null == verifyMessage) {
                    this.getView().showConfirm(message, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(opKey));
                    break;
                }
                this.getView().showTipNotification(verifyMessage);
                break;
            }
            case "bidopen": {
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(opKey));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (!e.getResult().equals((Object)MessageBoxResult.Yes)) {
            return;
        }
        Set<Long> handleIds = PdsCommonUtils.getSetFormShowParam(this.getView(), "id");
        SrcMyTaskContext context = new SrcMyTaskContext();
        context.setCurrView(this.getView());
        context.setHandleIds(handleIds);
        switch (e.getCallBackId()) {
            case "encrypt": {
                PdsOpenEncryptUtils.getAesEncryptCode(this.getModel().getDataEntity(), context);
                if (PdsCommonUtils.isTnd(this.getView().getFormShowParameter().getAppId(), RequestContext.get().getUserType())) {
                    PdsOpenControlFacade.taskProcess(context, PdsSupEncryptTaskProcess.class.getSimpleName());
                } else {
                    PdsOpenControlFacade.taskProcess(context, PdsEncryptTaskProcess.class.getSimpleName());
                }
                if (context.isHandleOk()) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u52a0\u5bc6\u6210\u529f\u3002", (String)"PdsOpenToolCommonEdit_0", (String)"scm-pds-common", (Object[])new Object[0]));
                    break;
                }
                this.getView().getParentView().showErrorNotification(context.getHandleMessage());
                break;
            }
            case "decrypt": {
                PdsOpenEncryptUtils.getAesEncryptCode(this.getModel().getDataEntity(), context);
                String supplierId = PdsCommonUtils.object2String(PdsCommonUtils.getCustomParamValue(this.getView(), "supplier"), "");
                if (supplierId.length() > 0) {
                    PdsOpenControlFacade.taskProcess(context, PdsSupDecryptTaskProcess.class.getSimpleName());
                } else {
                    PdsOpenControlFacade.taskProcess(context, PdsDecryptTaskProcess.class.getSimpleName());
                }
                if (context.isHandleOk()) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u5bc6\u6210\u529f\u3002", (String)"PdsOpenToolCommonEdit_1", (String)"scm-pds-common", (Object[])new Object[0]));
                    break;
                }
                this.getView().getParentView().showErrorNotification(context.getHandleMessage());
                break;
            }
            case "bidopen": {
                PdsOpenControlFacade.taskProcess(context, PdsBidOpenTaskProcess.class.getSimpleName());
                break;
            }
        }
        if (context.isHandleOk()) {
            PdsCommonUtils.refreshParentView(this.getView());
            this.getView().close();
        } else {
            this.getView().showTipNotification(context.getHandleMessage());
        }
    }
}

