/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.control;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.opencontrol.control.IPdsOpenControlValidator;
import kd.scm.pds.common.util.PdsCommonUtils;

public class PdsBidOpenTaskValidator
implements IPdsOpenControlValidator {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsOpenControlContext context) {
        this.openTaskValidate(context);
    }

    protected void openTaskValidate(PdsOpenControlContext context) {
        QFilter baseFilter = PdsOpenControlUtils.getBaseFilter(context, context.getOpenTypeSchemeObj().getBoolean("isopenbypkg"));
        DynamicObjectCollection allRows = QueryServiceHelper.query((String)"pds_bidopendetail", (String)"id,isbidopen", (QFilter[])baseFilter.toArray());
        if (allRows.size() == 0) {
            return;
        }
        List finishRows = allRows.stream().filter(e -> e.getBoolean("isbidopen")).collect(Collectors.toList());
        String passType = PdsCommonUtils.object2String(context.getOpenTypeSchemeObj().get("openpass"), "3");
        StringBuilder message = PdsOpenControlUtils.verifyFinishNum(ResManager.loadKDString((String)"\u5df2\u5f00\u6807", (String)"PdsBidOpenTaskValidator_0", (String)"scm-pds-common", (Object[])new Object[0]), passType, finishRows.size(), allRows.size());
        if (message.length() > 0) {
            context.setSucced(false);
            context.setMessage(message);
        }
    }
}

