/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.opencontrol.control;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.opencontrol.PdsOpenControlContext;
import kd.scm.pds.common.opencontrol.control.IPdsOpenControlValidator;

public class PdsNeedOpenCtlValidator
implements IPdsOpenControlValidator {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(PdsOpenControlContext context) {
        this.isNeedOpenCtlValidate(context);
    }

    protected void isNeedOpenCtlValidate(PdsOpenControlContext context) {
        DynamicObject baseInfoObj = context.getBaseInfoObj();
        if (null == baseInfoObj && context.getProjectId() > 0L) {
            baseInfoObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_project_base");
        }
        if (null == baseInfoObj) {
            context.setNeedOpenCtlValidate(false);
            return;
        }
        if (!baseInfoObj.getBoolean("isopencontrol")) {
            context.setNeedOpenCtlValidate(false);
            return;
        }
        DynamicObject aptSchemeObj = baseInfoObj.getDynamicObject("aptscheme");
        context.setAptSchemeObj(aptSchemeObj);
        DynamicObject tecSchemeObj = baseInfoObj.getDynamicObject("tecscheme");
        context.setTecSchemeObj(tecSchemeObj);
        DynamicObject bizSchemeObj = baseInfoObj.getDynamicObject("bizscheme");
        context.setBizSchemeObj(bizSchemeObj);
        if (null == context.getOperationKey()) {
            return;
        }
        switch (context.getOperationKey()) {
            case "aptopen": {
                if (null == aptSchemeObj) {
                    context.setNeedOpenCtlValidate(false);
                    return;
                }
                context.setOpenTypeSchemeObj(aptSchemeObj);
                break;
            }
            case "allopen": 
            case "tecopen": {
                if (null == tecSchemeObj) {
                    context.setNeedOpenCtlValidate(false);
                    return;
                }
                context.setOpenTypeSchemeObj(tecSchemeObj);
                break;
            }
            case "bizopen": {
                if (null == bizSchemeObj) {
                    context.setNeedOpenCtlValidate(false);
                    return;
                }
                context.setOpenTypeSchemeObj(bizSchemeObj);
                break;
            }
        }
    }
}

